/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Map;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiMenu;
import org.miwarre.ap.gui.GuiScrollList;

class GuiAreaList
extends GuiMenu {
    private static final int MAX_NUM_OF_MENULINES = 25;
    private final GuiDefs.GuiCallback callback;
    private boolean hasItems;
    private final boolean ownedOnly;
    private final Player player;

    public GuiAreaList(Player player, boolean ownedOnly, GuiDefs.GuiCallback callback) {
        super(AreaProtection.plugin, Msgs.msg[79], null, -25);
        this.setCallback(new MenuHandler());
        this.callback = callback;
        this.hasItems = false;
        this.ownedOnly = ownedOnly;
        this.player = player;
        this.fillList(null);
    }

    private void fillList(String filter) {
        Map<Integer, ProtArea> areas;
        Map<Integer, ProtArea> map = areas = this.ownedOnly ? Db.getAreas() : Db.getOwnedAreas(this.player);
        if (filter != null && filter.length() > 1) {
            for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
                ProtArea area = entry.getValue();
                if (!area.getName().contains(filter)) continue;
                this.addTextItem(area.getName() + " (" + AreaProtection.getAreaCentre(area) + ")", entry.getKey(), (Object)area);
                this.hasItems = true;
            }
        } else {
            for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
                ProtArea area = entry.getValue();
                this.addTextItem(area.getName() + " (" + AreaProtection.getAreaCentre(area) + ")", entry.getKey(), (Object)area);
                this.hasItems = true;
            }
        }
        if (!this.hasItems) {
            this.addTextItem(Msgs.msg[this.ownedOnly ? 69 : 70], 1, null);
        }
    }

    private class MenuHandler
    implements GuiDefs.GuiCallback {
        private MenuHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object obj) {
            if (id == -1) {
                return;
            }
            if (id == -2) {
                if (obj != null && ((String)obj).length() > 1) {
                    GuiScrollList panel = (GuiScrollList)GuiAreaList.this.getPanel();
                    panel.hide(player);
                    panel.clear(player);
                    GuiAreaList.this.fillList((String)obj);
                    GuiAreaList.this.layout();
                    panel.show(player);
                }
                return;
            }
            GuiAreaList.this.pop(player);
            if (!GuiAreaList.this.hasItems) {
                id = -1;
            }
            if (GuiAreaList.this.callback != null) {
                GuiAreaList.this.callback.onCall(player, id, obj);
            }
        }
    }
}

