/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiModalWindow;

public class GuiAreaExtentEdit
extends GuiModalWindow {
    private static final int PANEL_HEIGHT = 227;
    private static final int PANEL_WIDTH = 400;
    private static final int WINDOW_HEIGHT = 257;
    private static final int N_LBL_Y = 221;
    private static final int N_TXT_Y = 225;
    private static final int W_LBL_Y = 196;
    private static final int W_TXT_Y = 200;
    private static final int E_LBL_Y = 196;
    private static final int E_TXT_Y = 200;
    private static final int S_LBL_Y = 171;
    private static final int S_TXT_Y = 175;
    private static final int BOTTOM_LBL_Y = 137;
    private static final int BOTTOM_TXT_Y = 141;
    private static final int TOP_LBL_Y = 137;
    private static final int TOP_TXT_Y = 141;
    private static final int CENTRE_LBL_Y = 103;
    private static final int EXTENT_LBL_Y = 82;
    private static final int BUTT_Y = 30;
    private static final int TXT_WIDTH = 50;
    private static final int N_TXT_ID = 1;
    private static final int W_TXT_ID = 2;
    private static final int E_TXT_ID = 3;
    private static final int S_TXT_ID = 4;
    private static final int TOP_TXT_ID = 5;
    private static final int BOTTOM_TXT_ID = 6;
    private static final int DEFAULTBUTT_ID = 7;
    private static final int BUTTON_ID = 8;
    private final GuiDefs.GuiCallback callerCallback;
    private final ProtArea.Extent extent;
    private final GuiLabel centreLbl;
    private final GuiLabel extentLbl;
    private final GuiTextField nText;
    private final GuiTextField wText;
    private final GuiTextField eText;
    private final GuiTextField sText;
    private final GuiTextField tText;
    private final GuiTextField bText;

    public GuiAreaExtentEdit(ProtArea.Extent extent, String areaName, Player player, GuiDefs.GuiCallback callback) {
        super(AreaProtection.plugin, String.format(Msgs.msg[78], areaName), 0, 0, null);
        this.setCallback(new DlgHandler());
        this.callerCallback = callback;
        this.extent = extent;
        int panelWidth = Math.max(this.getTitleBarMinWidth(), 400);
        this.setPanelSize(panelWidth, 227);
        int x = (panelWidth - 6) / 2;
        GuiLabel label = this.addTextItem(Msgs.msg[11], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)(panelWidth / 2), 221.0f, false);
        this.nText = new GuiTextField((float)(x + 6), 225.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.nText, 1, null);
        label = this.addTextItem(Msgs.msg[13], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)x, 171.0f, false);
        this.sText = new GuiTextField((float)(x + 6), 175.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.sText, 4, null);
        label = this.addTextItem(Msgs.msg[75], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)x, 137.0f, false);
        this.tText = new GuiTextField((float)(x + 6), 141.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.tText, 5, null);
        x = panelWidth / 4;
        label = this.addTextItem(Msgs.msg[14], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)x, 196.0f, false);
        this.wText = new GuiTextField((float)(x + 6), 200.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.wText, 2, null);
        label = this.addTextItem(Msgs.msg[76], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)x, 137.0f, false);
        this.bText = new GuiTextField((float)(x + 6), 141.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.bText, 6, null);
        label = this.addTextItem(Msgs.msg[12], 0, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition((float)(x *= 3), 196.0f, false);
        this.eText = new GuiTextField((float)(x + 6), 200.0f, false, 50.0f, 23.0f, false);
        this.addChild((GuiElement)this.eText, 3, null);
        label = this.addTextItem(Msgs.msg[77], 7, null);
        label.setPivot(PivotPosition.TopLeft);
        label.setPosition((float)(x + 6), 137.0f, false);
        label.setColor(6344959);
        label.setClickable(true);
        this.centreLbl = this.addTextItem("", 0, null);
        this.centreLbl.setPivot(PivotPosition.TopLeft);
        this.centreLbl.setPosition(6.0f, 103.0f, false);
        this.extentLbl = this.addTextItem("", 0, null);
        this.extentLbl.setPivot(PivotPosition.TopLeft);
        this.extentLbl.setPosition(6.0f, 82.0f, false);
        this.setTexts();
        label = this.addTextItem(Msgs.msg[64], 8, null);
        label.setPivot(PivotPosition.Center);
        label.setPosition((float)(panelWidth / 2), 30.0f, false);
        label.setColor(6344959);
        this.setSize(panelWidth + 2 * (int)this.getBorderThickness(), 257 + 2 * (int)this.getBorderThickness(), false);
    }

    private void setTexts() {
        if (this.nText != null) {
            this.nText.setText(String.valueOf(this.extent.getMaxZ()));
        }
        if (this.sText != null) {
            this.sText.setText(String.valueOf(this.extent.getMinZ()));
        }
        if (this.wText != null) {
            this.wText.setText(String.valueOf(this.extent.getMaxX()));
        }
        if (this.eText != null) {
            this.eText.setText(String.valueOf(this.extent.getMinX()));
        }
        if (this.tText != null) {
            this.tText.setText(String.valueOf(this.extent.getMaxY()));
        }
        if (this.bText != null) {
            this.bText.setText(String.valueOf(this.extent.getMinY()));
        }
        if (this.centreLbl != null) {
            float centreN = (float)(this.extent.getMaxZ() + this.extent.getMinZ() + 1) * 0.5f;
            float centreE = (float)(this.extent.getMaxX() + this.extent.getMinX() + 1) * 0.5f;
            float centreH = (float)(this.extent.getMaxY() + this.extent.getMinY() + 1) * 0.5f;
            String nSign = Msgs.msg[11];
            String eSign = Msgs.msg[14];
            if (centreN < 0.0f) {
                nSign = Msgs.msg[13];
            }
            if (centreE < 0.0f) {
                eSign = Msgs.msg[12];
            }
            this.centreLbl.setText(String.format(Msgs.msg[16], Float.valueOf(centreE), eSign, Float.valueOf(centreH), Float.valueOf(centreN), nSign));
        }
        if (this.extentLbl != null) {
            this.extentLbl.setText(String.format(Msgs.msg[17], this.extent.getMaxX() - this.extent.getMinX() + 1, this.extent.getMaxY() - this.extent.getMinY() + 1, this.extent.getMaxZ() - this.extent.getMinZ() + 1));
        }
    }

    private class DlgHandler
    implements GuiDefs.GuiCallback {
        private DlgHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            switch (id) {
                case 1: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMaxZ();
                    }
                    GuiAreaExtentEdit.this.extent.setMaxZ(iVal);
                    break;
                }
                case 2: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMinX();
                    }
                    GuiAreaExtentEdit.this.extent.setMinX(iVal);
                    break;
                }
                case 3: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMaxX();
                    }
                    GuiAreaExtentEdit.this.extent.setMaxX(iVal);
                    break;
                }
                case 4: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMinZ();
                    }
                    GuiAreaExtentEdit.this.extent.setMinZ(iVal);
                    break;
                }
                case 5: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMaxY();
                    }
                    GuiAreaExtentEdit.this.extent.setMaxY(iVal);
                    break;
                }
                case 6: {
                    int iVal;
                    if (data == null) {
                        return;
                    }
                    try {
                        iVal = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        iVal = GuiAreaExtentEdit.this.extent.getMinY();
                    }
                    GuiAreaExtentEdit.this.extent.setMaxY(iVal);
                    break;
                }
                case 7: {
                    GuiAreaExtentEdit.this.extent.setMaxY(AreaProtection.heightTop);
                    GuiAreaExtentEdit.this.extent.setMinY(AreaProtection.heightBottom);
                    break;
                }
                case 8: {
                    if (GuiAreaExtentEdit.this.callerCallback != null) {
                        GuiAreaExtentEdit.this.callerCallback.onCall(player, 0, GuiAreaExtentEdit.this.extent);
                    }
                    GuiAreaExtentEdit.this.pop(player);
                }
                default: {
                    return;
                }
            }
            GuiAreaExtentEdit.this.setTexts();
        }
    }
}

