/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.risingworld.api.Server;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.BoundingInformation;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.WorldArea;
import net.risingworld.api.worldelements.WorldElement;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.ProtArea;

public class Db {
    static final int LIST_TYPE_PLAYER = 1;
    static final int LIST_TYPE_GROUP = 2;
    static final int LIST_TYPE_MANAGERS = 3;
    private static Map<Integer, ProtArea> areas = null;
    static Map<Integer, String> groupNames = null;
    private static Map<String, Integer> groupIds = null;
    private static Map<Integer, String> playerNames = null;
    private static Database db = null;

    static void init() {
        if (db == null) {
            db = AreaProtection.plugin.getSQLiteConnection(AreaProtection.plugin.getPath() + "/ap-" + AreaProtection.plugin.getWorld().getName() + ".db");
        }
        db.execute("CREATE TABLE IF NOT EXISTS `areas` (`id`      INTEGER PRIMARY KEY, `from_x`  INTEGER  NOT NULL DEFAULT ( 0 ),`from_y`  INTEGER  NOT NULL DEFAULT ( 0 ),`from_z`  INTEGER  NOT NULL DEFAULT ( 0 ),`to_x`    INTEGER  NOT NULL DEFAULT ( 0 ),`to_y`    INTEGER  NOT NULL DEFAULT ( 0 ),`to_z`    INTEGER  NOT NULL DEFAULT ( 0 ),`a_perm`  INTEGER NOT NULL DEFAULT ( 0 ),`name`    CHAR(64) NOT NULL DEFAULT ('[NoName]'));");
        db.execute("CREATE TABLE IF NOT EXISTS `users` (`id`      INTEGER PRIMARY KEY,`area_id` INTEGER NOT NULL DEFAULT ( 0 ),`user_id` INTEGER NOT NULL DEFAULT ( 0 ),`u_perm`  INTEGER NOT NULL DEFAULT ( 0 ),UNIQUE (`user_id`, `area_id`) ON CONFLICT REPLACE );");
        db.execute("CREATE INDEX IF NOT EXISTS `user` ON `users` (`user_id`);");
        db.execute("CREATE TABLE IF NOT EXISTS `perm_groups` (`id`      INTEGER PRIMARY KEY,`name`    CHAR(64) NOT NULL DEFAULT ('[NoName]') UNIQUE ON CONFLICT REPLACE);");
        db.execute("CREATE TABLE IF NOT EXISTS `groups` (`id`       INTEGER PRIMARY KEY,`area_id`  INTEGER NOT NULL DEFAULT ( 0 ),`group_id` INTEGER NOT NULL DEFAULT ( 0 ),`g_perm`   INTEGER NOT NULL DEFAULT ( 0 ),UNIQUE (`group_id`, `area_id`) ON CONFLICT REPLACE );");
        db.execute("CREATE INDEX IF NOT EXISTS `group` ON `groups` (`group_id`);");
        areas = new LinkedHashMap<Integer, ProtArea>();
        Db.initAreas();
        Db.initGroups();
        Db.AP3LUAImport();
    }

    static void deinit() {
        Server server = AreaProtection.plugin.getServer();
        for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
            ProtArea area = entry.getValue();
            server.removeArea((Area)area);
        }
        areas.clear();
        db.close();
        db = null;
    }

    static void loadPlayer(Player player) {
        player.setAttribute("com.mwr.apIsAdmin", (Object)player.isAdmin());
        HashMap<Integer, Long> permAreas = new HashMap<Integer, Long>();
        player.setAttribute("com.mwr.apAreas", permAreas);
        HashMap inAreas = new HashMap();
        player.setAttribute("com.mwr.apInAreas", inAreas);
        player.setAttribute("com.mwr.apPerms", (Object)-1L);
        try {
            ResultSet result = db.executeQuery("SELECT `area_id`,`u_perm` FROM `users` WHERE `user_id` = " + player.getDbID());
            Object object = null;
            try {
                while (result.next()) {
                    int areaId = result.getInt(1);
                    if (areaId == -1) {
                        player.setAttribute("com.mwr.apIsAdmin", (Object)true);
                        continue;
                    }
                    permAreas.put(areaId, result.getLong(2));
                }
            }
            catch (Throwable areaId) {
                object = areaId;
                throw areaId;
            }
            finally {
                if (result != null) {
                    if (object != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable areaId) {
                            ((Throwable)object).addSuppressed(areaId);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (player.isFlying()) {
            Vector3f pos = player.getPosition();
            for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
                ProtArea area = entry.getValue();
                if (!area.isPointInArea(pos)) continue;
                Db.onPlayerArea(player, area, true);
            }
        }
    }

    static int onPlayerArea(Player player, Area rwArea, boolean enter) {
        ProtArea area = Db.matchArea(rwArea);
        if (area == null) {
            return -5;
        }
        HashMap inAreas = (HashMap)player.getAttribute("com.mwr.apInAreas");
        HashMap areaPerms = (HashMap)player.getAttribute("com.mwr.apAreas");
        long cumulPerm = -1L;
        int retVal = 0;
        Long areaPerm = -1L;
        if (!((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() || AreaProtection.adminNoPriv) {
            if (areaPerms != null) {
                areaPerm = (Long)areaPerms.get(area.id);
            }
            if (areaPerm == null) {
                Long groupPerm;
                Integer groupId;
                String groupName = player.getPermissionGroup();
                areaPerm = groupName != null && !groupName.isEmpty() && (groupId = groupIds.get(groupName)) != null && (groupPerm = area.groups.get(groupId)) != null ? groupPerm : Long.valueOf(area.permissions);
            }
        }
        if (enter) {
            if ((areaPerm & 1L) == 0L) {
                return -3;
            }
            if (inAreas != null) {
                inAreas.put(area.id, areaPerm);
            }
        } else {
            if ((areaPerm & 2L) == 0L) {
                return -4;
            }
            if (inAreas != null) {
                inAreas.remove(area.id);
            }
        }
        String text = "";
        if (inAreas != null && inAreas.size() > 0) {
            cumulPerm = 0L;
            for (Map.Entry entry : inAreas.entrySet()) {
                String name = areas.get(entry.getKey()).getName();
                if (name != null) {
                    text = text + (text.isEmpty() ? " " : "| ");
                    text = text + name + " ";
                }
                cumulPerm |= ((Long)entry.getValue()).longValue();
            }
        }
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
            text = text + "| Priv. " + (AreaProtection.adminNoPriv ? "OFF" : "ON");
        }
        ((GuiLabel)player.getAttribute("com.mwr.apText")).setText(text);
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() && !AreaProtection.adminNoPriv) {
            cumulPerm = -1L;
        }
        player.setAttribute("com.mwr.apPerms", (Object)cumulPerm);
        return retVal;
    }

    static void playerText(Player player) {
        HashMap inAreas = (HashMap)player.getAttribute("com.mwr.apInAreas");
        if (inAreas != null) {
            String text = "";
            for (Map.Entry entry : inAreas.entrySet()) {
                String name = areas.get(entry.getKey()).getName();
                if (name == null) continue;
                text = text + (text.isEmpty() ? " " : "| ");
                text = text + name + " ";
            }
            if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
                text = text + "| Priv. " + (AreaProtection.adminNoPriv ? "OFF" : "ON");
            }
            ((GuiLabel)player.getAttribute("com.mwr.apText")).setText(text);
        }
    }

    static Map<Integer, ProtArea> getAreas() {
        return areas;
    }

    static int addArea(ProtArea area) {
        if (area == null) {
            return -1;
        }
        Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getStartChunkPosition(), (Vector3i)area.getStartBlockPosition());
        Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getEndChunkPosition(), (Vector3i)area.getEndBlockPosition());
        try (PreparedStatement stmt = db.getConnection().prepareStatement("INSERT INTO `areas` (from_x,from_y,from_z,to_x,to_y,to_z,a_perm,name) VALUES (" + (int)from.x + "," + (int)from.y + "," + (int)from.z + "," + (int)to.x + "," + (int)to.y + "," + (int)to.z + "," + area.permissions + ",?)");){
            stmt.setString(1, area.name);
            stmt.executeUpdate();
            try (ResultSet idSet = stmt.getGeneratedKeys();){
                if (idSet.next()) {
                    int newId;
                    area.id = newId = idSet.getInt(1);
                    Db.insertNewArea(area);
                    AreaProtection.plugin.getServer().addArea((Area)area);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
        for (Player player : AreaProtection.plugin.getServer().getAllPlayers()) {
            if (area.isPointInArea(player.getPosition())) {
                Db.onPlayerArea(player, area, true);
            }
            if (!((Boolean)player.getAttribute("com.mwr.apShown")).booleanValue()) continue;
            Db.showAreaToPlayer(player, area);
        }
        return 0;
    }

    static int deleteArea(ProtArea area) {
        int areaId = area.id;
        db.executeUpdate("DELETE FROM `users` WHERE area_id=" + areaId);
        db.executeUpdate("DELETE FROM `areas` WHERE id=" + areaId);
        AreaProtection.plugin.getServer().removeArea((Area)area);
        for (Player player : AreaProtection.plugin.getServer().getAllPlayers()) {
            HashMap permAreas;
            HashMap inAreas = (HashMap)player.getAttribute("com.mwr.apInAreas");
            if (inAreas != null && inAreas.remove(areaId) != null) {
                Db.onPlayerArea(player, area, false);
            }
            if ((permAreas = (HashMap)player.getAttribute("com.mwr.apAreas")) != null) {
                permAreas.remove(areaId);
            }
            if (!((Boolean)player.getAttribute("com.mwr.apShown")).booleanValue()) continue;
            player.removeWorldElement((WorldElement)area.worldArea);
        }
        areas.remove(area.id);
        return 0;
    }

    static int updateArea(ProtArea area) {
        if (area == null || area.id < 1) {
            return -1;
        }
        Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getStartChunkPosition(), (Vector3i)area.getStartBlockPosition());
        Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getEndChunkPosition(), (Vector3i)area.getEndBlockPosition());
        String query = "UPDATE `areas` SET from_x=" + (int)from.x + ",from_y=" + (int)from.y + ",from_z=" + (int)from.z + ",to_x=" + (int)to.x + ",to_y=" + (int)to.y + ",to_z=" + (int)to.z + ",a_perm=" + area.permissions + ",name=? WHERE id=" + area.id;
        try {
            PreparedStatement stmt = db.getConnection().prepareStatement(query);
            Object object = null;
            try {
                stmt.setString(1, area.name);
                stmt.execute();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (object != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
        ProtArea oldArea = areas.get(area.id);
        if (oldArea != null) {
            if (oldArea.getEndBlockPosition() != area.getEndBlockPosition() || oldArea.getEndChunkPosition() != area.getEndChunkPosition() || oldArea.getStartBlockPosition() != area.getStartBlockPosition() || oldArea.getStartChunkPosition() != area.getStartChunkPosition()) {
                AreaProtection.plugin.getServer().removeArea((Area)oldArea);
                AreaProtection.plugin.getServer().addArea((Area)area);
            }
            if (area != oldArea) {
                areas.put(area.id, area);
            }
            for (Player player : AreaProtection.plugin.getServer().getAllPlayers()) {
                Vector3f playerPos = player.getPosition();
                boolean nowWithin = area.isPointInArea(playerPos);
                if (nowWithin != oldArea.isPointInArea(playerPos)) {
                    Db.onPlayerArea(player, area, nowWithin);
                }
                if (!((Boolean)player.getAttribute("com.mwr.apShown")).booleanValue()) continue;
                if (oldArea.worldArea != null) {
                    player.removeWorldElement((WorldElement)oldArea.worldArea);
                }
                Db.showAreaToPlayer(player, area);
            }
        }
        return 0;
    }

    static ProtArea getAreaFromId(int id) {
        return areas.get(id);
    }

    public static long getDefaultPermissionsForPoint(Vector3f point) {
        long cumulPerm = 0L;
        boolean inSomeArea = false;
        for (ProtArea area : areas.values()) {
            if (!area.isPointInArea(point)) continue;
            cumulPerm |= area.permissions;
            inSomeArea = true;
        }
        return inSomeArea ? cumulPerm : -1L;
    }

    static int addPlayerToArea(ProtArea area, int playerId, long permissions, int type) {
        if (area == null || area.id == 0) {
            return -1;
        }
        try (PreparedStatement stmt = db.getConnection().prepareStatement(type == 2 ? "INSERT OR REPLACE INTO `groups` (area_id,group_id,g_perm) VALUES (" + area.id + ",?," + permissions + ")" : "INSERT OR REPLACE INTO `users`  (area_id,user_id,u_perm) VALUES (" + area.id + ",?," + permissions + ")");){
            stmt.setInt(1, playerId);
            stmt.executeUpdate();
            if (type == 2) {
                area.groups.put(playerId, permissions);
            } else {
                area.players.put(playerId, permissions);
                Player player = Db.connectedPlayerFromDBID(playerId);
                if (player != null) {
                    if (area.id == -1) {
                        player.setAttribute("com.mwr.apIsAdmin", (Object)true);
                    } else {
                        HashMap permAreas = (HashMap)player.getAttribute("com.mwr.apAreas");
                        if (permAreas != null) {
                            permAreas.put(area.id, permissions);
                        }
                        if (area.isPointInArea(player.getPosition())) {
                            Db.onPlayerArea(player, area, true);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
        return 0;
    }

    static int removePlayerFromArea(ProtArea area, int playerId, int type) {
        if (area == null || area.id == 0) {
            return -1;
        }
        try (PreparedStatement stmt = db.getConnection().prepareStatement(type == 2 ? "DELETE FROM `groups` WHERE group_id = ? AND area_id=" + area.id : "DELETE FROM `users`  WHERE user_id = ? AND area_id=" + area.id);){
            stmt.setInt(1, playerId);
            stmt.executeUpdate();
            if (type == 2) {
                area.groups.remove(playerId);
            } else {
                area.players.remove(playerId);
                Player player = Db.connectedPlayerFromDBID(playerId);
                if (player != null) {
                    if (area.id == -1) {
                        player.setAttribute("com.mwr.apIsAdmin", (Object)player.isAdmin());
                    } else {
                        HashMap permAreas = (HashMap)player.getAttribute("com.mwr.apAreas");
                        if (permAreas != null) {
                            permAreas.remove(area.id);
                        }
                        if (area.isPointInArea(player.getPosition())) {
                            Db.onPlayerArea(player, area, true);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -2;
        }
        return 0;
    }

    static Map<Integer, Long> getAllPlayerPermissionsForArea(int areaId, int type) {
        HashMap<Integer, Long> areaUsers = new HashMap<Integer, Long>();
        try (Statement stmt = db.getConnection().createStatement();){
            ResultSet result = stmt.executeQuery(type == 1 ? "SELECT user_id,  u_perm FROM `users`  WHERE area_id = " + areaId : "SELECT group_id, g_perm FROM `groups` WHERE area_id = " + areaId);
            while (result.next()) {
                areaUsers.put(result.getInt(1), result.getLong(2));
            }
            result.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return areaUsers;
    }

    static long getPlayerPermissionsForArea(Player player, int areaId) {
        ProtArea area;
        if (player != null) {
            Long perms;
            if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() && !AreaProtection.adminNoPriv) {
                return -1L;
            }
            HashMap permAreas = (HashMap)player.getAttribute("com.mwr.apAreas");
            if (permAreas != null && (perms = (Long)permAreas.get(areaId)) != null) {
                return perms;
            }
        }
        if ((area = areas.get(areaId)) != null) {
            return area.permissions;
        }
        return 0L;
    }

    static Map<Integer, ProtArea> getOwnedAreas(Player player) {
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
            return areas;
        }
        HashMap<Integer, ProtArea> ownedAreas = new HashMap<Integer, ProtArea>();
        try (ResultSet result = db.executeQuery("SELECT area_id FROM `users` WHERE user_id = '" + player.getDbID() + "' AND (u_perm & (" + Long.MIN_VALUE + " | " + 0x4000000000000000L + ")) != 0");){
            while (result.next()) {
                int id = result.getInt(1);
                ProtArea area = areas.get(id);
                ownedAreas.put(id, area);
            }
            result.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ownedAreas;
    }

    public static long getPlayerPermissionsForPoint(Player player, Vector3f point) {
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() && !AreaProtection.adminNoPriv) {
            return -1L;
        }
        String groupName = player.getPermissionGroup();
        Integer groupId = null;
        if (groupName != null && !groupName.isEmpty()) {
            groupId = groupIds.get(groupName);
        }
        HashMap playerPerms = (HashMap)player.getAttribute("com.mwr.apAreas");
        long cumulPerm = 0L;
        boolean inSomeArea = false;
        for (ProtArea area : areas.values()) {
            if (!area.isPointInArea(point)) continue;
            Long aPerm = (Long)playerPerms.get(area.id);
            if (aPerm == null && groupId != null) {
                aPerm = area.groups.get(groupId);
            }
            if (aPerm == null) {
                aPerm = area.permissions;
            }
            cumulPerm |= aPerm.longValue();
            inSomeArea = true;
        }
        return inSomeArea ? cumulPerm : -1L;
    }

    public static long getPlayerPermissionsForBounding(Player player, BoundingInformation bi) {
        if (((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() && !AreaProtection.adminNoPriv) {
            return -1L;
        }
        Vector3f centre = bi.getCenter();
        Vector3f minBoundary = centre.subtract(bi.getXExtent(), bi.getYExtent(), bi.getZExtent());
        Vector3f maxBoundary = centre.add(bi.getXExtent(), bi.getYExtent(), bi.getZExtent());
        Area boundArea = new Area(minBoundary, maxBoundary);
        String groupName = player.getPermissionGroup();
        Integer groupId = null;
        if (groupName != null && !groupName.isEmpty()) {
            groupId = groupIds.get(groupName);
        }
        HashMap playerPerms = (HashMap)player.getAttribute("com.mwr.apAreas");
        long cumulPerm = -1L;
        for (ProtArea area : areas.values()) {
            if (!AreaProtection.areaIntersects(area, boundArea)) continue;
            Long aPerm = (Long)playerPerms.get(area.id);
            if (aPerm == null && groupId != null) {
                aPerm = area.groups.get(groupId);
            }
            if (aPerm == null) {
                aPerm = area.permissions;
            }
            cumulPerm &= aPerm.longValue();
        }
        return cumulPerm;
    }

    public static void movePlayerToArea(Player player, Area rwArea) {
        Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getStartChunkPosition(), (Vector3i)rwArea.getStartBlockPosition());
        Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getEndChunkPosition(), (Vector3i)rwArea.getEndBlockPosition());
        Vector3f centre = new Vector3f((from.x + to.x) / 2.0f, player.getPosition().y, (from.z + to.z) / 2.0f);
        player.setFlying(true);
        player.setPosition(centre);
    }

    static boolean togglePlayerAreas(Player player) {
        boolean show;
        boolean bl = show = (Boolean)player.getAttribute("com.mwr.apShown") == false;
        if (show) {
            Db.showAreasToPlayer(player);
        } else {
            Db.hideAreasToPlayer(player);
        }
        return show;
    }

    static void showAreasToPlayer(Player player) {
        player.setAttribute("com.mwr.apShown", (Object)true);
        for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
            Db.showAreaToPlayer(player, entry.getValue());
        }
    }

    static void hideAreasToPlayer(Player player) {
        player.setAttribute("com.mwr.apShown", (Object)false);
        for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
            ProtArea area = entry.getValue();
            if (area.worldArea == null) continue;
            player.removeWorldElement((WorldElement)area.worldArea);
        }
    }

    static String getPlayerNameFromId(int playerId, int type) {
        Map<Integer, String> players = groupNames;
        if (type == 1 || type == 3) {
            if (playerNames == null) {
                Db.initPlayers();
            }
            players = playerNames;
        }
        return players.get(playerId);
    }

    static Set<Integer> getPlayerIdSet() {
        if (playerNames == null) {
            Db.initPlayers();
        }
        return playerNames.keySet();
    }

    static void resetPlayers() {
        playerNames = null;
    }

    private static void showAreaToPlayer(Player player, ProtArea area) {
        if (area.worldArea == null) {
            area.worldArea = new WorldArea((Area)area);
            area.worldArea.setColor(Utils.GeneralUtils.nextRandomColor((boolean)true));
            area.worldArea.setAlwaysVisible(false);
        }
        player.addWorldElement((WorldElement)area.worldArea);
    }

    private static void initAreas() {
        Server server = AreaProtection.plugin.getServer();
        areas.clear();
        try (ResultSet result = db.executeQuery("SELECT * FROM `areas` ORDER BY LOWER(`name`)");){
            while (result.next()) {
                int id = result.getInt(1);
                int fromX = result.getInt(2);
                int fromY = result.getInt(3);
                int fromZ = result.getInt(4);
                int toX = result.getInt(5);
                int toY = result.getInt(6);
                int toZ = result.getInt(7);
                int perm = result.getInt(8);
                String name = result.getString(9);
                ProtArea area = new ProtArea(id, fromX, fromY, fromZ, toX, toY, toZ, name, perm);
                areas.put(id, area);
                server.addArea((Area)area);
            }
            result.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static ProtArea matchArea(Area rwArea) {
        for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
            ProtArea area = entry.getValue();
            if (!area.equals(rwArea)) continue;
            return area;
        }
        return null;
    }

    private static void insertNewArea(ProtArea area) {
        if (area == null || area.id < 1) {
            return;
        }
        LinkedHashMap<Integer, ProtArea> newAreaMap = new LinkedHashMap<Integer, ProtArea>();
        for (Map.Entry<Integer, ProtArea> entry : areas.entrySet()) {
            if (area != null && entry.getValue().name.compareToIgnoreCase(area.name) > 0) {
                newAreaMap.put(area.id, area);
                area = null;
            }
            newAreaMap.put(entry.getKey(), entry.getValue());
        }
        if (area != null) {
            newAreaMap.put(area.id, area);
        }
        areas = newAreaMap;
    }

    private static void initGroups() {
        groupNames = new HashMap<Integer, String>();
        groupIds = new HashMap<String, Integer>();
        HashMap<String, Integer> dbGroups = new HashMap<String, Integer>();
        try (ResultSet result2 = db.executeQuery("SELECT * FROM `perm_groups`");){
            while (result2.next()) {
                dbGroups.put(result2.getString(2), result2.getInt(1));
            }
        }
        catch (SQLException result2) {
            // empty catch block
        }
        String path = AreaProtection.plugin.getPath() + "/../../permissions/groups/";
        File groupDir = new File(path);
        String[] rwGroups = groupDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                boolean accept = fileName.endsWith(".permissions");
                return accept;
            }
        });
        if (rwGroups != null) {
            for (String rwGroup : rwGroups) {
                String name = rwGroup.substring(0, rwGroup.length() - 12);
                Integer id = (Integer)dbGroups.get(name);
                if (id == null) {
                    try (PreparedStatement stmt = db.getConnection().prepareStatement("INSERT INTO `perm_groups` (name) VALUES (?)");){
                        stmt.setString(1, name);
                        stmt.executeUpdate();
                        try (ResultSet idSet = stmt.getGeneratedKeys();){
                            if (idSet.next()) {
                                id = idSet.getInt(1);
                            }
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (id == null) continue;
                groupNames.put(id, name);
                groupIds.put(name, id);
            }
        }
    }

    private static void initPlayers() {
        playerNames = new LinkedHashMap<Integer, String>();
        WorldDatabase worldDb = AreaProtection.plugin.getWorldDatabase();
        try (ResultSet result = worldDb.executeQuery("SELECT `ID`,`Name` FROM `Player` ORDER BY LOWER(`Name`)");){
            while (result.next()) {
                playerNames.put(result.getInt(1), result.getString(2));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void AP3LUAImport() {
        String path = AreaProtection.plugin.getPath() + "/AreaProtection";
        File LUAdb = new File(path + "/scriptDatabase.db");
        if (!LUAdb.isFile()) {
            return;
        }
        HashMap<Integer, Integer> oldId2NewId = new HashMap<Integer, Integer>();
        Database oldDb = AreaProtection.plugin.getSQLiteConnection(path + "/scriptDatabase.db");
        try (ResultSet result2 = oldDb.executeQuery("SELECT * FROM `areas`");){
            while (result2.next()) {
                int LUAid = result2.getInt(1);
                String name = result2.getString(2);
                Vector3i fromChunk = new Vector3i(result2.getInt(3), result2.getInt(4), result2.getInt(5));
                Vector3i fromBlock = new Vector3i(result2.getInt(6), result2.getInt(7), result2.getInt(8));
                Vector3i toChunk = new Vector3i(result2.getInt(9), result2.getInt(10), result2.getInt(11));
                Vector3i toBlock = new Vector3i(result2.getInt(12), result2.getInt(13), result2.getInt(14));
                Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)fromChunk, (Vector3i)fromBlock);
                Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)toChunk, (Vector3i)toBlock);
                ProtArea area = new ProtArea(from, to, name, 3L);
                Db.addArea(area);
                oldId2NewId.put(LUAid, area.id);
            }
        }
        catch (SQLException result2) {
            // empty catch block
        }
        Map<String, Long> LUAGroups = AreaProtection.initPresets(path + "/Groups");
        try (ResultSet result3 = oldDb.executeQuery("SELECT * FROM `rights`");){
            while (result3.next()) {
                Long groupPerms;
                int LUAAreaId = result3.getInt(2);
                int playerId = result3.getInt(3);
                String groupName = result3.getString(4);
                Integer newAreaId = (Integer)oldId2NewId.get(LUAAreaId);
                ProtArea area = areas.get(newAreaId);
                if (area == null || (groupPerms = LUAGroups.get(groupName)) == null) continue;
                Db.addPlayerToArea(area, playerId, groupPerms, 1);
            }
        }
        catch (SQLException result3) {
            // empty catch block
        }
        oldDb.close();
        Path oldPath = Paths.get(path + "/scriptDatabase.db", new String[0]);
        try {
            Files.move(oldPath, oldPath.resolveSibling("scriptDatabase.db.imported"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Player connectedPlayerFromDBID(int dbId) {
        Player player = null;
        Long playerUID = Db.playerDBIDtoUID(dbId);
        if (playerUID != null) {
            player = AreaProtection.plugin.getServer().getPlayer(playerUID.longValue());
        }
        return player;
    }

    private static Long playerDBIDtoUID(int dbId) {
        Long playerUID = null;
        WorldDatabase worldDb = AreaProtection.plugin.getWorldDatabase();
        try (ResultSet result = worldDb.executeQuery("SELECT `UID` FROM `Player` WHERE `ID` = " + dbId);){
            if (result.next()) {
                playerUID = result.getLong(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return playerUID;
    }
}

