/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap.gui;

import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.gui.GuiTitleBar;

public class GuiModelessWindow
extends GuiPanel {
    private static final int PANEL_XPOS = 20;
    private static final int PANEL_YPOS = 70;
    private static final int PANEL_WIDTH = 300;
    private static final int PANEL_COLOUR = -522149664;
    private static final int BORDER_COLOUR = 255;
    private static final int TEXT_COLOUR = 255;
    private static final int TEXT_XPOS = 6;
    private static final int TEXT_YDELTA = 36;
    private final Player player;
    private GuiLabel[] labels;
    private GuiTitleBar titleBar;

    public GuiModelessWindow(Plugin plugin, Player player, String titleText, List<String> texts) {
        this.player = player;
        this.setPivot(PivotPosition.TopLeft);
        this.setSize(300.0f, 0.0f, false);
        this.setBorderColor(255);
        this.setBorderThickness(2.0f, false);
        this.setColor(-522149664);
        this.setVisible(true);
        if (titleText != null && titleText.length() > 0) {
            this.titleBar = new GuiTitleBar((GuiElement)this, titleText, false);
            this.addChild((GuiElement)this.titleBar);
            this.titleBar.show(player);
        }
        player.addGuiElement((GuiElement)this);
        if (texts != null) {
            this.setTexts(texts);
        }
    }

    public void setTexts(List<String> texts) {
        int numOfTexts = texts.size();
        int panelHeight = 18 + 15 * texts.size() + 6 * (texts.size() + 3);
        int panelWidth = 0;
        if (this.titleBar != null) {
            panelWidth = this.titleBar.getMinWidth();
        }
        for (int i = 0; i < numOfTexts; ++i) {
            int textWidth = (int)(0.5f * (float)texts.get(i).length() * 15.0f);
            if (textWidth <= panelWidth) continue;
            panelWidth = textWidth;
        }
        this.setPosition(20.0f, 70 + panelHeight, false);
        this.setSize(panelWidth += 12, panelHeight, false);
        if (this.titleBar != null) {
            this.titleBar.relayout();
        }
        this.releaseTexts();
        int yPos = panelHeight - 36;
        this.labels = new GuiLabel[numOfTexts];
        for (int i = 0; i < numOfTexts; ++i) {
            this.labels[i] = new GuiLabel(texts.get(i), 6.0f, (float)yPos, false);
            this.labels[i].setPivot(PivotPosition.TopLeft);
            this.labels[i].setFontColor(255);
            this.labels[i].setFontSize(15);
            this.labels[i].setClickable(false);
            this.addChild((GuiElement)this.labels[i]);
            this.player.addGuiElement((GuiElement)this.labels[i]);
            yPos -= 21;
        }
    }

    public void free() {
        if (this.titleBar != null) {
            this.titleBar.hide(this.player);
            this.titleBar.free();
            this.removeChild((GuiElement)this.titleBar);
            this.titleBar = null;
        }
        this.player.removeGuiElement((GuiElement)this);
        this.releaseTexts();
    }

    private void releaseTexts() {
        if (this.labels != null) {
            int numOfTexts = this.labels.length;
            for (int i = 0; i < numOfTexts; ++i) {
                this.player.removeGuiElement((GuiElement)this.labels[i]);
                this.removeChild((GuiElement)this.labels[i]);
                this.labels[i] = null;
            }
            this.labels = null;
        }
    }
}

