/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap.gui;

import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroupStatic;
import org.miwarre.ap.gui.GuiModalWindow;
import org.miwarre.ap.gui.GuiScrollList;

public class GuiMessageBox
extends GuiModalWindow {
    private static final int BUTTON1_ID = 1;
    private static final int BUTTON2_ID = 2;
    private static final int BUTTON3_ID = 3;
    private static final int MAX_BUTTONS = 3;
    private static final int MIN_BUTTON_X = 50;
    private static final int BUTTON_X_DELTA = 100;
    private final GuiDefs.GuiCallback callerCallback;
    private final Object context;

    public GuiMessageBox(Plugin plugin, String titleText, String[] texts, String[] buttonTexts, Object context, GuiDefs.GuiCallback callback) {
        super(plugin, titleText, -1, 0, null);
        this.setCallback(new DlgHandler());
        this.callerCallback = callback;
        this.context = context;
        MessagePanel panel = new MessagePanel(texts, buttonTexts);
        this.setPanel(panel);
    }

    class MessagePanel
    extends GuiGroupStatic {
        GuiLabel list1Head;
        GuiLabel list2Head;
        GuiScrollList list1;
        GuiScrollList list2;

        public MessagePanel(String[] texts, String[] buttonTexts) {
            super(0);
            this.setMargin(6);
            int panelHeight = texts.length * 21 + 45 + 18;
            int y = panelHeight - 6;
            int panelWidth = 0;
            for (String text : texts) {
                GuiLabel label = this.addTextItem(text, null, null);
                label.setPosition(6.0f, (float)y, false);
                y -= 21;
                int textW = (int)GuiDefs.getTextWidth(text, 15.0f);
                if (textW <= panelWidth) continue;
                panelWidth = textW;
            }
            int maxButton = 3;
            if (buttonTexts.length < maxButton) {
                maxButton = buttonTexts.length;
            }
            int x = 50;
            y -= 22;
            for (int i = 0; i < maxButton; ++i) {
                GuiLabel label = this.addTextItem(buttonTexts[i], 1 + i, null);
                label.setPivot(PivotPosition.Center);
                label.setColor(6344959);
                label.setClickable(true);
                label.setPosition((float)x, (float)y, false);
                x += 100;
            }
            if (x > panelWidth) {
                panelWidth = x;
            }
            this.setSize(panelWidth, panelHeight, false);
        }
    }

    private class DlgHandler
    implements GuiDefs.GuiCallback {
        private DlgHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            int retId;
            switch (id) {
                case 1: {
                    retId = 0;
                    break;
                }
                case 2: {
                    retId = -1;
                    break;
                }
                case 3: {
                    retId = 1;
                    break;
                }
                default: {
                    return;
                }
            }
            GuiMessageBox.this.callerCallback.onCall(player, retId, GuiMessageBox.this.context);
            GuiMessageBox.this.pop(player);
        }
    }
}

