/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.ArrayList;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.GuiAreaEdit;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiModelessWindow;

class NewAreaCreation
extends Thread
implements Listener {
    private static final int AREASELECT_ID = 1;
    private static final int AREAEDIT_ID = 2;
    private Vector3f from;
    private Vector3f to;
    private int step;
    private final Player player;
    private boolean running;
    private boolean aborted;
    private GuiModelessWindow dataWindow;

    public NewAreaCreation(Player player) {
        this.player = player;
    }

    @Override
    public void run() {
        this.running = true;
        this.aborted = false;
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(Msgs.msg[15]);
        this.step = 1;
        this.dataWindow = new GuiModelessWindow(AreaProtection.plugin, this.player, Msgs.msg[3], texts);
        AreaProtection.plugin.registerEventListener(this);
        this.player.registerKeys(new int[]{203, 205, 200, 208, 74, 78, 201, 209, 28, 1});
        this.player.setListenForKeyInput(true);
        this.player.enableAreaSelectionTool();
        do {
            try {
                NewAreaCreation.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.running);
        this.player.disableAreaSelectionTool();
        this.player.setListenForKeyInput(false);
        this.dataWindow.free();
        this.dataWindow = null;
        if (this.aborted) {
            AreaProtection.plugin.unregisterEventListener(this);
            return;
        }
        this.running = true;
        this.step = 2;
        ProtArea area = new ProtArea(this.from, this.to, "", 3L);
        GuiAreaEdit winAreaEdit = new GuiAreaEdit(this, area, this.player, 0);
        winAreaEdit.show(this.player);
        do {
            try {
                NewAreaCreation.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.running);
        try {
            NewAreaCreation.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AreaProtection.plugin.unregisterEventListener(this);
    }

    @EventMethod
    public void OnKey(PlayerKeyEvent event) {
        if (!event.isPressed()) {
            return;
        }
        block0 : switch (this.step) {
            case 1: {
                switch (event.getKeyCode()) {
                    case 74: 
                    case 78: 
                    case 200: 
                    case 201: 
                    case 203: 
                    case 205: 
                    case 208: 
                    case 209: {
                        this.player.getAreaSelectionData((Callback)new AreaSizeGetter(false));
                        break block0;
                    }
                    case 28: {
                        this.player.getAreaSelectionData((Callback)new AreaSizeGetter(true));
                        this.aborted = false;
                        break block0;
                    }
                    case 1: {
                        this.running = false;
                        this.aborted = true;
                    }
                }
            }
        }
    }

    public void stopRun() {
        this.running = false;
    }

    private class AreaSizeGetter
    implements Callback<Area> {
        private boolean stopRunning = false;

        public AreaSizeGetter(boolean stopRunning) {
            this.stopRunning = stopRunning;
        }

        public void onCall(Area result) {
            if (result != null) {
                result.rearrange();
                ArrayList<String> texts = new ArrayList<String>();
                texts.add(Msgs.msg[15]);
                texts.add(AreaProtection.getAreaCentre(result));
                texts.add(AreaProtection.getAreaSpans(result));
                NewAreaCreation.this.dataWindow.setTexts(texts);
                if (this.stopRunning) {
                    NewAreaCreation.this.from = Utils.ChunkUtils.getGlobalPosition((Vector3i)result.getStartChunkPosition(), (Vector3i)result.getStartBlockPosition());
                    NewAreaCreation.this.to = Utils.ChunkUtils.getGlobalPosition((Vector3i)result.getEndChunkPosition(), (Vector3i)result.getEndBlockPosition());
                    NewAreaCreation.this.running = false;
                }
            }
        }
    }
}

