/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.risingworld.api.Server;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.inventory.PlayerChestDropEvent;
import net.risingworld.api.events.player.inventory.PlayerChestToInventoryEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryToChestEvent;
import net.risingworld.api.events.player.world.PlayerChangeObjectStatusEvent;
import net.risingworld.api.events.player.world.PlayerCreateBlueprintEvent;
import net.risingworld.api.events.player.world.PlayerCreativePlaceBlockEvent;
import net.risingworld.api.events.player.world.PlayerCreativePlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerCreativeTerrainEditEvent;
import net.risingworld.api.events.player.world.PlayerDestroyBlockEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerDestroyVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlockEvent;
import net.risingworld.api.events.player.world.PlayerPlaceBlueprintEvent;
import net.risingworld.api.events.player.world.PlayerPlaceConstructionEvent;
import net.risingworld.api.events.player.world.PlayerPlaceGrassEvent;
import net.risingworld.api.events.player.world.PlayerPlaceObjectEvent;
import net.risingworld.api.events.player.world.PlayerPlaceTerrainEvent;
import net.risingworld.api.events.player.world.PlayerPlaceVegetationEvent;
import net.risingworld.api.events.player.world.PlayerPlaceWaterEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveGrassEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveVegetationEvent;
import net.risingworld.api.events.player.world.PlayerRemoveWaterEvent;
import net.risingworld.api.events.world.ExplosionEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.GuiMainMenu;
import org.miwarre.ap.NewAreaCreation;

class ListenerPlayer
implements Listener {
    public static final int INFO_FONT_SIZE = 16;
    private static final int APPLE_FRUIT_ID = 46;
    private static final int CHERRY_FRUIT_ID = 47;
    private static final int LEMON_FRUIT_ID = 48;
    private static final int TOMATO_FRUIT_ID = 100;
    private static final int COTTON_FRUIT_ID = 145;
    private static final int CORN_FRUIT_ID = 151;
    private static final int CHILI_FRUIT_ID = 176;
    private static final ListenerPlayer ourInstance = new ListenerPlayer();
    private static final Set<Integer> pickables = new HashSet<Integer>(Arrays.asList(46, 47, 48, 100, 145, 151, 176));

    public static ListenerPlayer getInstance() {
        return ourInstance;
    }

    private ListenerPlayer() {
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        if (event.isNewPlayer()) {
            Db.resetPlayers();
        }
        if (AreaProtection.plugin.getServer().getType() == Server.Type.DedicatedServer) {
            this.initPlayer(event.getPlayer());
        }
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (AreaProtection.plugin.getServer().getType() != Server.Type.DedicatedServer) {
            this.initPlayer(event.getPlayer());
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        String[] cmd = event.getCommand().split(" ");
        Player player = event.getPlayer();
        switch (cmd[0]) {
            case "/showareas": {
                Db.showAreasToPlayer(player);
                break;
            }
            case "/hideareas": {
                Db.hideAreasToPlayer(player);
                break;
            }
            default: {
                if (!cmd[0].equals(AreaProtection.commandPrefix)) break;
                if (cmd.length == 1) {
                    AreaProtection.plugin.mainGui(player);
                    break;
                }
                int length = cmd[1].length();
                if (cmd[1].regionMatches(0, "showareas", 0, length)) {
                    Db.showAreasToPlayer(player);
                    break;
                }
                if (cmd[1].regionMatches(0, "hideareas", 0, length)) {
                    Db.hideAreasToPlayer(player);
                    break;
                }
                if (!((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue() && AreaProtection.adminOnly) break;
                if (cmd[1].regionMatches(0, "newarea", 0, length)) {
                    NewAreaCreation nac = new NewAreaCreation(player);
                    nac.setPriority(3);
                    nac.start();
                    break;
                }
                if (cmd[1].regionMatches(0, "gotoarea", 0, length)) {
                    GuiMainMenu mainMenu = new GuiMainMenu(player);
                    mainMenu.show(player);
                    mainMenu.command(player, 4);
                    break;
                }
                if (cmd[1].regionMatches(0, "editarea", 0, length)) {
                    GuiMainMenu mainMenu = new GuiMainMenu(player);
                    mainMenu.show(player);
                    mainMenu.command(player, 2);
                    break;
                }
                if (cmd[1].regionMatches(0, "deletearea", 0, length)) {
                    GuiMainMenu mainMenu = new GuiMainMenu(player);
                    mainMenu.show(player);
                    mainMenu.command(player, 5);
                    break;
                }
                if (!player.isAdmin()) break;
                if (cmd[1].regionMatches(0, "managers", 0, length)) {
                    GuiMainMenu mainMenu = new GuiMainMenu(player);
                    mainMenu.show(player);
                    mainMenu.command(player, 7);
                    break;
                }
                if (!cmd[1].regionMatches(0, "priv", 0, length)) break;
                ListenerPlayer.flipAdminPriv();
            }
        }
    }

    static boolean flipAdminPriv() {
        AreaProtection.adminNoPriv = !AreaProtection.adminNoPriv;
        for (Player pl : AreaProtection.plugin.getServer().getAllPlayers()) {
            if (!((Boolean)pl.getAttribute("com.mwr.apIsAdmin")).booleanValue()) continue;
            Db.playerText(pl);
        }
        return AreaProtection.adminNoPriv;
    }

    @EventMethod
    public void onPlayerEnterArea(PlayerEnterAreaEvent event) {
        int retVal = Db.onPlayerArea(event.getPlayer(), event.getArea(), true);
        if (retVal == -3) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerLeaveArea(PlayerLeaveAreaEvent event) {
        int retVal = Db.onPlayerArea(event.getPlayer(), event.getArea(), false);
        if (retVal == -4) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerPlaceBlock(PlayerPlaceBlockEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 4L, eventPos);
    }

    @EventMethod
    public void onPlayerDestroyBlock(PlayerDestroyBlockEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 8L, eventPos);
    }

    @EventMethod
    public void onPlayerPlaceConstruction(PlayerPlaceConstructionEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 16L, event.getConstructionPosition());
    }

    @EventMethod
    public void onPlayerRemoveConstruction(PlayerRemoveConstructionEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 32L, event.getConstructionPosition());
    }

    @EventMethod
    public void onPlayerDestroyConstruction(PlayerDestroyConstructionEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 64L, event.getConstructionPosition());
    }

    @EventMethod
    public void onPlayerPlaceObject(PlayerPlaceObjectEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 128L, event.getObjectPosition());
    }

    @EventMethod
    public void onPlayerRemoveObject(PlayerRemoveObjectEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 256L, event.getObjectPosition());
    }

    @EventMethod
    public void onPlayerDestroyObject(PlayerDestroyObjectEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 512L, event.getObjectPosition());
    }

    @EventMethod
    public void onPlayerPlaceTerrain(PlayerPlaceTerrainEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 1024L, eventPos);
    }

    @EventMethod
    public void onPlayerDestroyTerrain(PlayerDestroyTerrainEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 2048L, eventPos);
    }

    @EventMethod
    public void onPlayerPlaceVegetation(PlayerPlaceVegetationEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 4096L, event.getPlantPosition());
    }

    @EventMethod
    public void onPlayerRemoveVegetation(PlayerRemoveVegetationEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), pickables.contains(event.getPlantTypeID()) ? 8192L : 16384L, event.getPlantPosition());
    }

    @EventMethod
    public void onPlayerDestroyVegetation(PlayerDestroyVegetationEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 16384L, event.getPlantPosition());
    }

    @EventMethod
    public void onPlayerPlaceGrass(PlayerPlaceGrassEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 32768L, eventPos);
    }

    @EventMethod
    public void onPlayerRemoveGrass(PlayerRemoveGrassEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 65536L, eventPos);
    }

    @EventMethod
    public void onPlayerRemoveWater(PlayerRemoveWaterEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 262144L, eventPos);
    }

    @EventMethod
    public void onPlayerPlaceWater(PlayerPlaceWaterEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 131072L, eventPos);
    }

    @EventMethod
    public void onPlayerCreateBlueprint(PlayerCreateBlueprintEvent event) {
        if ((Db.getPlayerPermissionsForBounding(event.getPlayer(), event.getBoundingInformation()) & 0x80000L) == 0L) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerPlaceBlueprint(PlayerPlaceBlueprintEvent event) {
        if ((Db.getPlayerPermissionsForBounding(event.getPlayer(), event.getBoundingInformation()) & 0x100000L) == 0L) {
            event.setCancelled(true);
        }
    }

    @EventMethod
    public void onPlayerCreativePlaceBlock(PlayerCreativePlaceBlockEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x200000L, eventPos);
    }

    @EventMethod
    public void onPlayerCreativePlaceVegetation(PlayerCreativePlaceVegetationEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x400000L, event.getPlantPosition());
    }

    @EventMethod
    public void onPlayerCreativeTerrainEdit(PlayerCreativeTerrainEditEvent event) {
        Vector3f eventPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)new Vector3i(event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ()), (Vector3i)new Vector3i(event.getBlockPositionX(), event.getBlockPositionY(), event.getBlockPositionZ()));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x800000L, eventPos);
    }

    @EventMethod
    public void onPlayerInventoryToChest(PlayerInventoryToChestEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x1000000L, null);
    }

    @EventMethod
    public void onPlayerChestToInventory(PlayerChestToInventoryEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x2000000L, null);
    }

    @EventMethod
    public void onPlayerChestDrop(PlayerChestDropEvent event) {
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), 0x2000000L, null);
    }

    @EventMethod
    public void onPlayerChangeObjectStatus(PlayerChangeObjectStatusEvent event) {
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        long perm = def.isDoor() ? 0x4000000L : (def.isFurnace() ? 0x8000000L : 0x10000000L);
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), perm, event.getObjectPosition());
    }

    @EventMethod
    public void onPlayerObjectInteraction(PlayerObjectInteractionEvent event) {
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        long perm = def.isDoor() ? 0x4000000L : (def.isFurnace() ? 0x8000000L : (def.isChest() ? 0x13000000L : 0x10000000L));
        this.onCancellableEvent((Cancellable)event, event.getPlayer(), perm, event.getObjectPosition());
    }

    @EventMethod
    public void onExplosion(ExplosionEvent event) {
        Player player = null;
        WorldItem item = event.getRelatedItem();
        if (item != null) {
            player = item.getRelatedPlayer();
        }
        if (player != null) {
            if ((Db.getPlayerPermissionsForPoint(player, event.getPosition()) & 0x20000000L) == 0L) {
                event.setCancelled(true);
            }
        } else if ((Db.getDefaultPermissionsForPoint(event.getPosition()) & 0x20000000L) == 0L) {
            event.setCancelled(true);
        }
    }

    private void onCancellableEvent(Cancellable event, Player player, long permissionFlag, Vector3f eventPos) {
        if (!AreaProtection.adminNoPriv && ((Boolean)player.getAttribute("com.mwr.apIsAdmin")).booleanValue()) {
            return;
        }
        Long perms = AreaProtection.eventPos && eventPos != null ? Db.getPlayerPermissionsForPoint(player, eventPos) : (Long)player.getAttribute("com.mwr.apPerms");
        if (perms != null && (perms & permissionFlag) == 0L) {
            event.setCancelled(true);
        }
    }

    private void initPlayer(Player player) {
        player.setAttribute("com.mwr.apShown", (Object)false);
        GuiLabel info = new GuiLabel("", (float)AreaProtection.infoXPos, (float)AreaProtection.infoYPos, false);
        info.setColor(AreaProtection.infoBkgColour);
        info.setFontColor(AreaProtection.infoFontColour);
        info.setFontSize(16);
        info.setPivot(PivotPosition.BottomLeft);
        player.addGuiElement((GuiElement)info);
        player.setAttribute("com.mwr.apText", (Object)info);
        Db.loadPlayer(player);
    }
}

