/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiGroupStatic;

class GuiAreaPerms
extends GuiGroupStatic {
    private static final int PERMS_PER_ROW = 2;
    static final int NUM_OF_AREAPERMS = 30;
    private static final int AREAPERMS_PER_COLUMN = 15;
    static final int NUM_OF_PLAYERPERMS = 32;
    private static final int PLAYERPERMS_PER_COLUMN = 16;
    private static final int HEADING_X = 0;
    private static final int CHECKBOX_X = 0;
    private static final int NAME_X = 24;
    private static final int NAME_WIDTH = 200;
    private static final int COLUMN_WIDTH = 230;
    static final int PANEL_WIDTH = 460;
    static final int PANEL_HEIGHT = 357;
    private static final int HEADING_Y = 357;
    private static final int COLUMN_TOP_Y = 336;
    private long permissions;
    private GuiImage[] permOnOff;

    public GuiAreaPerms(long permissions, long permMask, boolean forArea) {
        super(0);
        this.setBorderThickness(2.0f, false);
        this.permissions = permissions;
        GuiLabel label = this.addTextItem(Msgs.msg[forArea ? 20 : 21], null, null);
        label.setPosition(0.0f, 357.0f, false);
        this.permOnOff = new GuiImage[32];
        int permId = -1;
        int permPerCol = forArea ? 15 : 16;
        int numOfPerms = forArea ? 30 : 32;
        int x = 0;
        for (int i = 0; i < 2; ++i) {
            int y = 336;
            for (int j = 0; j < permPerCol && ++permId < numOfPerms; ++j) {
                long currFlag = AreaProtection.permIdx2bit[permId];
                if ((permMask & currFlag) != 0L) {
                    this.permOnOff[permId] = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
                    this.addChild((GuiElement)this.permOnOff[permId], permId + 1, null);
                    GuiDefs.setImage(this.permOnOff[permId], (permissions & currFlag) != 0L ? 4 : 5);
                    this.permOnOff[permId].setPosition((float)(x + 0), (float)y, false);
                }
                label = this.addTextItem(Msgs.msg[22 + permId], null, null);
                label.setPosition((float)(x + 24), (float)y, false);
                y -= 21;
            }
            x += 230;
        }
        this.setSize(460.0f, 357.0f, false);
    }

    long getPermissions() {
        return this.permissions;
    }

    boolean togglePermission(int index) {
        long permToggle = AreaProtection.permIdx2bit[index];
        this.permissions ^= permToggle;
        GuiDefs.setImage(this.permOnOff[index], (this.permissions & permToggle) != 0L ? 4 : 5);
        return (this.permissions & permToggle) != 0L;
    }
}

