/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import org.miwarre.ap.AreaProtection;
import org.miwarre.ap.Db;
import org.miwarre.ap.GuiAreaExtentEdit;
import org.miwarre.ap.GuiAreaPerms;
import org.miwarre.ap.GuiPlayersEdit;
import org.miwarre.ap.Msgs;
import org.miwarre.ap.NewAreaCreation;
import org.miwarre.ap.ProtArea;
import org.miwarre.ap.gui.GuiDefs;
import org.miwarre.ap.gui.GuiModalWindow;

class GuiAreaEdit
extends GuiModalWindow {
    private static final int NAME_TXT_WIDTH = 300;
    private static final int NAME_LBL_X = 150;
    private static final int NAME_TXT_X = 156;
    private static final int HEIGHT_TOP_X = 6;
    private static final int HEIGHT_TOP_TXT_X = 106;
    private static final int HEIGHT_BOT_X = 181;
    private static final int HEIGHT_BOT_TXT_X = 281;
    private static final int DEFAULT_BUTT_X = 356;
    private static final int PERMISS_X = 6;
    private static final int PLAYERS_BUTT_X = 6;
    private static final int GROUPS_BUTT_X = 106;
    private static final int EXTENT_BUTT_X = 206;
    private static final int PANEL_HEIGHT = 470;
    private static final int WINDOW_HEIGHT = 500;
    private static final int NAME_LBL_Y = 464;
    private static final int NAME_TXT_Y = 468;
    private static final int PERMISS_Y = 439;
    private static final int PLAYERS_BUTT_Y = 76;
    private static final int GROUPS_BUTT_Y = 76;
    private static final int EXTENT_BUTT_Y = 76;
    private static final int HEIGHT_LBL_Y = 76;
    private static final int HEIGHT_TXT_Y = 80;
    private static final int DO_BUTT_Y = 33;
    private static final int NAMETEXT_ID = 32;
    private static final int PLAYERSBUTT_ID = 33;
    private static final int GROUPSBUTT_ID = 34;
    private static final int EXTENTBUTT_ID = 35;
    private static final int HEIGHTTOPTEXT_ID = 36;
    private static final int HEIGHTBOTTEXT_ID = 37;
    private static final int DEFAULTBUTT_ID = 38;
    private static final int DOBUTT_ID = 39;
    public static final int TYPE_CREATE = 0;
    public static final int TYPE_EDIT = 1;
    private ProtArea area;
    private ProtArea.Extent extent;
    private String name;
    private final NewAreaCreation nac;
    private final int type;
    private boolean updated;
    private GuiTextField heightTopText;
    private GuiTextField heightBotText;
    private final GuiTextField nameText;
    private final GuiAreaPerms permissGroup;
    private final GuiLabel doButton;

    public GuiAreaEdit(NewAreaCreation nac, ProtArea area, Player player, int type) {
        super(AreaProtection.plugin, Msgs.msg[18], 0, 0, null);
        GuiLabel button;
        long permMask;
        this.setCallback(new DlgHandler());
        this.area = area;
        this.nac = nac;
        this.type = type;
        this.updated = false;
        int width = this.getTitleBarMinWidth();
        if (472 > width) {
            width = 472;
        }
        this.setSize(width + 2 * (int)this.getBorderThickness(), 500 + 2 * (int)this.getBorderThickness(), false);
        this.setPanelSize(width, 470);
        GuiLabel label = this.addTextItem(Msgs.msg[19], null, null);
        label.setPivot(PivotPosition.TopRight);
        label.setPosition(150.0f, 464.0f, false);
        this.nameText = new GuiTextField(156.0f, 468.0f, false, 300.0f, 23.0f, false);
        this.name = area.name != null ? area.name : "";
        this.nameText.setText(this.name);
        this.addChild((GuiElement)this.nameText, 32, null);
        boolean isAdmin = (Boolean)player.getAttribute("com.mwr.apIsAdmin");
        long l = permMask = isAdmin ? -1L : Db.getPlayerPermissionsForArea(player, area.id);
        if (type == 1 && !isAdmin && (permMask & Long.MIN_VALUE) == 0L) {
            permMask &= 0x4000000000000000L;
        }
        this.permissGroup = new GuiAreaPerms(area.permissions, permMask, true);
        this.addChild((GuiElement)this.permissGroup, null, null);
        this.permissGroup.setPosition(6.0f, 439.0f, false);
        this.extent = area.getExtent();
        if (type != 0) {
            boolean addPlayers = (permMask & 0x4000000000000000L) != 0L;
            button = this.addTextItem(Msgs.msg[54], addPlayers ? Integer.valueOf(33) : null, null);
            button.setPosition(6.0f, 76.0f, false);
            button.setColor(addPlayers ? 6344959 : 0x404040FF);
            button = this.addTextItem(Msgs.msg[55], addPlayers ? Integer.valueOf(34) : null, null);
            button.setColor(addPlayers ? 6344959 : 0x404040FF);
            button.setPosition(106.0f, 76.0f, false);
        }
        button = this.addTextItem(Msgs.msg[56], 35, null);
        button.setColor(6344959);
        button.setPosition(206.0f, 76.0f, false);
        button.setVisible(isAdmin);
        this.doButton = this.addTextItem(type == 0 ? Msgs.msg[63] : Msgs.msg[64], 39, null);
        this.doButton.setPivot(PivotPosition.Center);
        this.doButton.setPosition((float)(width / 2), 33.0f, false);
        this.updateDoButton();
    }

    private void updateDoButton() {
        boolean complete = this.updated && this.name.length() > 0;
        this.doButton.setColor(complete ? 6344959 : 0x404040FF);
        this.doButton.setClickable(complete);
    }

    private void checkAreaExtent(ProtArea.Extent extent) {
        Vector3f areaFrom = Utils.ChunkUtils.getGlobalPosition((Vector3i)this.area.getStartChunkPosition(), (Vector3i)this.area.getStartBlockPosition());
        Vector3f areaTo = Utils.ChunkUtils.getGlobalPosition((Vector3i)this.area.getEndChunkPosition(), (Vector3i)this.area.getEndBlockPosition());
        Vector3f extentFrom = extent.getFrom();
        Vector3f extentTo = extent.getTo();
        if (areaFrom.x != extentFrom.x || areaFrom.y != extentFrom.y || areaFrom.z != extentFrom.z || areaTo.x != extentTo.x || areaTo.y != extentTo.y || areaTo.z != extentTo.z) {
            ProtArea newArea = new ProtArea(extentFrom, extentTo, this.area.name, this.area.permissions);
            newArea.id = this.area.id;
            newArea.players = this.area.players;
            newArea.groups = this.area.groups;
            this.area = newArea;
        }
    }

    private class ExtentHandler
    implements GuiDefs.GuiCallback {
        private ExtentHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            if (id == 0) {
                GuiAreaEdit.this.extent = (ProtArea.Extent)data;
                GuiAreaEdit.this.updated = true;
                GuiAreaEdit.this.updateDoButton();
            }
        }
    }

    private class DlgHandler
    implements GuiDefs.GuiCallback {
        private DlgHandler() {
        }

        @Override
        public void onCall(Player player, int id, Object data) {
            if (id >= 1 && id <= 30) {
                GuiAreaEdit.this.permissGroup.togglePermission(id - 1);
                GuiAreaEdit.this.updated = true;
                GuiAreaEdit.this.updateDoButton();
                return;
            }
            switch (id) {
                case 32: {
                    if (data == null) break;
                    if (((String)data).equals(GuiAreaEdit.this.name)) {
                        return;
                    }
                    GuiAreaEdit.this.name = (String)data;
                    GuiAreaEdit.this.updated = true;
                    GuiAreaEdit.this.updateDoButton();
                    break;
                }
                case 36: {
                    int value;
                    if (data == null) {
                        return;
                    }
                    try {
                        value = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        value = GuiAreaEdit.this.extent.getMaxY();
                    }
                    GuiAreaEdit.this.extent.setMaxY(value);
                    break;
                }
                case 37: {
                    int value;
                    if (data == null) {
                        return;
                    }
                    try {
                        value = Integer.valueOf((String)data);
                    }
                    catch (NumberFormatException e) {
                        value = GuiAreaEdit.this.extent.getMinY();
                    }
                    GuiAreaEdit.this.extent.setMinY(value);
                    break;
                }
                case 38: {
                    GuiAreaEdit.this.extent.setMaxY(AreaProtection.heightTop);
                    GuiAreaEdit.this.extent.setMinY(AreaProtection.heightBottom);
                    GuiAreaEdit.this.heightTopText.setText(Integer.toString(AreaProtection.heightTop));
                    GuiAreaEdit.this.heightBotText.setText(Integer.toString(AreaProtection.heightBottom));
                    break;
                }
                case 33: {
                    GuiAreaEdit.this.push(player, new GuiPlayersEdit(GuiAreaEdit.this.area, 1));
                    GuiAreaEdit.this.updated = true;
                    GuiAreaEdit.this.updateDoButton();
                    break;
                }
                case 34: {
                    GuiAreaEdit.this.push(player, new GuiPlayersEdit(GuiAreaEdit.this.area, 2));
                    GuiAreaEdit.this.updated = true;
                    GuiAreaEdit.this.updateDoButton();
                    break;
                }
                case 35: {
                    GuiAreaEdit.this.push(player, new GuiAreaExtentEdit(GuiAreaEdit.this.area.getExtent(), GuiAreaEdit.this.area.getName(), player, new ExtentHandler()));
                    break;
                }
                case 39: {
                    ((GuiAreaEdit)GuiAreaEdit.this).area.name = GuiAreaEdit.this.name;
                    ((GuiAreaEdit)GuiAreaEdit.this).area.permissions = GuiAreaEdit.this.permissGroup.getPermissions();
                    GuiAreaEdit.this.checkAreaExtent(GuiAreaEdit.this.extent);
                    if (GuiAreaEdit.this.type == 0 && GuiAreaEdit.this.nac != null) {
                        GuiAreaEdit.this.nac.stopRun();
                        Db.addArea(GuiAreaEdit.this.area);
                    } else if (GuiAreaEdit.this.type == 1) {
                        Db.updateArea(GuiAreaEdit.this.area);
                    }
                    GuiAreaEdit.this.pop(player);
                }
            }
        }
    }
}

