/*
 * Decompiled with CFR 0.152.
 */
package org.miwarre.ap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import org.miwarre.ap.Db;
import org.miwarre.ap.GuiMainMenu;
import org.miwarre.ap.ListenerPlayer;
import org.miwarre.ap.Msgs;

public class AreaProtection
extends Plugin {
    static final String version = "1.0.7";
    static final int VERSION_INT = 4103;
    static final String publicName = "Area Protection";
    static final int AREAMANAGER_AREAID = -1;
    static final int AREACREAT_PRIORITY = 3;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_ARG = -1;
    public static final int ERR_DB = -2;
    public static final int ERR_CANNOT_ENTER = -3;
    public static final int ERR_CANNOT_LEAVE = -4;
    public static final int ERR_NOTFOUND = -5;
    public static final long PERM_ENTER = 1L;
    public static final long PERM_LEAVE = 2L;
    public static final long PERM_PLACEBLOCKS = 4L;
    public static final long PERM_DESTROYBLOCKS = 8L;
    public static final long PERM_PLACECONSTR = 16L;
    public static final long PERM_REMOVECONSTR = 32L;
    public static final long PERM_DESTROYCONSTR = 64L;
    public static final long PERM_PLACEOBJECTS = 128L;
    public static final long PERM_REMOVEOBJECTS = 256L;
    public static final long PERM_DESTROYOBJECTS = 512L;
    public static final long PERM_PLACETERRAIN = 1024L;
    public static final long PERM_DESTROYTERRAIN = 2048L;
    public static final long PERM_PLACEVEGET = 4096L;
    public static final long PERM_REMOVEVEGET = 8192L;
    public static final long PERM_DESTROYVEGET = 16384L;
    public static final long PERM_PLACEGRASS = 32768L;
    public static final long PERM_REMOVEGRASS = 65536L;
    public static final long PERM_PLACEWATER = 131072L;
    public static final long PERM_REMOVEWATER = 262144L;
    public static final long PERM_CREATEBLUEPR = 524288L;
    public static final long PERM_PLACEBLUEPRINT = 0x100000L;
    public static final long PERM_CREAT_PLACEBLOCKS = 0x200000L;
    public static final long PERM_CREAT_PLACEVEGET = 0x400000L;
    public static final long PERM_CREAT_TERRAINEDIT = 0x800000L;
    public static final long PERM_PUT2CHEST = 0x1000000L;
    public static final long PERM_GETFROMCHEST = 0x2000000L;
    public static final long PERM_DOORINTERACT = 0x4000000L;
    public static final long PERM_FURNACEINTERACT = 0x8000000L;
    public static final long PERM_OTHERINTERACT = 0x10000000L;
    public static final long PERM_EXPLOSION = 0x20000000L;
    public static final long PERM_BIT30 = 0x20000000L;
    public static final long PERM_ADDPLAYER = 0x4000000000000000L;
    public static final long PERM_OWNER = Long.MIN_VALUE;
    public static final long PERM_ALL = -1L;
    public static final long PERM_DEFAULT = 3L;
    static final long[] permIdx2bit = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x4000000000000000L, Long.MIN_VALUE};
    static final String key_areas = "com.mwr.apAreas";
    static final String key_areaPerms = "com.mwr.apPerms";
    static final String key_areasShown = "com.mwr.apShown";
    static final String key_areasText = "com.mwr.apText";
    static final String key_inAreas = "com.mwr.apInAreas";
    static final String key_isAdmin = "com.mwr.apIsAdmin";
    static final boolean adminNoPrivDef = false;
    static final boolean adminOnlyDef = true;
    static final boolean eventPosDef = true;
    static final int heightTopDef = 400;
    static final int heightBottomDef = -600;
    static final int infoBkgColourDef = -522149664;
    static final int infoFontColourDef = 255;
    static final int infoXPosDef = 20;
    static final int infoYPosDef = 70;
    static final String localeLanguageDef = "en";
    static boolean adminNoPriv = false;
    static boolean adminOnly = true;
    static String commandPrefix = "/ap";
    static boolean eventPos = true;
    static int heightTop = 400;
    static int heightBottom = -600;
    static int infoBkgColour = -522149664;
    static int infoFontColour = 255;
    static int infoXPos = 20;
    static int infoYPos = 70;
    static Locale locale;
    static AreaProtection plugin;
    static Map<String, Long> presets;
    private static final String[] permNames;
    private static final long[] permValues;

    public void onEnable() {
        plugin = this;
        this.initSettings();
        presets = AreaProtection.initPresets(this.getPath() + "/presets");
        Msgs.init(this.getPath(), locale);
        Db.init();
        this.registerEventListener(ListenerPlayer.getInstance());
        System.out.println("AREA PROTECTION 1.0.7 enabled successfully!");
    }

    public void onDisable() {
        this.unregisterEventListener(ListenerPlayer.getInstance());
        Db.deinit();
        System.out.println("AREA PROTECTION 1.0.7 disabled successfully!");
    }

    public String getPublicName() {
        return publicName;
    }

    public void mainGui(Player player) {
        GuiMainMenu mainMenu = new GuiMainMenu(player);
        mainMenu.show(player);
    }

    public int version() {
        return 4103;
    }

    public static String getPluginPath() {
        return plugin.getPath();
    }

    public static boolean togglePlayerAreas(Player player) {
        return Db.togglePlayerAreas(player);
    }

    public static long getPlayerPermissions(Player player) {
        Long perm = (Long)player.getAttribute(key_areaPerms);
        return perm != null ? perm : -1L;
    }

    public static long getPresetPermissionsFromName(String name) {
        Long perms = presets.get(name);
        if (perms == null) {
            return 0L;
        }
        return perms;
    }

    public static String getPresetNameFromPermissions(long perms) {
        for (Map.Entry<String, Long> entry : presets.entrySet()) {
            if (entry.getValue() != perms) continue;
            return entry.getKey();
        }
        return Msgs.msg[71];
    }

    public static boolean areaIntersects(Area areaA, Area areaB) {
        Vector3f startA = Utils.ChunkUtils.getGlobalPosition((Vector3i)areaA.getStartChunkPosition(), (Vector3i)areaA.getStartBlockPosition());
        Vector3f endA = Utils.ChunkUtils.getGlobalPosition((Vector3i)areaA.getEndChunkPosition(), (Vector3i)areaA.getEndBlockPosition());
        Vector3f startB = Utils.ChunkUtils.getGlobalPosition((Vector3i)areaB.getStartChunkPosition(), (Vector3i)areaB.getStartBlockPosition());
        Vector3f endB = Utils.ChunkUtils.getGlobalPosition((Vector3i)areaB.getEndChunkPosition(), (Vector3i)areaB.getEndBlockPosition());
        return (startA.x >= startB.x && startA.x <= endB.x || endA.x >= startB.x && endA.x <= endB.x || startB.x >= startA.x && startB.x <= endA.x || endB.x >= startA.x && endB.x <= endA.x) && (startA.y >= startB.y && startA.y <= endB.y || endA.y >= startB.y && endA.y <= endB.y || startB.y >= startA.y && startB.y <= endA.y || endB.y >= startA.y && endB.y <= endA.y) && (startA.z >= startB.z && startA.z <= endB.z || endA.z >= startB.z && endA.z <= endB.z || startB.z >= startA.z && startB.z <= endA.z || endB.z >= startA.z && endB.z <= endA.z);
    }

    public static String getAreaCentre(Area rwArea) {
        Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getStartChunkPosition(), (Vector3i)rwArea.getStartBlockPosition());
        Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getEndChunkPosition(), (Vector3i)rwArea.getEndBlockPosition());
        float centreN = (from.z + to.z + 1.0f) / 2.0f;
        float centreE = (from.x + to.x + 1.0f) / 2.0f;
        float centreH = (from.y + to.y + 1.0f) / 2.0f;
        String nSign = Msgs.msg[11];
        String eSign = Msgs.msg[14];
        if (centreN < 0.0f) {
            nSign = Msgs.msg[13];
        }
        if (centreE < 0.0f) {
            eSign = Msgs.msg[12];
        }
        return String.format(Msgs.msg[16], Float.valueOf(centreE), eSign, Float.valueOf(centreH), Float.valueOf(centreN), nSign);
    }

    public static String getAreaSpans(Area rwArea) {
        Vector3f from = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getStartChunkPosition(), (Vector3i)rwArea.getStartBlockPosition());
        Vector3f to = Utils.ChunkUtils.getGlobalPosition((Vector3i)rwArea.getEndChunkPosition(), (Vector3i)rwArea.getEndBlockPosition());
        return String.format(Msgs.msg[17], (int)(to.x - from.x) + 1, (int)(to.y - from.y) + 1, (int)(to.z - from.z) + 1);
    }

    private void initSettings() {
        String strLocale;
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.getPath() + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            adminNoPriv = AreaProtection.propertyToInt(settings, "adminNoPriv", 0) != 0;
            adminOnly = AreaProtection.propertyToInt(settings, "adminOnly", 1) != 0;
            eventPos = AreaProtection.propertyToInt(settings, "evenPosition", 1) != 0;
            heightTop = AreaProtection.propertyToInt(settings, "heightTop", 400);
            heightBottom = AreaProtection.propertyToInt(settings, "heightBottom", -600);
            infoBkgColour = AreaProtection.propertyToInt(settings, "infoBkgColour", -522149664);
            infoFontColour = AreaProtection.propertyToInt(settings, "infoFontColour", 255);
            infoXPos = AreaProtection.propertyToInt(settings, "infoXPos", 20);
            infoYPos = AreaProtection.propertyToInt(settings, "infoYPos", 70);
            strLocale = settings.getProperty("locale", localeLanguageDef);
        }
        catch (IOException e) {
            strLocale = localeLanguageDef;
        }
        String[] localeParams = strLocale.split("-");
        locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
    }

    static Map<String, Long> initPresets(String path) {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        File dir = new File(path);
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            for (File child : directoryListing) {
                try {
                    FileInputStream in = new FileInputStream(child.getPath());
                    Properties settings = new Properties();
                    settings.load(in);
                    in.close();
                    long perms = 0L;
                    String name = settings.getProperty("GroupName");
                    for (int i = 0; i < permNames.length; ++i) {
                        String val = settings.getProperty(permNames[i], "0");
                        perms |= val.equals("true") || val.equals("1") ? permValues[i] : 0L;
                    }
                    if (name == null) continue;
                    map.put(name, perms);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    static int propertyToInt(Properties settings, String txt, int defaultVal) {
        long val;
        String txtVal = settings.getProperty(txt);
        if (txtVal == null) {
            return defaultVal;
        }
        try {
            val = Long.decode(txtVal);
        }
        catch (NumberFormatException e) {
            return defaultVal;
        }
        return (int)(val & 0xFFFFFFFFFFFFFFFFL);
    }

    static {
        permNames = new String[]{"CanEnter", "CanLeave", "PlaceBlock", "DestroyBlock", "PlaceConstructions", "RemoveConstructions", "DestroyConstructions", "PlaceObjects", "RemoveObjects", "PickupObject", "DestroyObjects", "FillWorld", "DestroyWorld", "PlaceVegetation", "RemoveVegetation", "PickupVegetation", "DestroyVegetation", "PlaceGrass", "CutGrass", "PlaceWater", "RemoveWater", "CreateBlueprint", "PlaceBlueprint", "CreativePlaceBlock", "CreativePlaceVegetation", "CreativeTerrainEdit", "InventoryToChest", "PutToChest", "ChestToInventory", "ChestDrop", "GetFromChest", "DoorInteraction", "FurnaceInteraction", "OtherInteraction", "ChangeObjectStatus", "Explosion", "CanAddPlayer", "Owner"};
        permValues = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x1000000L, 0x2000000L, 0x2000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x10000000L, 0x20000000L, 0x4000000000000000L, Long.MIN_VALUE};
    }
}

