/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.gps;

import com.vistamaresoft.gps.Gps;
import net.risingworld.api.utils.Vector3f;

public class Waypoint {
    protected int id;
    protected String name;
    protected Vector3f pos;

    public Waypoint(int id, String name, float x, float y, float z) {
        this.id = id;
        this.name = name;
        this.pos = new Vector3f(x, y, z);
    }

    public String toString() {
        if (this.name == null || this.name.length() < 1) {
            return null;
        }
        float n = this.pos.z;
        String latDir = "N";
        float e = this.pos.x;
        String longDir = "W";
        if (n < 0.0f) {
            n = -n;
            latDir = "S";
        }
        if (e < 0.0f) {
            e = -e;
            longDir = "E";
        }
        return String.format("%d: %s (%.1f%s,%.1f%s) h%.1f", this.id, this.name, Float.valueOf(n), latDir, Float.valueOf(e), longDir, Float.valueOf(this.pos.y));
    }

    public String toString(double playerHdg, Vector3f playerPos) {
        int rdl;
        String shortName;
        double deltaN = this.pos.z - playerPos.z;
        double deltaW = this.pos.x - playerPos.x;
        double dist = Math.sqrt(deltaN * deltaN + deltaW * deltaW);
        String string = shortName = this.name.length() > Gps.wpDispLen ? this.name.substring(0, Gps.wpDispLen) : this.name;
        if (dist < 4.0) {
            return " | ---\u00b0  " + shortName + "   <2m";
        }
        double radial = Math.acos(deltaN / dist) * 57.29577951308232;
        if (deltaW > 0.0) {
            radial = 360.0 - radial;
        }
        if ((rdl = (int)(radial + 0.5)) == 0) {
            rdl = 360;
        }
        double wpHdgDelta = playerHdg - (double)rdl;
        String text = String.format("%03d\u00b0", rdl);
        text = wpHdgDelta > (double)Gps.wpHdgPrecis && wpHdgDelta < (double)(180 - Gps.wpHdgPrecis) || wpHdgDelta > (double)(Gps.wpHdgPrecis - 360) && wpHdgDelta < (double)(-Gps.wpHdgPrecis - 180) ? text + " <" : text + "  ";
        text = text + shortName;
        text = wpHdgDelta < (double)(-Gps.wpHdgPrecis) && wpHdgDelta > (double)(Gps.wpHdgPrecis - 180) || wpHdgDelta < (double)(360 - Gps.wpHdgPrecis) && wpHdgDelta > (double)(Gps.wpHdgPrecis + 180) ? text + "> " : text + "  ";
        text = text + Math.floor(dist / 2.0 + 0.5) + "m";
        return text;
    }
}

