/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.gps;

import com.vistamaresoft.gps.Gps;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

class Msgs {
    static final int err_noTpToWp = 0;
    static final int err_showWpInvalidIndex = 1;
    static final int err_showWpUndefinedWp = 2;
    static final int msg_homeSet = 3;
    static final int msg_wpSet = 4;
    static final int msg_homeDel = 5;
    static final int msg_wpDel = 6;
    static final int txt_homeName = 7;
    static final int txt_undefined = 8;
    static final int txt_gpsHelpHint = 9;
    static final int txt_wpNameTitle = 10;
    static final int txt_wpNameCapt = 11;
    static final int txt_north = 12;
    static final int txt_east = 13;
    static final int txt_south = 14;
    static final int txt_west = 15;
    private static final int LAST_TEXT = 15;
    static String[] msg = new String[]{"GPS goto: teleport to waypoints is disabled.", "GPS goto/wp: waypoint index must be an integer between 0 and 15", "GPS goto/wp: waypoint %d is undefined", "GPS: Home point set.", "GPS: Waypoint %1$d '%2$s' set.", "GPS: Home point deleted.", "GPS: Waypoint %d deleted.", "Home", "--[Undefined]--", "Chat '/$s' for control panel", "Waypoint name", "Enter the name for the new waypoint and press ENTER", "N", "E", "S", "W"};
    private static final String BUNDLE_NAME = "/locale/messages";

    Msgs() {
    }

    static boolean init(String path, Locale locale) {
        if (locale == null) {
            return false;
        }
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String fname = "/locale/messages_" + locale.getLanguage();
        if (country.length() > 0) {
            fname = fname + "_" + country;
        }
        if (variant.length() > 0) {
            fname = fname + "_" + variant;
        }
        fname = fname + ".properties";
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(path + fname);
            settings.load(in);
            in.close();
        }
        catch (IOException e) {
            System.out.println("** GPS plug-in ERROR: Property file '" + fname + "' for requested locale '" + locale.toString() + "' not found. Defaulting to 'en'");
            return false;
        }
        for (int i = 0; i <= 15; ++i) {
            Msgs.msg[i] = settings.getProperty(String.format("%03d", i));
        }
        Msgs.msg[1] = String.format(msg[1], 0, 15);
        Msgs.msg[9] = String.format(msg[9], Gps.commandPrefix);
        return true;
    }
}

