/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.gps;

import com.vistamaresoft.gps.Db;
import com.vistamaresoft.gps.Gps;
import com.vistamaresoft.gps.Msgs;
import com.vistamaresoft.gps.Waypoint;
import com.vistamaresoft.rwgui.GuiDialogueBox;
import com.vistamaresoft.rwgui.GuiInputDlgBox;
import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.GuiModalWindow;
import com.vistamaresoft.rwgui.RWGui;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.ImageInformation;

class GpsGUI
extends GuiDialogueBox {
    private static final int BUTTONOFF_ID = 1;
    private static final int BUTTGOTO_ID = 2;
    private static final int BUTTHOMESET_ID = 3;
    private static final int BUTTHOMESHOW_ID = 4;
    private static final int BUTTWPDEL_ID = 5;
    private static final int BUTTWPSET_ID = 6;
    private static final int BUTTWPSHOW_ID = 7;
    private static final int BUTTWPHIDE_ID = 8;
    private static final int BUTTTARGETSHOW_ID = 9;
    private static final int BUTTPREV_ID = 11;
    private static final int BUTTNEXT_ID = 12;
    private static final int NEWWPNAME_ID = 13;
    private static final int IMPORTWPNAME_ID = 14;
    private static final int BUTTONOFF_ICN = 0;
    private static final int BUTTGOTO_ICN = 1;
    private static final int BUTTHOMESET_ICN = 2;
    private static final int BUTTHOMESHOW_ICN = 3;
    private static final int BUTTHOMEHIDE_ICN = 4;
    private static final int BUTTWPDEL_ICN = 5;
    private static final int BUTTWPSET_ICN = 6;
    private static final int BUTTWPSHOW_ICN = 7;
    private static final int BUTTWPHIDE_ICN = 8;
    private static final int BUTTTARGETSHOW_ICN = 9;
    private static final int NUM_OF_IMGINFO = 10;
    private static final float PANEL_XPOS = 0.5f;
    private static final int BUTTON_SIZE = 32;
    private static final int STATE_NONE = 0;
    private static final int STATE_WPLIST = 1;
    private final GuiImage buttGoto;
    private final GuiImage buttHomeShow;
    private final GuiImage buttWpDel;
    private final GuiImage buttWpSet;
    private final GuiImage buttWpShow;
    private final GuiImage buttWpHide;
    private final GuiImage buttTargetShow;
    private final GuiImage buttonNext;
    private final GuiImage buttonPrev;
    private int currWp;
    private final GuiLabel labelWp;
    RWGui.RWGuiCallback dlgHandler = new DlgHandler();
    Waypoint[] globalWps;
    int globalWpIdx;
    int state;
    private static final ImageInformation[] icons = new ImageInformation[10];
    private static final String[] iconPaths = new String[]{"/assets/onoff.png", "/assets/goto.png", "/assets/homeset.png", "/assets/homeshow.png", "/assets/homehide.png", "/assets/del.png", "/assets/wpset.png", "/assets/wpshow.png", "/assets/wphide.png", "/assets/targetshow.png"};

    public GpsGUI(Gps plugin, Player player, float infoYPos, int currWp) {
        super((Plugin)plugin, "G P S", 2, null);
        this.setCallback(this.dlgHandler);
        this.state = 0;
        this.setPosition(0.5f, infoYPos + (infoYPos < 0.5f ? 0.1f : -0.25f), true);
        this.currWp = currWp;
        this.labelWp = new GuiLabel(0.0f, 0.0f, false);
        this.addChild((GuiElement)this.labelWp);
        GuiLayout locLayout = this.addNewLayoutChild(1, 4);
        this.buttonPrev = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        locLayout.addChild((GuiElement)this.buttonPrev, Integer.valueOf(11));
        RWGui.setImage((GuiImage)this.buttonPrev, (int)1);
        this.buttonNext = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage((GuiImage)this.buttonNext, (int)2);
        locLayout.addChild((GuiElement)this.buttonNext, Integer.valueOf(12));
        locLayout = this.addNewLayoutChild(1, 0);
        locLayout.setPadding(12);
        String pluginPath = plugin.getPath();
        if (icons[0] == null) {
            for (int i = 0; i < 10; ++i) {
                GpsGUI.icons[i] = new ImageInformation(pluginPath + iconPaths[i]);
            }
        }
        GuiImage image = new GuiImage(icons[0], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)image, Integer.valueOf(1));
        this.buttGoto = new GuiImage(icons[1], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttGoto, Integer.valueOf(2));
        image = new GuiImage(icons[2], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)image, Integer.valueOf(3));
        this.buttHomeShow = new GuiImage(icons[3], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttHomeShow, Integer.valueOf(4));
        this.buttWpDel = new GuiImage(icons[5], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttWpDel, Integer.valueOf(5));
        this.buttWpSet = new GuiImage(icons[6], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttWpSet, Integer.valueOf(6));
        this.buttWpShow = new GuiImage(icons[7], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttWpShow, Integer.valueOf(7));
        this.buttWpHide = new GuiImage(icons[8], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttWpHide, Integer.valueOf(8));
        this.buttTargetShow = new GuiImage(icons[9], 0.0f, 0.0f, false, 32.0f, 32.0f, false);
        locLayout.addChild((GuiElement)this.buttTargetShow, Integer.valueOf(9));
        this.updateControls(player);
    }

    private void updateControls(Player player) {
        Waypoint[] waypoints = (Waypoint[])player.getAttribute("com.vms.gpsWpList");
        int wpShown = (Integer)player.getAttribute("com.vms.gpsWpShow");
        if (waypoints != null) {
            Waypoint wp = waypoints[this.currWp];
            if (wp != null) {
                String txt = wp.toString();
                if (txt != null) {
                    this.labelWp.setText(txt);
                    this.buttGoto.setVisible(true);
                }
            } else {
                this.labelWp.setText("" + this.currWp + Msgs.msg[8]);
                this.buttGoto.setVisible(false);
            }
            boolean isDef = waypoints[0] != null;
            boolean isShown = (Boolean)player.getAttribute("com.vms.gpsHomeShow");
            this.buttHomeShow.setImage(isShown ? icons[4] : icons[3]);
            this.buttHomeShow.setVisible(isDef);
            this.buttWpDel.setVisible(wp != null);
            isShown = wpShown != 0;
            this.buttWpSet.setVisible(this.currWp > 0);
            this.buttWpShow.setVisible(this.currWp > 0 && wp != null);
            this.buttTargetShow.setVisible(wp != null);
            this.buttWpHide.setVisible(isShown);
        }
        List targets = (List)player.getAttribute("com.vms.gpsTargetList");
        this.buttTargetShow.setVisible(wpShown != -1 && targets != null && !targets.isEmpty());
    }

    private class DlgHandler
    implements RWGui.RWGuiCallback {
        private DlgHandler() {
        }

        public void onCall(Player player, int id, Object data) {
            Waypoint[] waypoints = (Waypoint[])player.getAttribute("com.vms.gpsWpList");
            boolean isCurrWpDefined = false;
            if (waypoints != null) {
                isCurrWpDefined = waypoints[GpsGUI.this.currWp] != null;
            }
            switch (id) {
                case -1: {
                    switch (GpsGUI.this.state) {
                        case 0: {
                            player.setAttribute("com.vms.gpsGUIcurrWp", (Object)GpsGUI.this.currWp);
                            break;
                        }
                        case 1: {
                            GpsGUI.this.state = 0;
                        }
                    }
                    return;
                }
                case 1: {
                    Gps.plugin.setGPSShow(player, (Boolean)player.getAttribute("com.vms.gpsShow") == false);
                    return;
                }
                case 11: {
                    GpsGUI.this.currWp--;
                    if (GpsGUI.this.currWp >= 0) break;
                    GpsGUI.this.currWp = 15;
                    break;
                }
                case 12: {
                    GpsGUI.this.currWp++;
                    if (GpsGUI.this.currWp <= 15) break;
                    GpsGUI.this.currWp = 0;
                    break;
                }
                case 2: {
                    if (isCurrWpDefined) {
                        Gps.plugin.teleportToWp(player, GpsGUI.this.currWp);
                    }
                    return;
                }
                case 3: {
                    Db.setHome(player);
                    Gps.plugin.setGpsText(player);
                    break;
                }
                case 4: {
                    Gps.plugin.setShowHome(player);
                    break;
                }
                case 5: {
                    Db.deleteWp(player, GpsGUI.this.currWp);
                    Gps.plugin.setGpsText(player);
                    break;
                }
                case 6: {
                    String defaultText = waypoints[GpsGUI.this.currWp] != null ? waypoints[((GpsGUI)GpsGUI.this).currWp].name : null;
                    GpsGUI.this.push(player, (GuiModalWindow)new GuiInputDlgBox(GpsGUI.this.plugin, player, Msgs.msg[10], Msgs.msg[11], defaultText, 13, (RWGui.RWGuiCallback)this));
                    return;
                }
                case 7: {
                    if (GpsGUI.this.currWp == 0 || !isCurrWpDefined) break;
                    Gps.plugin.setShowWp(player, GpsGUI.this.currWp);
                    break;
                }
                case 8: {
                    Gps.plugin.setShowWp(player, 0);
                    break;
                }
                case 9: {
                    List targets = (List)player.getAttribute("com.vms.gpsTargetList");
                    if (targets == null || targets.isEmpty()) break;
                    Gps.plugin.setShowWp(player, -1);
                    break;
                }
                case 13: {
                    if (data == null || ((String)data).length() <= 0) break;
                    Db.setWp(player, GpsGUI.this.currWp, (String)data);
                    break;
                }
                default: {
                    return;
                }
            }
            GpsGUI.this.updateControls(player);
        }
    }
}

