/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.gps;

import com.vistamaresoft.gps.Db;
import com.vistamaresoft.gps.GpsGUI;
import com.vistamaresoft.gps.Msgs;
import com.vistamaresoft.gps.Waypoint;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class Gps
extends Plugin
implements Listener {
    static final float gpsXPosDef = 0.5f;
    static final float gpsHintYPos = -0.25f;
    static final String localeLanguageDef = "en";
    static final int wpNameDispLenDef = 8;
    static final int wpHdgPrecisDef = 5;
    static String commandPrefix = "/gps";
    static boolean allowTpToWp = false;
    static boolean coordNativeFormat = false;
    static float gpsYPos = 0.1f;
    static Locale locale;
    static int wpDispLen;
    static int wpHdgPrecis;
    static final String key_gpsShow = "com.vms.gpsShow";
    static final String key_gpsGUIcurrWp = "com.vms.gpsGUIcurrWp";
    static final String key_gpsHomeShow = "com.vms.gpsHomeShow";
    static final String key_gpsLabel = "com.vms.gpsLabel";
    static final String key_gpsHint = "com.vms.gpsHint";
    static final String key_gpsTargetList = "com.vms.gpsTargetList";
    static final String key_gpsWpList = "com.vms.gpsWpList";
    static final String key_gpsWpShow = "com.vms.gpsWpShow";
    static final double RAD2DEG = 57.29577951308232;
    static final String VERSION = "1.4.0";
    static final int VERSION_INT = 10400;
    static final String publicName = "GPS";
    public static final int HOME_WP = 0;
    public static final int MAX_WP = 15;
    public static final int MIN_WP = 0;
    public static final int MIN_WP_PROPER = 1;
    public static final int TARGET_ID = -1;
    static final float TARGET_MIN_DIST = 9.0f;
    static final int FONT_SIZE = 18;
    static final int HINT_SIZE = 13;
    static Gps plugin;

    public void onEnable() {
        plugin = this;
        this.initSettings();
        Msgs.init(this.getPath(), locale);
        Db.init(this);
        System.out.println("GPS 1.4.0 enabled successfully!");
        this.registerEventListener(this);
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        Db.deinit();
        System.out.println("GPS 1.4.0 disabled successfully!");
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        this.initPlayer(event.getPlayer());
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        this.setGpsText(event.getPlayer());
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equals(commandPrefix)) {
            this.mainGui(player);
            return;
        }
        if (cmd[0].equals("/sethome")) {
            Db.setHome(player);
        }
        if (cmd[0].equals("/home")) {
            this.teleportToWp(player, 0);
        }
    }

    @EventMethod
    public void onPlayerChangePosition(PlayerChangePositionEvent event) {
        this.setGpsText(event.getPlayer());
    }

    public String getPublicName() {
        return publicName;
    }

    public void mainGui(Player player) {
        int currWp = 0;
        if (player.hasAttribute(key_gpsGUIcurrWp)) {
            currWp = (Integer)player.getAttribute(key_gpsGUIcurrWp);
        }
        GpsGUI gui = new GpsGUI(this, player, gpsYPos, currWp);
        gui.show(player);
    }

    public int version() {
        return 10400;
    }

    public void setGPSShow(Player player, boolean show) {
        player.setAttribute(key_gpsShow, (Object)show);
        GuiLabel labelgpsInfo = (GuiLabel)player.getAttribute(key_gpsLabel);
        if (labelgpsInfo != null) {
            labelgpsInfo.setVisible(show);
        }
        this.setGpsText(player);
    }

    public void setShowHome(Player player) {
        player.setAttribute(key_gpsHomeShow, (Object)((Boolean)player.getAttribute(key_gpsHomeShow) == false ? 1 : 0));
        this.setGpsText(player);
    }

    public void setShowWp(Player player, Integer index) {
        if (index == null || index < -1 || index > 15) {
            player.sendTextMessage(Msgs.msg[1]);
            return;
        }
        if (index == -1 && player.getAttribute(key_gpsTargetList) == null || index > 0 && ((Waypoint[])player.getAttribute(key_gpsWpList))[index] == null) {
            player.sendTextMessage(String.format(Msgs.msg[2], index));
            return;
        }
        player.setAttribute(key_gpsWpShow, (Object)index);
        this.setGpsText(player);
    }

    public void addTarget(Player player, String name, float x, float y, float z) {
        ArrayList<Waypoint> targets = (ArrayList<Waypoint>)player.getAttribute(key_gpsTargetList);
        if (targets == null) {
            targets = new ArrayList<Waypoint>();
            player.setAttribute(key_gpsTargetList, targets);
        }
        Waypoint wp = new Waypoint(-1, name, x, y, z);
        targets.add(wp);
        this.setShowWp(player, -1);
    }

    public void teleportToWp(Player player, Integer index) {
        if (index == null || index < 0 || index > 15) {
            player.sendTextMessage(Msgs.msg[1]);
            return;
        }
        if (index > 0 && !allowTpToWp) {
            player.sendTextMessage(Msgs.msg[0]);
            return;
        }
        Waypoint wp = ((Waypoint[])player.getAttribute(key_gpsWpList))[index];
        if (wp == null) {
            player.sendTextMessage(String.format(Msgs.msg[2], index));
            return;
        }
        player.setPosition(wp.pos.x, wp.pos.y, wp.pos.z);
        this.setGpsText(player);
    }

    void setGpsText(Player player) {
        if (player == null) {
            return;
        }
        if (player.getAttribute(key_gpsLabel) == null) {
            return;
        }
        GuiLabel labelgpsInfo = (GuiLabel)player.getAttribute(key_gpsLabel);
        if (labelgpsInfo == null) {
            return;
        }
        Vector3f playerPos = player.getPosition();
        List targets = (List)player.getAttribute(key_gpsTargetList);
        if (targets != null && !targets.isEmpty()) {
            Waypoint wp = (Waypoint)targets.get(0);
            float dist = (playerPos.x - wp.pos.x) * (playerPos.x - wp.pos.x) + (playerPos.z - wp.pos.z) * (playerPos.z - wp.pos.z);
            if (dist < 9.0f) {
                targets.remove(0);
                if (targets.isEmpty()) {
                    player.setAttribute(key_gpsTargetList, null);
                    player.setAttribute(key_gpsWpShow, (Object)0);
                }
            }
        }
        if (((Boolean)player.getAttribute(key_gpsShow)).booleanValue()) {
            Waypoint home;
            int hdg;
            Vector3f playerRot = player.getViewDirection();
            double rotX = playerRot.x;
            double rotZ = playerRot.z;
            double scale = Math.sqrt(rotX * rotX + rotZ * rotZ);
            double heading = scale < 1.0E-5 ? 0.0 : Math.acos(rotZ / scale) * 57.29577951308232;
            if (rotX > 0.0) {
                heading = 360.0 - heading;
            }
            if ((hdg = (int)Math.floor(heading + 0.5)) == 0) {
                hdg = 360;
            }
            int posW = (int)playerPos.x;
            int posE = -posW;
            int posN = (int)playerPos.z;
            int posH = (int)playerPos.y;
            String latDir = "";
            String longDir = "";
            if (!coordNativeFormat) {
                latDir = Msgs.msg[12];
                if (posN < 0) {
                    posN = -posN;
                    latDir = Msgs.msg[14];
                }
                longDir = Msgs.msg[13];
                if (posE < 0) {
                    posE = -posE;
                    longDir = Msgs.msg[15];
                }
            }
            String text = "";
            Waypoint[] wps = (Waypoint[])player.getAttribute(key_gpsWpList);
            if (((Boolean)player.getAttribute(key_gpsHomeShow)).booleanValue() && wps != null && (home = wps[0]) != null) {
                text = home.toString(heading, playerPos) + " | ";
            }
            text = text + String.format("%03d\u00b0", hdg) + (!coordNativeFormat ? " (" + posN + latDir + "," + posE + longDir + ") h" + posH : " (" + posW + "," + posH + "," + posN + ")");
            int wpToShow = (Integer)player.getAttribute(key_gpsWpShow);
            Waypoint wp = null;
            if (wpToShow == -1) {
                if (targets != null && !targets.isEmpty()) {
                    wp = (Waypoint)targets.get(0);
                }
            } else if (wpToShow > 0) {
                wp = ((Waypoint[])player.getAttribute(key_gpsWpList))[wpToShow];
            }
            if (wp != null) {
                text = text + " | " + wp.toString(heading, playerPos);
            }
            labelgpsInfo.setText(text);
        } else {
            labelgpsInfo.setText("");
        }
    }

    private void initPlayer(Player player) {
        if (player.getAttribute(key_gpsLabel) == null) {
            GuiLabel info = new GuiLabel("", 0.5f, gpsYPos, true);
            info.setColor(127);
            info.setFont(Font.DefaultMono);
            info.setFontColor(-1);
            info.setFontSize(18);
            info.setPivot(PivotPosition.Center);
            GuiLabel hint = new GuiLabel(Msgs.msg[9], 0.5f, -0.25f, true);
            hint.setPivot(PivotPosition.Center);
            hint.setFontSize(13);
            info.addChild((GuiElement)hint);
            player.setAttribute(key_gpsShow, (Object)true);
            player.setAttribute(key_gpsHomeShow, (Object)false);
            player.setAttribute(key_gpsWpShow, (Object)0);
            Db.loadPlayer(player);
            player.addGuiElement((GuiElement)info);
            player.addGuiElement((GuiElement)hint);
            player.setAttribute(key_gpsLabel, (Object)info);
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.getPath() + "/settings.properties");
            settings.load(in);
            in.close();
            commandPrefix = "/" + settings.getProperty("command", commandPrefix);
            allowTpToWp = Gps.toInteger(settings.getProperty("allowTpToWp"), 0) != 0;
            coordNativeFormat = Gps.toInteger(settings.getProperty("coordNativeFormat"), 0) != 0;
            gpsYPos = Float.parseFloat(settings.getProperty("gpsYPos", Float.toString(gpsYPos)));
            wpDispLen = Gps.toInteger(settings.getProperty("wpDispLength"), 8);
            wpHdgPrecis = Gps.toInteger(settings.getProperty("wpHdgPrecis"), 5);
            String strLocale = settings.getProperty("locale", localeLanguageDef);
            String[] localeParams = strLocale.split("-");
            locale = localeParams.length > 0 ? (localeParams.length > 1 && localeParams[2].length() > 0 ? (localeParams.length > 2 && localeParams[2].length() > 0 ? new Locale(localeParams[0], localeParams[1], localeParams[2]) : new Locale(localeParams[0], localeParams[1])) : new Locale(localeParams[0])) : new Locale(localeLanguageDef);
        }
        catch (IOException e) {
            e.printStackTrace();
            locale = new Locale(localeLanguageDef);
        }
    }

    static int toInteger(String txt, int defValue) {
        int val;
        if (txt == null) {
            return defValue;
        }
        try {
            val = Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
        return val;
    }

    static {
        wpDispLen = 8;
        wpHdgPrecis = 5;
    }
}

