/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.gps;

import com.vistamaresoft.gps.Msgs;
import com.vistamaresoft.gps.Waypoint;
import com.vistamaresoft.rwgui.RWGui;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

class Db {
    private static Database db = null;
    public static final int ERROR_OK = 0;
    public static final int ERROR_DB = -1;
    public static final int ERROR_INVALIDARG = -2;
    public static final int ERROR_EXISTING = -3;

    Db() {
    }

    static void init(Plugin plugin) {
        if (db == null) {
            db = plugin.getSQLiteConnection(plugin.getPath() + "/gps2-" + plugin.getWorld().getName() + ".db");
        }
        db.execute("CREATE TABLE IF NOT EXISTS `waypoints` (`player_id`   INTEGER  NOT NULL DEFAULT ( 0 ),`wp_name`     CHAR(64) NOT NULL DEFAULT ('[NoName]'),`wp_id`       INTEGER  NOT NULL,`wp_x`        INTEGER  NOT NULL DEFAULT ( 0 ),`wp_y`        INTEGER  NOT NULL DEFAULT ( 0 ),`wp_z`        INTEGER  NOT NULL DEFAULT ( 0 ),UNIQUE (player_id, wp_id) ON CONFLICT REPLACE);");
        String oldDbFName = plugin.getPath() + "/gps-" + plugin.getWorld().getName() + ".db";
        File oldDbFile = new File(oldDbFName);
        if (oldDbFile.exists()) {
            try (Database oldDb = plugin.getSQLiteConnection(oldDbFName);){
                try (ResultSet result = oldDb.executeQuery("SELECT * FROM waypoints");){
                    while (result.next()) {
                        int playerId = RWGui.getPlayerDbIdFromName((Plugin)plugin, (String)result.getString(1));
                        if (playerId == 0) continue;
                        db.executeUpdate("INSERT OR REPLACE INTO waypoints (player_id,wp_name,wp_id,wp_x,wp_y,wp_z) VALUES ('" + playerId + "','" + result.getString(2) + "'," + result.getInt(3) + "," + result.getInt(4) + "," + result.getInt(5) + "," + result.getInt(6) + ");");
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(Db.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            oldDbFile.delete();
        }
    }

    static void deinit() {
        db.close();
        db = null;
    }

    static void loadPlayer(Player player) {
        Waypoint[] waypoints = new Waypoint[16];
        player.setAttribute("com.vms.gpsWpList", (Object)waypoints);
        try (ResultSet result = db.executeQuery("SELECT * FROM `waypoints` WHERE `player_id` = '" + player.getDbID() + "' ORDER BY `wp_id`;");){
            while (result.next()) {
                int wpIdx = result.getInt("wp_id");
                if (wpIdx < 0 || wpIdx >= 15) continue;
                waypoints[result.getInt((String)"wp_id")] = new Waypoint(result.getInt("wp_id"), result.getString("wp_name"), result.getFloat("wp_x"), result.getFloat("wp_y"), result.getFloat("wp_z"));
            }
        }
        catch (SQLException e) {
            Logger.getLogger(Db.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public static void setWp(Player player, int wpIndex, String wpName) {
        Db.setWp(player, wpIndex, player.getPosition(), wpName);
    }

    public static void setWp(Player player, int wpIdx, Vector3f pos, String wpName) {
        Waypoint wp;
        if (wpIdx < 0 || wpIdx > 15) {
            return;
        }
        int playerId = player.getDbID();
        db.executeUpdate("INSERT OR REPLACE INTO waypoints (player_id,wp_name,wp_id,wp_x,wp_y,wp_z) VALUES ('" + playerId + "','" + wpName + "'," + wpIdx + "," + pos.x + "," + pos.y + "," + pos.z + ");");
        ((Waypoint[])player.getAttribute((String)"com.vms.gpsWpList"))[wpIdx] = wp = new Waypoint(wpIdx, wpName, pos.x, pos.y, pos.z);
        if (wpIdx == 0) {
            player.sendTextMessage(Msgs.msg[3]);
        } else {
            player.sendTextMessage(String.format(Msgs.msg[4], wpIdx, wpName));
        }
    }

    public static int deleteWp(Player player, int wpIdx) {
        if (wpIdx < 0 || wpIdx >= 15) {
            return -2;
        }
        int playerId = player.getDbID();
        db.executeUpdate("DELETE FROM waypoints WHERE player_id = '" + playerId + "' AND wp_id=" + wpIdx + ";");
        ((Waypoint[])player.getAttribute((String)"com.vms.gpsWpList"))[wpIdx] = null;
        if (wpIdx == 0) {
            player.sendTextMessage(Msgs.msg[5]);
        } else {
            player.sendTextMessage(String.format(Msgs.msg[6], wpIdx));
        }
        return 0;
    }

    public static void setHome(Player player) {
        Db.setWp(player, 0, Msgs.msg[7]);
    }
}

