/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.GetConfigDaten;
import de.chaoswg.ShutdownInfoTimerClassText;
import de.chaoswg.ShutdownInfoTimerErrorSprachAPI;
import de.chaoswg.SprachAPI;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.ShutdownEvent;
import net.risingworld.api.events.general.UpdateEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;

public class ShutdownInfoTimer
extends Plugin
implements Listener {
    private ShutdownInfoTimer plugin;
    private Server server;
    private World world;
    private int debug;
    private CRT crt;
    private String conf;
    private SprachAPI sprachApiPlugin;
    String recSprachApiVersion;
    private int restartTime;
    private int[][] iShutdownTime;
    private float lastUpdate;
    private float stepp;
    private DateTimeFormatter dtf;
    private Duration elapsed;
    private LocalDateTime[] daylyShutdownDate;
    private String[] intList;
    private ArrayList<Integer> intValu;
    private DateTimeFormatter chatDTF;
    private boolean timeInChat;
    private ShutdownInfoTimerClassText sprachApiDaten;
    private GetConfigDaten sysConfig;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.crt = new CRT();
        this.conf = CRT.getSpec() + "config";
        this.debug = 1;
        this.recSprachApiVersion = "1.1.3";
        String pattern = "yyyy-MM-dd HH:mm:ss";
        this.dtf = DateTimeFormatter.ofPattern(pattern);
        this.stepp = 7.5f;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled ");
        }
        String[] aRecSprachApiVersion = this.recSprachApiVersion.split("\\.", 3);
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled reqVer[" + this.recSprachApiVersion + "]  verLeng[" + aRecSprachApiVersion.length + "] ");
        }
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.sprachApiPlugin = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            String[] spApiVer = this.sprachApiPlugin.getDescription("version").split("\\.", 3);
            if (this.crt.isSameVersion(this.recSprachApiVersion, this.sprachApiPlugin.getDescription("version"), new CRT.ClassDebug((Plugin)this.plugin, this.debug))) {
                this.sprachApiDaten = new ShutdownInfoTimerClassText();
                this.sprachApiDaten.setDebug(this.debug);
                this.sprachApiDaten.setDir(this.conf + this.sprachApiDaten.getDir());
                this.sprachApiDaten.INI(this.plugin);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ") OK");
                }
                String[][] sysConfigArray = new String[][]{{"restartTime", "3"}, {"intervall", "15 10 5 1"}, {"dayly", "1:30"}, {"timeInChat", "false"}, {"timekeeping", String.valueOf(this.stepp)}, {"command", "SIT"}, {"Debug", String.valueOf(this.debug)}};
                this.sysConfig = new GetConfigDaten("System", sysConfigArray, (Plugin)this, this.debug, this.conf);
                this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
                this.restartTime = Integer.parseInt(this.sysConfig.getValue("restartTime"));
                this.stepp = Float.parseFloat(this.sysConfig.getValue("timekeeping").replace(",", "."));
                this.timeInChat = this.sysConfig.getValue("timeInChat").toLowerCase().equals("true");
                this.chatDTF = DateTimeFormatter.ofPattern("HH:mm:ss");
                if (this.sysConfig.getValue("dayly") != null) {
                    String[] sShutdownTimeArray = this.sysConfig.getValue("dayly").split(" ");
                    int sShutdownTimePartMax = 0;
                    for (String sShutdownTimePart : sShutdownTimeArray) {
                        String[] sShutdownTime = sShutdownTimePart.split(":");
                        if (sShutdownTime.length > sShutdownTimePartMax) {
                            sShutdownTimePartMax = sShutdownTime.length;
                        }
                        if (this.debug <= 3) continue;
                        System.out.println("[" + this.plugin.getDescription("name") + "] Enabled dayly " + sShutdownTimePart + " ");
                    }
                    this.iShutdownTime = new int[sShutdownTimeArray.length][sShutdownTimePartMax];
                    this.daylyShutdownDate = new LocalDateTime[sShutdownTimeArray.length];
                    for (int n = 0; n < this.iShutdownTime.length; ++n) {
                        if (sShutdownTimeArray.length <= 0) continue;
                        String[] sShutdownTime = sShutdownTimeArray[n].split(":");
                        for (int nn = 0; nn < sShutdownTime.length; ++nn) {
                            this.iShutdownTime[n][nn] = !sShutdownTime[nn].equals("") ? Integer.parseInt(sShutdownTime[nn]) : -1;
                        }
                        if (this.iShutdownTime[n][0] < 0 || this.iShutdownTime[n][1] < 0) continue;
                        this.daylyShutdownDate[n] = LocalDateTime.of(LocalDate.now(), LocalTime.of(this.iShutdownTime[n][0], this.iShutdownTime[n][1]));
                        if (this.debug <= 3) continue;
                        System.out.println("[" + this.plugin.getDescription("name") + "] Enabled dayly " + sShutdownTimeArray[n] + "|" + this.iShutdownTime[n][0] + "|" + this.iShutdownTime[n][1]);
                    }
                } else {
                    this.daylyShutdownDate = null;
                }
                if (this.sysConfig.getValue("intervall") != null) {
                    this.intList = this.sysConfig.getValue("intervall").split(" ");
                    this.intValu = new ArrayList();
                    for (int n = 0; n < this.intList.length; ++n) {
                        this.intValu.add(Integer.parseInt(this.intList[n]) * 60);
                    }
                }
                if (this.debug > 4) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled currentTimeMillis " + System.currentTimeMillis() + " ");
                }
                this.registerEventListener(this);
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Die Version von Plugin 'SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ")' ist zu klein! Bitte Aktualisieren auf Version(" + this.recSprachApiVersion + ")!");
                this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
            }
        } else if (this.plugin.getPluginByName("SprachAPI") == null) {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
        }
    }

    public void onDisable() {
        System.out.println("[" + this.plugin.getDescription("name") + "] Disabled");
    }

    @EventMethod
    public void onShutdown(ShutdownEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Shutdown ausf\u00fchren nach " + this.server.getRunningTime() + " ");
        }
        this.server.getAllPlayers().forEach(player -> {
            if (player != null) {
                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownnow"), this.restartTime);
                player.sendYellMessage(str.replaceAll("\\[\\#[0-9a-fA-F]{6}\\]", ""));
                player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
            }
        });
    }

    @EventMethod
    public void onUpdate(UpdateEvent event) {
        if (this.lastUpdate + this.stepp <= this.server.getRunningTime()) {
            this.lastUpdate = this.server.getRunningTime();
            String output = this.dtf.format(LocalDateTime.now());
            for (int n = 0; n < this.daylyShutdownDate.length; ++n) {
                if (this.daylyShutdownDate != null && this.daylyShutdownDate[n] != null) {
                    this.elapsed = Duration.between(LocalDateTime.now(), this.daylyShutdownDate[n]);
                    if ((float)this.elapsed.getSeconds() < this.stepp && !this.elapsed.isNegative()) {
                        if (this.debug > 2 && this.debug != 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + n + "] " + this.chatDTF.format(LocalTime.now()));
                        }
                        if (this.debug == 1) {
                            System.out.println("Erwarteter Neustart[" + n + "] - [" + this.plugin.getDescription("name") + " | Zeitstempel  | " + output + "] ");
                        }
                        this.server.getAllPlayers().forEach(player -> {
                            if (player != null) {
                                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdown"), 0);
                                player.sendYellMessage(str.replaceAll("\\[\\#[0-9a-fA-F]{6}\\]", ""));
                                player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
                            }
                        });
                    }
                    CRT.ClassLambadHelper l = new CRT.ClassLambadHelper();
                    l.n = n;
                    this.intValu.forEach(counter -> {
                        if ((float)this.elapsed.getSeconds() < (float)counter.intValue() + this.stepp && this.elapsed.getSeconds() >= (long)counter.intValue()) {
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + l.n + "][" + counter + "] " + this.chatDTF.format(LocalTime.now()));
                            }
                            CRT.ClassLambadHelper ll = new CRT.ClassLambadHelper();
                            ll.n = counter / 60;
                            this.server.getAllPlayers().forEach(player -> {
                                if (player != null) {
                                    String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownin"), ll.n);
                                    player.sendYellMessage(str.replaceAll("\\[\\#[0-9a-fA-F]{6}\\]", ""));
                                    player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
                                }
                            });
                        }
                    });
                }
                if (this.debug <= 3) continue;
                System.out.println("[" + this.plugin.getDescription("name") + "] Update Time[" + n + "] " + this.server.getRunningTime() + " now[" + output + "]  in[" + (this.elapsed != null ? Long.valueOf(this.elapsed.getSeconds()) : "NULL") + "] ");
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) throws IOException {
        Player player = event.getPlayer();
        String command = event.getCommand();
        String[] cmd = command.split(" ");
        if (cmd[0].toLowerCase().equals("/" + this.sysConfig.getValue("command")) || cmd[0].toLowerCase().equals("/" + this.sysConfig.getValue("command").toLowerCase())) {
            if (cmd.length > 1) {
                player.sendTextMessage("");
                player.sendTextMessage("#> " + cmd[0].substring(1) + " [#00ff00]" + command.substring(1 + cmd[0].length()));
            }
            if (cmd.length == 1) {
                player.sendTextMessage(this.plugin.getDescription("name") + " " + this.plugin.getDescription("version"));
                player.sendTextMessage("" + this.sprachApiDaten.getText(player, "command_author") + ": " + this.plugin.getDescription("author"));
                player.sendTextMessage("" + this.sprachApiDaten.getText(player, "command_Description") + ": " + this.plugin.getDescription("description"));
            }
            if (cmd.length > 1 && cmd[1].toLowerCase().equals("debug")) {
                if (player.isAdmin()) {
                    if (cmd.length > 2) {
                        int deb = -1;
                        deb = Integer.parseInt(cmd[2]);
                        if (deb >= 0) {
                            this.setDebug(deb);
                            player.sendTextMessage("" + String.format(this.sprachApiDaten.getText(player, "set_Debug"), deb));
                        }
                    } else {
                        player.sendTextMessage("" + this.sprachApiDaten.getText(player, "less_comannd"));
                    }
                } else {
                    player.sendTextMessage("" + this.sprachApiDaten.getText(player, "no_admin"));
                }
            }
            if (cmd.length > 1 && cmd[1].toLowerCase().equals("status")) {
                if (player.isAdmin()) {
                    for (int n = 0; n < this.daylyShutdownDate.length; ++n) {
                        if (this.daylyShutdownDate == null || this.daylyShutdownDate[n] == null) continue;
                        this.elapsed = Duration.between(LocalDateTime.now(), this.daylyShutdownDate[n]);
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Status Timer[" + n + "] " + this.chatDTF.format(LocalTime.now()) + " Elapsed[" + this.elapsed + "] ");
                        }
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Status Timer[" + n + "] " + this.chatDTF.format(LocalTime.now().plus(this.elapsed)) + " ");
                        }
                        CRT.ClassLambadHelper l = new CRT.ClassLambadHelper();
                        l.n = n;
                        l.obj = -1;
                        l.f = 0.0f;
                        this.intValu.forEach(counter -> {
                            if (l.f < (float)counter.intValue()) {
                                l.f = counter.intValue();
                            }
                            if (this.elapsed.getSeconds() > (long)counter.intValue()) {
                                if (this.debug > 3) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] Status Timer[" + l.n + "][" + counter + "] " + this.elapsed.getSeconds());
                                }
                                if ((Integer)l.obj < counter) {
                                    l.obj = counter;
                                }
                            } else if (this.debug > 3) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] Status Timer[" + l.n + "]false[" + counter + "] " + this.elapsed.getSeconds());
                            }
                        });
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Status Timer[" + n + "] " + (this.elapsed.getSeconds() >= 0L ? ((Integer)l.obj >= 0 && this.elapsed.getSeconds() <= (long)((int)l.f) ? "Aktiv" : "Warten") : "Vorbei") + " ");
                        }
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Status ");
                        }
                        player.sendTextMessage(String.format(this.sprachApiDaten.getText(player, "status_Timer"), n) + " " + this.chatDTF.format(LocalTime.now().plus(this.elapsed)) + " " + (this.elapsed.getSeconds() >= 0L ? ((Integer)l.obj >= 0 && this.elapsed.getSeconds() <= (long)((int)l.f) ? "[#00c01c]" : "[#ffc840]") : "[#808080]") + (this.elapsed.getSeconds() >= 0L ? ((Integer)l.obj >= 0 && this.elapsed.getSeconds() <= (long)((int)l.f) ? this.sprachApiDaten.getText(player, "status_Active") : this.sprachApiDaten.getText(player, "status_Waiting")) : this.sprachApiDaten.getText(player, "status_Past")));
                    }
                } else {
                    player.sendTextMessage("" + this.sprachApiDaten.getText(player, "no_admin"));
                }
            }
        } else if (cmd[0].toLowerCase().equals("/")) {
            player.sendTextMessage("/" + this.sysConfig.getValue("command"));
        }
    }
}

