package net.risingworld.api.example.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.world.PlayerDestroyBlockEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.objects.Player;

/**
 * Plugin welches alle Zerstörungen (Blöcke zerstören, Objekte abbauen etc) durch
 * Spieler protokolliert (als Ausgabe in der Konsole).
 * 
 * @author red51
 */

public class Logging extends Plugin implements Listener{
    
    //Diese Objekte werden nur dafür benötigt, die Uhrzeit und das Datum auszugeben, 
    //sind also im Grunde nicht ganz so wichtig
    private Date date = new Date();
    private DateFormat dateFormat = new SimpleDateFormat();
    
    @Override
    public void onEnable(){
        //Unsere Pluginklasse als Eventlistener registrieren, damit die entsprechenden
        //Events getriggert werden
        registerEventListener(this);
    }

    @Override
    public void onDisable(){
        //Hier muss nichts stehen...
    }
    
    @EventMethod
    public void onTerrainDestroy(PlayerDestroyTerrainEvent event){
        //Wird aufgerufen, wenn ein Spieler Terrain zerstört (also bspw. Stein abbaut)
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    @EventMethod
    public void onBlockDestroy(PlayerDestroyBlockEvent event){
        //Wird aufgerufen, wenn ein Spieler einen Block zerstört
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    @EventMethod
    public void onObjectDestroy(PlayerDestroyObjectEvent event){
        //Wird aufgerufen, wenn ein Spieler ein Objekt (Möbel, Türen, Lampen etc) zerstört
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    @EventMethod
    public void onConstructionDestroy(PlayerDestroyConstructionEvent event){
        //Wird aufgerufen, wenn ein Spieler ein Bauelement (Planke, Balken, Fenster) zerstört
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    @EventMethod
    public void onObjectRemove(PlayerRemoveObjectEvent event){
        //Wird aufgerufen, wenn ein Spieler ein Objekt (Möbel, Türen, Lampen etc) abbaut
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    @EventMethod
    public void onConstructionRemove(PlayerRemoveConstructionEvent event){
        //Wird aufgerufen, wenn ein Spieler ein Bauelement (Planke, Balken, Fenster) abbaut (sowas ist im Spiel noch nicht möglich, 
        //aber wir packen das trotzdem mal hier rein, damit dieser Fall in Zukunft abgedeckt ist [wenn es irgendwann möglich sein wird, Bauteile
        //abzubauen])
        log(event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }
    
    //Eine eigene "log()" Methode damit alle Debugausgaben dieses Plugins zentral gesteuert werden können.
    //Hier kann jederzeit das Ausgabeformat angepasst werden. In unserem Fall ist es standardmäßig so (Beispiel): 
    //"2017.05.09 20:40 - PlayerDestroyTerrainEvent Spielername in chunk 42 1 -15
    private void log(Event event, Player player, int cx, int cy, int cz){
        date.setTime(System.currentTimeMillis());  // <- aktuelle Uhrzeit/Datum bestimmen
        System.err.println(dateFormat.format(date) + " - " + event.getClass().getSimpleName() + " " + player.getName() + " in chunk " + cx + " " + cy + " " + cz);
    }

}
