/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.world.PlayerDestroyBlockEvent;
import net.risingworld.api.events.player.world.PlayerDestroyConstructionEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerDestroyTerrainEvent;
import net.risingworld.api.events.player.world.PlayerRemoveConstructionEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.objects.Player;

public class Logging
extends Plugin
implements Listener {
    private Date date = new Date();
    private DateFormat dateFormat = new SimpleDateFormat();

    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onTerrainDestroy(PlayerDestroyTerrainEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    @EventMethod
    public void onBlockDestroy(PlayerDestroyBlockEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    @EventMethod
    public void onObjectDestroy(PlayerDestroyObjectEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    @EventMethod
    public void onConstructionDestroy(PlayerDestroyConstructionEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    @EventMethod
    public void onObjectRemove(PlayerRemoveObjectEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    @EventMethod
    public void onConstructionRemove(PlayerRemoveConstructionEvent event) {
        this.log((Event)event, event.getPlayer(), event.getChunkPositionX(), event.getChunkPositionY(), event.getChunkPositionZ());
    }

    private void log(Event event, Player player, int cx, int cy, int cz) {
        this.date.setTime(System.currentTimeMillis());
        System.err.println(this.dateFormat.format(this.date) + " - " + event.getClass().getSimpleName() + " " + player.getName() + " in chunk " + cx + " " + cy + " " + cz);
    }
}

