/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.Interaction;
import net.risingworld.api.worldelements.WorldElement;
import pluginapi.manager.PluginElementManager;

public class World3DModel
extends WorldElement {
    private ModelInformation model;
    private ImageInformation texture;
    private boolean lightingEnabled = true;
    private CollisionShape collisionShape;
    private Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector2f textureScale = new Vector2f(1.0f, 1.0f);
    private Vector2f textureOffset = new Vector2f(0.0f, 0.0f);
    private boolean interactable = false;
    private Crosshair crosshair = Crosshair.Default;
    private Interaction interactionPreset = null;
    private boolean hittable = false;
    private float alpha = 1.0f;
    private boolean transparency = false;

    public World3DModel(ModelInformation model, ImageInformation texture) {
        this.model = model;
        this.texture = texture;
    }

    public World3DModel(ModelInformation model, ImageInformation texture, Vector3f position, Quaternion rotation) {
        this.model = model;
        this.texture = texture;
        this.setPosition(position);
        this.setRotation(rotation);
    }

    public void setInteractable(boolean set) {
        if (this.interactable != set) {
            this.interactable = set;
            this.updateElement(false, true);
        }
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractionCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            crosshair = Crosshair.Default;
        }
        if (this.crosshair != crosshair) {
            this.crosshair = crosshair;
            this.updateElement(false, false);
        }
    }

    public Crosshair getInteractionCrosshair() {
        return this.crosshair;
    }

    public void setInteractionPreset(Interaction preset) {
        this.interactionPreset = preset;
    }

    public Interaction getInteractionPreset() {
        return this.interactionPreset;
    }

    public boolean hasInteractionPreset() {
        return this.interactionPreset != null;
    }

    public void setHittable(boolean set) {
        if (this.hittable != set) {
            this.hittable = set;
            this.updateElement(false, false);
        }
    }

    public boolean isHittable() {
        return this.hittable;
    }

    public void setModel(ModelInformation model) {
        if (this.model != model) {
            this.model = model;
            this.updateElement(false, false);
        }
    }

    public ModelInformation getModel() {
        return this.model;
    }

    public void setTexture(ImageInformation texture) {
        if (this.texture != texture) {
            this.texture = texture;
            this.updateElement(false, false);
        }
    }

    public ImageInformation getTexture() {
        return this.texture;
    }

    public void setLightingEnabled(boolean lighting) {
        if (this.lightingEnabled != lighting) {
            this.lightingEnabled = lighting;
            this.updateElement(false, false);
        }
    }

    public boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public void setScale(float sx, float sy, float sz) {
        if (!this.scale.equals(sx, sy, sz)) {
            this.scale.set(sx, sy, sz);
            this.updateElement(false, false);
        }
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setTextureScale(float scale) {
        this.setTextureScale(scale, scale);
    }

    public void setTextureScale(float sx, float sy) {
        if (!this.textureScale.equals(sx, sy)) {
            this.textureScale.set(sx, sy);
            this.updateElement(false, false);
        }
    }

    public Vector2f getTextureScale() {
        return this.textureScale;
    }

    public void setTextureOffset(float offsetx, float offsety) {
        if (!this.textureOffset.equals(offsetx, offsety)) {
            this.textureOffset.set(offsetx, offsety);
            this.updateElement(false, false);
        }
    }

    public Vector2f getTextureOffset() {
        return this.textureOffset;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setTransparencyEnabled(boolean set) {
        this.transparency = set;
    }

    public boolean isTransparencyEnabled() {
        return this.transparency;
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        if (this.collisionShape != collisionShape) {
            this.collisionShape = collisionShape;
            this.updateElement(true, false);
        }
    }

    public CollisionShape getCollisionShape() {
        return this.collisionShape;
    }

    public boolean hasCollisionShape() {
        return this.collisionShape != null;
    }

    private void updateElement(boolean updateCollision, boolean updateInteraction) {
        PluginElementManager.update3DModel((World3DModel)this, (boolean)updateCollision, (boolean)updateInteraction);
    }
}

