/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.gui;

import com.jme3.math.FastMath;
import java.util.Arrays;
import net.risingworld.api.gui.GuiElement;

public class GuiPaintable
extends GuiElement {
    private int paintableWidth;
    private int paintableHeight;
    private byte[] imageData;

    public GuiPaintable(float x, float y, boolean relativeposition, float width, float height, boolean relativesize, int paintablewidth, int paintableheight) {
        super(x, y, relativeposition, width, height, relativesize);
        this.paintableWidth = paintablewidth;
        this.paintableHeight = paintableheight;
        this.color = 255;
        this.imageData = new byte[paintablewidth * paintableheight * 4];
        Arrays.fill(this.imageData, (byte)-1);
    }

    @Override
    public void setClickable(boolean set) {
        super.setClickable(set);
    }

    @Override
    public boolean isClickable() {
        return super.isClickable();
    }

    public int getPaintableWidth() {
        return this.paintableWidth;
    }

    public int getPaintableHeight() {
        return this.paintableHeight;
    }

    public void setRGBA(int x, int y, float r, float g, float b, float a) {
        this.setRGBA(x, y, (byte)(r * 255.0f), (byte)(g * 255.0f), (byte)(b * 255.0f), (byte)(a * 255.0f));
        this.updateImage();
    }

    public void setRGBA(int x, int y, int rgba) {
        this.setRGBA(x, y, this.getR(rgba), this.getG(rgba), this.getB(rgba), this.getA(rgba));
        this.updateImage();
    }

    public void fill(float r, float g, float b, float a) {
        this.fill(this.getRGBA(r, g, b, a));
    }

    public void fill(int rgba) {
        for (int x = 0; x < this.paintableWidth; ++x) {
            for (int y = 0; y < this.paintableHeight; ++y) {
                this.setRGBA(x, y, rgba);
            }
        }
        this.updateImage();
    }

    public void drawLine(int x0, int y0, int x1, int y1, int thickness, float r, float g, float b, float a) {
        this.drawLine(x0, y0, x1, y1, thickness, this.getRGBA(r, g, b, a));
    }

    public void drawLine(int x0, int y0, int x1, int y1, int thickness, int rgba) {
        int dx = (int)FastMath.abs((float)(x1 - x0));
        int sx = x0 < x1 ? 1 : -1;
        int dy = -((int)FastMath.abs((float)(y1 - y0)));
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (x0 >= 0 && x0 < this.paintableWidth && y0 >= 0 && y0 < this.paintableHeight) {
            this.drawCircle(x0, y0, thickness, rgba);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
        this.updateImage();
    }

    public void drawRectangle(int x0, int y0, int x1, int y1, float r, float g, float b, float a) {
    }

    public void drawRectangle(int x0, int y0, int x1, int y1, int rgba) {
    }

    public void drawCircle(int x, int y, int radius, float r, float g, float b, float a) {
    }

    public void drawCircle(int x, int y, int radius, int rgba) {
        byte br = this.getR(rgba);
        byte bg = this.getG(rgba);
        byte bb = this.getB(rgba);
        byte ba = this.getA(rgba);
        int size = radius * 2;
        if (size <= 1) {
            this.setRGBA(x, y, br, bg, bb, ba);
        } else {
            int pointt = size / 2;
            for (int px = -pointt; px <= pointt; ++px) {
                for (int py = -pointt; py <= pointt; ++py) {
                    if (FastMath.sqr((float)x) + FastMath.sqr((float)y) > FastMath.sqr((float)pointt) + (float)pointt || px + x < 0 || px + x >= this.paintableWidth || py + y < 0 || py + y >= this.paintableHeight) continue;
                    this.setRGBA(px + x, py + y, br, bg, bb, ba);
                }
            }
        }
        this.updateImage();
    }

    private void setRGBA(int x, int y, byte r, byte g, byte b, byte a) {
        int i = (x + y * this.paintableWidth) * 4;
        this.imageData[i] = r;
        this.imageData[i + 1] = g;
        this.imageData[i + 2] = b;
        this.imageData[i + 3] = a;
    }

    private void updateImage() {
    }

    private byte getR(int rgba) {
        return (byte)(rgba >> 16 & 0xFF);
    }

    private byte getG(int rgba) {
        return (byte)(rgba >> 8 & 0xFF);
    }

    private byte getB(int rgba) {
        return (byte)(rgba & 0xFF);
    }

    private byte getA(int rgba) {
        return (byte)(rgba >> 24 & 0xFF);
    }

    private int getRGBA(float r, float g, float b, float a) {
        return ((int)(a * 255.0f) & 0xFF) << 24 | ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }
}

