/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import commons.objects.ObjectElement;
import commons.world.WorldElement;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public abstract class PlayerObjectEvent
extends PlayerEvent {
    short objectid;
    byte variation;
    int cx;
    int cy;
    int cz;
    short px;
    short py;
    short pz;
    short rx;
    short ry;
    short rz;
    int info;
    byte status;
    Vector3f worldPosition = null;
    Quaternion worldRotation = null;

    protected PlayerObjectEvent(Player player, ObjectElement object) {
        this(player, object.typeid, object.variation, object.chunkoffsetx, object.chunkoffsety, object.chunkoffsetz, object.positionx, object.positiony, object.positionz, object.rotationx, object.rotationy, object.rotationz, object.info, object.status);
    }

    protected PlayerObjectEvent(Player player, short objectid, byte variation, int cx, int cy, int cz, short px, short py, short pz, short rx, short ry, short rz, int info, byte status) {
        super(player);
        this.objectid = objectid;
        this.variation = variation;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.info = info;
        this.status = status;
    }

    public short getObjectTypeID() {
        return this.objectid;
    }

    public byte getObjectVariation() {
        return this.variation;
    }

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionY() {
        return this.cy;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public Vector3f getObjectPosition() {
        if (this.worldPosition == null) {
            this.worldPosition = new Vector3f(WorldElement.toWorldPositionX((short)this.px, (int)this.cx), WorldElement.toWorldPositionX((short)this.py, (int)this.cy), WorldElement.toWorldPositionX((short)this.pz, (int)this.cz));
        }
        return this.worldPosition;
    }

    public float getObjectPositionX() {
        return WorldElement.toWorldPositionX((short)this.px, (int)this.cx);
    }

    public float getObjectPositionY() {
        return WorldElement.toWorldPositionX((short)this.py, (int)this.cy);
    }

    public float getObjectPositionZ() {
        return WorldElement.toWorldPositionX((short)this.pz, (int)this.cz);
    }

    public Quaternion getObjectRotation() {
        if (this.worldRotation == null) {
            this.worldRotation = new Quaternion().fromAngles(WorldElement.toWorldRotation((short)this.rx), WorldElement.toWorldRotation((short)this.ry), WorldElement.toWorldRotation((short)this.rz));
        }
        return this.worldRotation;
    }

    public int getObjectInfoID() {
        return this.info;
    }

    public byte getObjectStatus() {
        return this.status;
    }

    public Definitions.ObjectDefinition getObjectDefinition() {
        return Definitions.getObjectDefinition(this.objectid);
    }
}

