/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import commons.constructions.ConstructionElement;
import commons.world.WorldElement;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.world.PlayerConstructionEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class PlayerEditConstructionEvent
extends PlayerConstructionEvent
implements Cancellable {
    boolean cancelled = false;
    short ntypeid;
    int ntexture;
    int ncx;
    int ncy;
    int ncz;
    short npx;
    short npy;
    short npz;
    short nrx;
    short nry;
    short nrz;
    short nsx;
    short nsy;
    short nsz;
    byte nrepetitionsh;
    byte nrepetitionsv;
    byte ngap;
    Vector3f newWorldPosition = null;
    Vector3f newWorldSize = null;
    Quaternion newWorldRotation = null;

    public PlayerEditConstructionEvent(Player player, ConstructionElement construct) {
        super(player, construct);
    }

    public PlayerEditConstructionEvent(Player player, short typeid, int texture, int cx, int cy, int cz, short px, short py, short pz, short rx, short ry, short rz, short sx, short sy, short sz, byte repetitionsh, byte repetitionsv, byte gap, short ntypeid, int ntexture, int ncx, int ncy, int ncz, short npx, short npy, short npz, short nrx, short nry, short nrz, short nsx, short nsy, short nsz, byte nrepetitionsh, byte nrepetitionsv, byte ngap) {
        super(player, typeid, texture, cx, cy, cz, px, py, pz, rx, ry, rz, sx, sy, sz, repetitionsh, repetitionsv, gap);
        this.ntypeid = ntypeid;
        this.ntexture = ntexture;
        this.ncx = ncx;
        this.ncy = ncy;
        this.ncz = ncz;
        this.npx = npx;
        this.npy = npy;
        this.npz = npz;
        this.nrx = nrx;
        this.nry = nry;
        this.nrz = nrz;
        this.nsx = nsx;
        this.nsy = nsy;
        this.nsz = nsz;
        this.nrepetitionsh = nrepetitionsh;
        this.nrepetitionsv = nrepetitionsv;
        this.ngap = ngap;
    }

    public short getNewConstructionTypeID() {
        return this.ntypeid;
    }

    public int getNewConstructionTextureID() {
        return this.ntexture;
    }

    public int getNewChunkPositionX() {
        return this.ncx;
    }

    public int getNewChunkPositionY() {
        return this.ncy;
    }

    public int getNewChunkPositionZ() {
        return this.ncz;
    }

    public Vector3f getNewConstructionPosition() {
        if (this.newWorldPosition == null) {
            this.newWorldPosition = new Vector3f(WorldElement.toWorldPositionX((short)this.npx, (int)this.ncx), WorldElement.toWorldPositionX((short)this.npy, (int)this.ncy), WorldElement.toWorldPositionX((short)this.npz, (int)this.ncz));
        }
        return this.newWorldPosition;
    }

    public float getNewConstructionPositionX() {
        return WorldElement.toWorldPositionX((short)this.npx, (int)this.ncx);
    }

    public float getNewConstructionPositionY() {
        return WorldElement.toWorldPositionX((short)this.npy, (int)this.ncy);
    }

    public float getNewConstructionPositionZ() {
        return WorldElement.toWorldPositionX((short)this.npz, (int)this.ncz);
    }

    public Quaternion getNewConstructionRotation() {
        if (this.newWorldRotation == null) {
            this.newWorldRotation = new Quaternion().fromAngles(WorldElement.toWorldRotation((short)this.nrx), WorldElement.toWorldRotation((short)this.nry), WorldElement.toWorldRotation((short)this.nrz));
        }
        return this.newWorldRotation;
    }

    public Vector3f getNewConstructionSize() {
        if (this.newWorldSize == null) {
            this.newWorldSize = new Vector3f(ConstructionElement.toWorldSize((short)this.nsx), ConstructionElement.toWorldSize((short)this.nsy), ConstructionElement.toWorldSize((short)this.nsz));
        }
        return this.newWorldSize;
    }

    public float getNewConstructionSizeX() {
        return ConstructionElement.toWorldSize((short)this.nsx);
    }

    public float getNewConstructionSizeY() {
        return ConstructionElement.toWorldSize((short)this.nsy);
    }

    public float getNewConstructionSizeZ() {
        return ConstructionElement.toWorldSize((short)this.nsz);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

