/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player;

import commons.world.Text;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import pluginapi.PluginManager;
import pluginapi.objects.SignAPI;

public class PlayerSetSignTextEvent
extends PlayerEvent
implements Cancellable {
    int signID;
    String text;
    SignAPI internalSign = null;
    boolean cancelled = false;

    public PlayerSetSignTextEvent(Player player, int signID, String text) {
        super(player);
        this.signID = signID;
        this.text = text;
    }

    public String getText() {
        if (this.text == null) {
            return null;
        }
        return this.text.replaceAll("\\[#([0-9A-Fa-f]{2}){3}\\]", "");
    }

    public String getRawText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getNumLines() {
        this.updateSign();
        return this.internalSign.getNumLines();
    }

    public int getLineColor(int line) {
        this.updateSign();
        return this.internalSign.getLineColor(line);
    }

    public String getLineText(int line) {
        this.updateSign();
        return this.internalSign.getLineText(line);
    }

    public int getSignID() {
        return this.signID;
    }

    public Sign getSign() {
        return PluginManager.getWorld().getSign(this.signID);
    }

    private void updateSign() {
        if (this.internalSign == null) {
            Text txt = new Text();
            txt.globalID = -1;
            txt.text = this.text;
            this.internalSign = new SignAPI(txt);
        } else {
            this.internalSign.setText(this.text);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

