/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api;

import java.util.concurrent.atomic.AtomicInteger;
import pluginapi.PluginTimerManager;

public class Timer {
    private final int id = id_counter.getAndIncrement();
    private int repetitions;
    private float interval;
    private float delay;
    private float tick = 0.0f;
    private Runnable task;
    private boolean killed = false;
    private boolean paused = false;
    private boolean active = false;
    private static AtomicInteger id_counter = new AtomicInteger(0);

    public Timer(float interval, float delay, int repetitions, Runnable task) {
        this.interval = interval;
        this.delay = delay;
        this.repetitions = repetitions;
        this.task = task;
    }

    public void start() {
        if (this.killed) {
            System.err.println("Timer " + this.getID() + ": Timer is already killed!");
            return;
        }
        if (this.task == null) {
            System.err.println("Timer " + this.getID() + ": No task is set!");
        }
        if (!this.active) {
            this.tick = 0.0f;
            this.paused = false;
            this.active = true;
            PluginTimerManager.addTimer((Timer)this);
        } else if (this.paused) {
            this.paused = false;
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void kill() {
        this.killed = true;
        this.active = false;
        this.task = null;
        PluginTimerManager.removeTimer((Timer)this);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setInterval(float interval) {
        this.interval = interval;
    }

    public float getInterval() {
        return this.interval;
    }

    public void setInitialDelay(float delay) {
        this.delay = delay;
        if (this.delay < 0.0f) {
            this.delay = 0.0f;
        }
    }

    public float getInitialDelay() {
        return this.delay;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public Runnable getTask() {
        return this.task;
    }

    public void setTask(Runnable task) {
        this.task = task;
    }

    public int getID() {
        return this.id;
    }

    public void setTick(float tick) {
        this.tick = tick;
        if (this.tick < 0.0f) {
            this.tick = 0.0f;
        }
    }

    public float getTick() {
        return this.tick;
    }

    public static Timer findTimer(int id) {
        return PluginTimerManager.getTimer((int)id);
    }

    public static boolean killTimer(int id) {
        Timer timer = PluginTimerManager.getTimer((int)id);
        if (timer == null) {
            return false;
        }
        if (!timer.killed) {
            timer.kill();
            return true;
        }
        return false;
    }

    public static boolean timerExists(int id) {
        return PluginTimerManager.timerExists((int)id);
    }
}

