/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public final class GuiTitleBar
extends GuiPanel {
    public static final int TITLEBAR_HEIGHT = 30;
    private static final int CANCEL_YPOS = 24;
    private static final int TITLE_XPOS = 6;
    private static final int TITLE_YPOS = 24;
    private GuiImage cancelButton;
    private final int minWidth;
    private GuiLabel title;

    public GuiTitleBar(GuiElement parent, String titleText, boolean hasCancelButton) {
        this.setColor(0x505050FF);
        this.setPivot(PivotPosition.TopLeft);
        if (parent != null) {
            parent.addChild((GuiElement)this);
        }
        this.title = new GuiLabel(titleText, 6.0f, 24.0f, false);
        this.title.setPivot(PivotPosition.TopLeft);
        this.title.setText(titleText);
        this.title.setFontSize(18);
        this.title.setFontColor(-1);
        this.addChild((GuiElement)this.title);
        if (hasCancelButton) {
            this.cancelButton = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
            RWGui.setImage(this.cancelButton, 5);
            this.cancelButton.setPivot(PivotPosition.TopLeft);
            this.cancelButton.setClickable(true);
            this.cancelButton.setVisible(true);
            this.addChild((GuiElement)this.cancelButton);
        }
        this.minWidth = (int)(RWGui.getTextWidth(titleText, 18.0f) + (float)(hasCancelButton ? 36 : 6));
        this.setSize(this.minWidth, 30.0f, false);
    }

    public boolean isCancelButton(GuiElement element) {
        return element == this.cancelButton;
    }

    protected String getTitleText() {
        return this.title.getText();
    }

    protected void free() {
        this.removeChild((GuiElement)this.title);
        this.title = null;
        if (this.cancelButton != null) {
            this.removeChild((GuiElement)this.cancelButton);
            this.cancelButton = null;
        }
        this.removeFromParent();
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void relayout() {
        GuiElement parent = this.getParent();
        if (parent == null) {
            return;
        }
        int parentHeight = (int)parent.getHeight();
        int parentWidth = (int)parent.getWidth();
        int parentBorder = (int)parent.getBorderThickness();
        this.setPosition(parentBorder, parentHeight - parentBorder, false);
        this.setSize(parentWidth - parentBorder * 2, 30 - parentBorder, false);
        if (this.cancelButton != null) {
            this.cancelButton.setPosition((float)(parentWidth - 24), 24.0f, false);
        }
    }

    public void addToPlayer(Player player) {
        player.addGuiElement((GuiElement)this);
        player.addGuiElement((GuiElement)this.title);
        if (this.cancelButton != null) {
            player.addGuiElement((GuiElement)this.cancelButton);
        }
    }

    public void removeFromPlayer(Player player) {
        player.removeGuiElement((GuiElement)this);
        player.removeGuiElement((GuiElement)this.title);
        if (this.cancelButton != null) {
            player.removeGuiElement((GuiElement)this.cancelButton);
        }
    }
}

