/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiHorizontalLayout;
import com.vistamaresoft.rwgui.GuiTableLayout;
import com.vistamaresoft.rwgui.GuiVerticalLayout;
import com.vistamaresoft.rwgui.RWGui;
import java.util.ArrayList;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;

public class GuiLayout
extends GuiPanel {
    protected ArrayList<RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>>> children = null;
    protected int flags = 0;
    int margin = 0;
    int padding = 6;
    protected int shown = 0;

    public GuiLayout(int flags) {
        super(0.0f, 0.0f, false, 0.0f, 0.0f, false);
        this.setPivot(PivotPosition.TopLeft);
        this.flags = flags;
    }

    public void layout(int minWidth, int minHeight) {
        this.layout(minWidth, minHeight, true);
        int height = (int)this.getHeight();
        int width = (int)this.getWidth();
        this.layout(width, height, false);
    }

    public void free() {
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            if (item == null) continue;
            GuiElement element = item.getL();
            if (element instanceof GuiLayout) {
                ((GuiLayout)element).free();
            }
            super.removeChild(element);
        }
        this.children.clear();
    }

    public void hide(Player player) {
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            if (item == null) continue;
            GuiElement element = item.getL();
            if (element instanceof GuiLayout) {
                ((GuiLayout)element).hide(player);
                continue;
            }
            player.removeGuiElement(element);
        }
        player.removeGuiElement((GuiElement)this);
    }

    public void setMargin(int value) {
        this.margin = value;
    }

    public void setPadding(int value) {
        this.padding = value;
    }

    public void show(Player player) {
        player.addGuiElement((GuiElement)this);
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            if (item == null) continue;
            GuiElement element = item.getL();
            if (element instanceof GuiLayout) {
                ((GuiLayout)element).show(player);
                continue;
            }
            player.addGuiElement(element);
        }
        ++this.shown;
    }

    public void addChild(GuiElement element) {
        this.addChild(element, null, null);
    }

    public void addChild(GuiElement element, Integer id) {
        this.addChild(element, id, null);
    }

    public void addChild(GuiElement element, Integer id, Object data) {
        if (element == null) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList(4);
        }
        this.children.add(new RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>>(element, new RWGui.Pair<Integer, Object>(id, data)));
        if (element instanceof GuiImage) {
            ((GuiImage)element).setClickable(id != null);
        } else if (element instanceof GuiLabel) {
            ((GuiLabel)element).setClickable(id != null);
            ((GuiLabel)element).setFontSize(15);
        } else if (element instanceof GuiPanel) {
            ((GuiPanel)element).setClickable(id != null);
        } else if (element instanceof GuiTextField) {
            ((GuiTextField)element).setClickable(id != null);
            ((GuiTextField)element).setBorderThickness(1.0f, false);
            ((GuiTextField)element).setBackgroundPreset(1);
            ((GuiTextField)element).setEditable(id != null);
            ((GuiTextField)element).setListenForInput(id != null);
        }
        if (this instanceof GuiVerticalLayout) {
            if ((this.flags & 2) != 0) {
                element.setPivot(PivotPosition.TopRight);
            } else if ((this.flags & 1) != 0) {
                element.setPivot(PivotPosition.Center);
            } else {
                element.setPivot(PivotPosition.TopLeft);
            }
        } else {
            element.setPivot(PivotPosition.TopLeft);
        }
        super.addChild(element);
    }

    public void removeChild(GuiElement element) {
        if (this.children == null || element == null) {
            return;
        }
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            if (item == null || item.getL() != element) continue;
            this.children.remove(item);
            super.removeChild(element);
            break;
        }
    }

    public GuiLayout addNewLayoutChild(int layoutType, int layoutFlags) {
        GuiLayout layout;
        if (layoutType == 1) {
            layout = new GuiHorizontalLayout(layoutFlags);
        } else if (layoutType == 2) {
            layout = new GuiVerticalLayout(layoutFlags);
        } else {
            return null;
        }
        this.addChild((GuiElement)layout, null, null);
        return layout;
    }

    public GuiLayout addNewTableLayoutChild(int colNum, int rowNum, int flags) {
        GuiTableLayout layout = new GuiTableLayout(colNum, rowNum, flags);
        this.addChild((GuiElement)layout, null, null);
        return layout;
    }

    public Integer getItemId(GuiElement element) {
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            Integer id;
            if (item == null) continue;
            GuiElement e = item.getL();
            if (e instanceof GuiLayout && (id = ((GuiLayout)e).getItemId(element)) != null) {
                return id;
            }
            if (item.getL() != element) continue;
            return item.getR().getL();
        }
        return null;
    }

    public RWGui.Pair<Integer, Object> getItemData(GuiElement element) {
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            RWGui.Pair<Integer, Object> data;
            if (item == null) continue;
            GuiElement e = item.getL();
            if (e instanceof GuiLayout && (data = ((GuiLayout)e).getItemData(element)) != null) {
                return data;
            }
            if (item.getL() != element) continue;
            return item.getR();
        }
        return null;
    }

    public GuiElement getChildFromId(int id) {
        for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : this.children) {
            if (item == null || item.getR().getL() != id) continue;
            return item.getL();
        }
        return null;
    }

    void layout(int minWidth, int minHeight, boolean reset) {
    }

    void baseAddChild(GuiElement element) {
        super.addChild(element);
    }

    void baseRemoveChild(GuiElement element) {
        super.removeChild(element);
    }
}

