/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;

public class GuiCheckBox
extends GuiLayout {
    public static final int DISABLED = -1;
    public static final int UNCHECKED = 0;
    public static final int CHECKED = 1;
    private final GuiImage checkBox;
    private final Object data;
    private final int id;
    private final GuiLabel label;
    private final boolean radio;
    private int state;

    public GuiCheckBox(String text, int initialState, boolean radio, Integer id, Object data) {
        super(8);
        this.data = data;
        this.id = id;
        this.radio = radio;
        this.checkBox = new GuiImage(0.0f, 0.0f, false, 18.0f, 18.0f, false);
        RWGui.setImage(this.checkBox, this.state == 1 ? (radio ? 9 : 4) : (radio ? 10 : 6));
        super.addChild((GuiElement)this.checkBox, -2, null);
        this.checkBox.setPivot(PivotPosition.BottomLeft);
        this.label = new GuiLabel(text, 24.0f, 1.0f, false);
        super.addChild((GuiElement)this.label, -2, null);
        this.label.setPivot(PivotPosition.BottomLeft);
        this.setState(initialState);
    }

    public boolean isRadio() {
        return this.radio;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        GuiElement parent;
        if (newState < -1 || newState > 1) {
            newState = 0;
        }
        if (newState == this.state) {
            return;
        }
        this.state = newState;
        RWGui.setImage(this.checkBox, this.state == 1 ? (this.radio ? 9 : 4) : (this.radio ? 10 : 6));
        this.label.setFontColor(this.state == -1 ? -2139062017 : -1);
        this.setClickable(newState != -1);
        this.checkBox.setClickable(newState != -1);
        this.label.setClickable(newState != -1);
        if (this.radio && newState == 1 && (parent = this.getParent()) != null && parent instanceof GuiLayout) {
            for (RWGui.Pair<GuiElement, RWGui.Pair<Integer, Object>> item : ((GuiLayout)parent).children) {
                GuiCheckBox box;
                if (!(item.getL() instanceof GuiCheckBox) || !(box = (GuiCheckBox)item.getL()).isRadio() || box.getState() != 1 || box == this) continue;
                box.setState(0);
            }
        }
    }

    @Override
    void layout(int minWidth, int minHeight, boolean reset) {
        int height;
        int fontSize = this.label.getFontSize();
        if (fontSize > 18) {
            height = this.label.getFontSize();
            this.checkBox.setPosition((float)this.margin, (float)(this.margin + (height - 18) / 2), false);
            this.label.setPosition((float)(this.margin + 18 + this.padding), (float)this.margin, false);
        } else {
            height = 18;
            this.checkBox.setPosition((float)this.margin, (float)this.margin, false);
            this.label.setPosition((float)(this.margin + 18 + this.padding), (float)(this.margin + (18 - fontSize) / 2), false);
        }
        this.setSize((float)(this.margin * 2 + 18 + this.padding) + RWGui.getTextWidth(this.label.getText(), fontSize), height + this.margin * 2, false);
    }

    @Override
    public Integer getItemId(GuiElement element) {
        if (this.state != -1 && (element == this || element == this.checkBox || element == this.label)) {
            this.setState(this.radio ? 1 : 1 - this.state);
            return this.id;
        }
        return null;
    }

    @Override
    public RWGui.Pair<Integer, Object> getItemData(GuiElement element) {
        Integer myId = this.getItemId(element);
        if (myId != null) {
            return new RWGui.Pair<Integer, Object>(myId, this.data);
        }
        return null;
    }

    @Override
    public void addChild(GuiElement element) {
    }

    @Override
    public void addChild(GuiElement element, Integer id) {
    }

    @Override
    public void addChild(GuiElement element, Integer id, Object data) {
    }

    @Override
    public void removeChild(GuiElement element) {
    }

    @Override
    public GuiLayout addNewLayoutChild(int layoutType, int layoutFlags) {
        return null;
    }

    @Override
    public GuiLayout addNewTableLayoutChild(int colNum, int rowNum, int flags) {
        return null;
    }
}

