/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiImage;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.Vector2i;

public class RWGui
extends Plugin
implements Listener {
    public static final int BUTTON_SIZE = 18;
    public static final int ITEM_SIZE = 15;
    public static final int TEXTENTRY_HEIGHT = 23;
    public static final int TITLE_SIZE = 18;
    public static final int BORDER_THICKNESS = 2;
    public static final int DEFAULT_PADDING = 6;
    public static final float AVG_CHAR_WIDTH1 = 0.5f;
    public static final int PANEL_COLOUR = 0x202020FF;
    public static final int TITLEBAR_COLOUR = 0x505050FF;
    public static final int BORDER_COLOUR = -1869573889;
    public static final int ACTIVE_COLOUR = 6344959;
    public static final int INACTIVE_COLOUR = 0x404040FF;
    public static final int TEXT_COLOUR = -1;
    public static final int TITLE_COLOUR = -1;
    public static final int TEXT_SEL_COLOUR = 0xB0FFFF;
    public static final int TEXT_DIM_COLOUR = -2139062017;
    public static final int ICN_ARROW_DOWN = 0;
    public static final int ICN_ARROW_LEFT = 1;
    public static final int ICN_ARROW_RIGHT = 2;
    public static final int ICN_ARROW_UP = 3;
    public static final int ICN_CHECK = 4;
    public static final int ICN_CROSS = 5;
    public static final int ICN_UNCHECK = 6;
    public static final int ICN_PLUS = 7;
    public static final int ICN_MINUS = 8;
    public static final int ICN_RADIO_CHECK = 9;
    public static final int ICN_RADIO_UNCHECK = 10;
    public static final int ICN_MIN = 0;
    public static final int ICN_MAX = 10;
    public static final int LAYOUT_HORIZ = 1;
    public static final int LAYOUT_VERT = 2;
    public static final int LAYOUT_TABLE = 3;
    public static final int LAYOUT_H_LEFT = 0;
    public static final int LAYOUT_H_CENTRE = 1;
    public static final int LAYOUT_H_RIGHT = 2;
    public static final int LAYOUT_H_SPREAD = 4;
    public static final int LAYOUT_V_TOP = 0;
    public static final int LAYOUT_V_MIDDLE = 8;
    public static final int LAYOUT_V_BOTTOM = 16;
    public static final int LAYOUT_V_SPREAD = 32;
    public static final int OK_ID = 0;
    public static final int ABORT_ID = -1;
    protected static final int PGUP_ID = -2;
    protected static final int PGDN_ID = -3;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_PARAMETER = -1;
    public static final int ERR_MISSING_RESOURCE = -2;
    public static final int ERR_ITEM_NOT_FOUND = -3;
    private static final String version = "0.5.1";
    private static final ImageInformation[] stockIcons = new ImageInformation[11];
    private static final String[] stockIconPaths = new String[]{"/assets/arrowDown.png", "/assets/arrowLeft.png", "/assets/arrowRight.png", "/assets/arrowUp.png", "/assets/check.png", "/assets/cross.png", "/assets/uncheck.png", "/assets/plus.png", "/assets/minus.png", "/assets/radioCheck.png", "/assets/radioUncheck.png"};
    protected static String pluginPath;
    private static List<Pair<Integer, String>> users;

    public void onLoad() {
        pluginPath = this.getPath();
    }

    public void onEnable() {
        this.registerEventListener(this);
        System.out.println("RWGui 0.5.1 enabled successfully!");
    }

    public void onDisable() {
        this.unregisterEventListener(this);
        System.out.println("RWGui 0.5.1 disabled successfully!");
    }

    @EventMethod
    public void onConnect(PlayerConnectEvent event) {
        if (event.isNewPlayer()) {
            users = null;
        }
    }

    public static int setImage(GuiImage image, int iconId) {
        if (iconId < 0 || iconId > 10) {
            return -1;
        }
        if (stockIcons[iconId] == null) {
            RWGui.stockIcons[iconId] = new ImageInformation(pluginPath + stockIconPaths[iconId]);
        }
        image.setImage(stockIcons[iconId]);
        return 0;
    }

    public static float getTextWidth(String text, float fontSize) {
        return fontSize * 0.5f * (float)text.length();
    }

    public static Vector2i getElementSizes(GuiElement element) {
        Vector2i sizes = new Vector2i();
        if (element != null) {
            if (element instanceof GuiLabel) {
                String[] lines = ((GuiLabel)element).getText().split("\n");
                int fontSize = ((GuiLabel)element).getFontSize();
                int maxLength = 0;
                for (String line : lines) {
                    if (line.length() <= maxLength) continue;
                    maxLength = line.length();
                }
                sizes.x = (int)((float)fontSize * 0.5f * (float)maxLength);
                sizes.y = fontSize * lines.length;
            } else {
                sizes.y = (int)element.getHeight();
                sizes.x = (int)element.getWidth();
            }
        }
        return sizes;
    }

    public static String getPlayerNameFromId(Plugin plugin, int dbId) {
        if (users == null) {
            RWGui.getPlayers(plugin);
        }
        for (Pair<Integer, String> user : users) {
            if (user.getL() != dbId) continue;
            return user.getR();
        }
        return null;
    }

    public static int getPlayerDbIdFromName(Plugin plugin, String name) {
        if (users == null) {
            RWGui.getPlayers(plugin);
        }
        for (Pair<Integer, String> user : users) {
            if (!user.getR().equals(name)) continue;
            return user.getL();
        }
        return 0;
    }

    public static List<Pair<Integer, String>> getPlayers(Plugin plugin) {
        if (users != null) {
            return users;
        }
        users = new ArrayList<Pair<Integer, String>>();
        WorldDatabase db = plugin.getWorldDatabase();
        try (ResultSet result = db.executeQuery("SELECT `ID`,`Name` FROM `Player` ORDER BY `Name`ASC");){
            while (result.next()) {
                int id = result.getInt(1);
                String name = result.getString(2);
                Pair<Integer, String> item = new Pair<Integer, String>(id, name);
                users.add(item);
            }
            result.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return users;
    }

    public static interface RWGuiCallback {
        public void onCall(Player var1, int var2, Object var3);
    }

    public static class Pair<L, R> {
        private L l;
        private R r;

        public Pair(L l, R r) {
            this.l = l;
            this.r = r;
        }

        public L getL() {
            return this.l;
        }

        public R getR() {
            return this.r;
        }

        public void setL(L l) {
            this.l = l;
        }

        public void setR(R r) {
            this.r = r;
        }
    }
}

