/*
 * Decompiled with CFR 0.152.
 */
package ServerTools;

import ServerTools.ServerToolsDataBank;
import ServerTools.ServerToolsMain;
import ServerTools.ServerToolsObjects;
import ServerTools.ServerToolsUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import net.risingworld.api.Timer;
import net.risingworld.api.objects.Player;

public class ServerToolsTimersInit {
    ServerToolsMain STM = new ServerToolsMain();

    public void RankCheckTimerInit() {
        Timer timer = new Timer(Float.parseFloat(ServerToolsUtils.SettingbyName("RankcheckTimer")), 0.0f, -1, () -> {
            for (Player player : this.STM.getServer().getAllPlayers()) {
                int playtime = player.getTotalPlayTime();
                String permission = player.getPermissionGroup();
                for (int i = 1; i < ServerToolsDataBank.Ranks.getRankList().size(); ++i) {
                    if (playtime <= ServerToolsDataBank.Ranks.getRankList().get((int)i).reqtime || !permission.equals(ServerToolsDataBank.Ranks.getRankList().get((int)(i - 1)).name)) continue;
                    player.setPermissionGroup(ServerToolsDataBank.Ranks.getRankList().get((int)i).name);
                    this.STM.getServer().broadcastTextMessage(ServerToolsUtils.SettingbyName("RankingBotChatColour") + ServerToolsUtils.SettingbyName("RankingBotName") + ": " + player.getName() + " is now a " + player.getPermissionGroup() + "!");
                    if (ServerToolsDataBank.Ranks.getRankList().get((int)i).message.isEmpty()) continue;
                    player.sendTextMessage(ServerToolsUtils.SettingbyName("RankingBotChatColour") + ServerToolsUtils.SettingbyName("RankingBotName") + ": " + ServerToolsDataBank.Ranks.getRankList().get((int)i).message);
                }
            }
        });
        ServerToolsDataBank.TimerList.getTimers().add(timer);
        timer.start();
    }

    public void initRestartTimer() {
        ServerToolsDataBank.restartTimer = new Timer(Float.parseFloat(ServerToolsUtils.SettingbyName("RestartWarningsCheckInterval")), 0.0f, -1, () -> {
            LocalDateTime now = LocalDateTime.now();
            for (LocalDateTime cdatetime : ServerToolsDataBank.restartWarningTimes) {
                if (!now.isAfter(cdatetime)) continue;
                this.startWarningTimers(cdatetime);
                ServerToolsDataBank.restartTimer.pause();
                break;
            }
        });
        ServerToolsDataBank.restartTimer.start();
    }

    public void startWarningTimers(LocalDateTime triggerWarningTime) {
        for (int i = 0; i < ServerToolsDataBank.allWarnings.length; ++i) {
            Timer timer;
            int minutesToRestart = ServerToolsDataBank.allWarnings[i] / 60;
            int secondsToRestart = ServerToolsDataBank.allWarnings[i] % 60;
            if (ServerToolsDataBank.allWarnings[i] == ServerToolsDataBank.minSecondWarning) {
                timer = new Timer((float)(ServerToolsDataBank.maxMinuteWarning * 60 - ServerToolsDataBank.allWarnings[i]), 0.0f, 0, () -> {
                    this.STM.getServer().broadcastTextMessage(ServerToolsUtils.SettingbyName("RestartWarningsChatColour") + ServerToolsUtils.SettingbyName("RestartWarningsBotName") + ": Server restarting in " + Integer.toString(minutesToRestart) + " minutes and " + Integer.toString(secondsToRestart) + " seconds");
                    Timer timer2 = new Timer(60.0f, 0.0f, 0, () -> {
                        ServerToolsDataBank.restartWarningTimes.remove(triggerWarningTime);
                        ServerToolsDataBank.restartTimer.start();
                    });
                    timer2.start();
                });
                timer.start();
                continue;
            }
            timer = new Timer((float)(ServerToolsDataBank.maxMinuteWarning * 60 - ServerToolsDataBank.allWarnings[i]), 0.0f, 0, () -> this.STM.getServer().broadcastTextMessage(ServerToolsUtils.SettingbyName("RestartWarningsChatColour") + ServerToolsUtils.SettingbyName("RestartWarningsBotName") + ": Server restarting in " + Integer.toString(minutesToRestart) + " minutes and " + Integer.toString(secondsToRestart) + " seconds"));
            timer.start();
        }
    }

    public void RecurringMessages() {
        ArrayList<ServerToolsObjects.announcement> ann = ServerToolsDataBank.messagelist.getAnnouncements();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        for (int i = 0; i < ann.size(); ++i) {
            if (!ann.get((int)i).action.equals("recurring") || !(ann.get((int)i).recur > 0.0f)) continue;
            String message2 = ann.get((int)i).colourcode + ServerToolsUtils.SettingbyName("AutoMessageBotName") + ": " + ann.get((int)i).text;
            Timer timer = new Timer(ann.get((int)i).recur, 0.0f, -1, () -> this.STM.getServer().broadcastTextMessage(message2));
            timers.add(timer);
        }
        ServerToolsDataBank.TimerList.setTimers(timers);
        for (Timer timer : timers) {
            timer.start();
        }
    }
}

