/*
 * Decompiled with CFR 0.152.
 */
package ServerTools.Listeners;

import ServerTools.ServerToolsDataBank;
import ServerTools.ServerToolsMain;
import ServerTools.ServerToolsObjects;
import ServerTools.ServerToolsUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.inventory.PlayerChestToInventoryEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryAddEvent;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class ServerToolsPlayerListener
implements Listener {
    ServerToolsMain STM = new ServerToolsMain();
    ServerToolsObjects STO = new ServerToolsObjects();

    @EventMethod
    public void onChat(PlayerChatEvent event) {
        if (ServerToolsUtils.SettingbyName("PoliceBotMode").equals("on")) {
            Player player = event.getPlayer();
            String[] messageArr = event.getChatMessage().toLowerCase().split("]", 2);
            Date date = new Date();
            SimpleDateFormat Sdf = new SimpleDateFormat("dd/MM/yyyy");
            String datestr = Sdf.format(date);
            String message2 = messageArr[1] + " on " + datestr;
            boolean check = false;
            for (String bannedWord : ServerToolsDataBank.BannedLists.getBannedWords()) {
                if (!message2.contains(bannedWord)) continue;
                check = true;
            }
            if (check) {
                ArrayList<ServerToolsObjects.blacklistplayer> blacklist = ServerToolsDataBank.BlackList.getBlackList();
                ServerToolsObjects.blacklistplayer blp = new ServerToolsObjects.blacklistplayer(this.STO);
                blp.name = player.getName();
                blp.offence = message2;
                blacklist.add(blp);
                player.sendTextMessage(ServerToolsUtils.SettingbyName("PoliceBotChatColour") + ServerToolsUtils.SettingbyName("PoliceBotName") + ": You have commited an illegal language offence. Please watch the language!");
                ServerToolsDataBank.BlackList.setBlackList(blacklist);
                this.STM.WriteBlackListTxt();
            }
        }
    }

    @EventMethod
    public void onItemPickUp(PlayerInventoryAddEvent event) {
        Player player;
        if (ServerToolsUtils.SettingbyName("PoliceBotMode").equals("on") && !(player = event.getPlayer()).isAdmin()) {
            Item item = event.getItem();
            for (String BannedItem : ServerToolsDataBank.BannedLists.getBannedItems()) {
                if (!item.getName().equals(BannedItem)) continue;
                event.setCancelled(true);
                player.sendTextMessage(ServerToolsUtils.SettingbyName("PoliceBotChatColour") + ServerToolsUtils.SettingbyName("PoliceBotName") + ": Attempting to obtain illegal goods: " + item.getName() + ". Action denied!");
            }
        }
    }

    @EventMethod
    public void onItemPickUpFromChest(PlayerChestToInventoryEvent event) {
        Player player;
        if (ServerToolsUtils.SettingbyName("PoliceBotMode").equals("on") && !(player = event.getPlayer()).isAdmin()) {
            Item item = event.getItem();
            for (String BannedItem : ServerToolsDataBank.BannedLists.getBannedItems()) {
                if (item.getName() == null || BannedItem == null || !item.getName().equals(BannedItem)) continue;
                event.setCancelled(true);
                player.sendTextMessage(ServerToolsUtils.SettingbyName("PoliceBotChatColour") + ServerToolsUtils.SettingbyName("PoliceBotName") + ": Attempting to obtain illegal goods: " + item.getName() + ". Action denied!");
            }
        }
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        int i;
        Player player = event.getPlayer();
        ArrayList<ServerToolsObjects.announcement> ann = ServerToolsDataBank.messagelist.getAnnouncements();
        if (player.getPermissionGroup().equals(ServerToolsUtils.SettingbyName("NewPlayerPermGroup"))) {
            for (i = 0; i < ann.size(); ++i) {
                if (!ann.get((int)i).action.equals("onloginnew")) continue;
                player.sendTextMessage(ann.get((int)i).colourcode + ServerToolsUtils.SettingbyName("AutoMessageBotName") + ": " + ann.get((int)i).text);
            }
        } else if (player.isAdmin()) {
            for (i = 0; i < ann.size(); ++i) {
                if (!ann.get((int)i).action.equals("onlogin") && !ann.get((int)i).action.equals("onloginadmin")) continue;
                player.sendTextMessage(ann.get((int)i).colourcode + ServerToolsUtils.SettingbyName("AutoMessageBotName") + ": " + ann.get((int)i).text);
            }
        } else {
            for (i = 0; i < ann.size(); ++i) {
                if (!ann.get((int)i).action.equals("onlogin")) continue;
                player.sendTextMessage(ann.get((int)i).colourcode + ServerToolsUtils.SettingbyName("AutoMessageBotName") + ": " + ann.get((int)i).text);
            }
        }
        if (ServerToolsUtils.SettingbyName("Autogm1Mode").equals("on")) {
            ArrayList<Long> players = ServerToolsDataBank.Autogm1List.getAutogm1List();
            for (int i2 = 0; i2 < players.size(); ++i2) {
                long currentplayerUID = players.get(i2);
                if (player.getUID() != currentplayerUID) continue;
                player.setCreativeModeEnabled(true);
                break;
            }
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        ArrayList<ServerToolsObjects.announcement> ann = ServerToolsDataBank.messagelist.getAnnouncements();
        if (player.isAdmin()) {
            for (int i = 0; i < ann.size(); ++i) {
                if (!ann.get((int)i).action.equals("onloginadminbroadcast")) continue;
                this.STM.getServer().broadcastTextMessage(ann.get((int)i).colourcode + ServerToolsUtils.SettingbyName("AutoMessageBotName") + ": " + ann.get((int)i).text);
            }
        }
    }
}

