/*
 * Decompiled with CFR 0.152.
 */
package ServerTools;

import ServerTools.Listeners.ServerToolsCommandListener;
import ServerTools.Listeners.ServerToolsPlayerListener;
import ServerTools.ServerToolsDataBank;
import ServerTools.ServerToolsObjects;
import ServerTools.ServerToolsTimersInit;
import ServerTools.ServerToolsUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;

public class ServerToolsMain
extends Plugin {
    ServerToolsObjects STO = new ServerToolsObjects();

    public void onEnable() {
        ServerToolsDataBank.pluginPath = this.getPath();
        ServerToolsCommandListener STComL = new ServerToolsCommandListener();
        ServerToolsPlayerListener STPlaL = new ServerToolsPlayerListener();
        this.registerEventListener(STComL);
        this.registerEventListener(STPlaL);
        ServerToolsTimersInit STTI = new ServerToolsTimersInit();
        this.ReadFiles();
        this.ReadAMFiles();
        STTI.RecurringMessages();
        if (ServerToolsUtils.SettingbyName("RankingBotMode").equals("on")) {
            STTI.RankCheckTimerInit();
        }
        if (ServerToolsUtils.SettingbyName("RestartWarningsMode").equals("on")) {
            this.readRestartWarnings();
            STTI.initRestartTimer();
        }
    }

    public void ReadFiles() {
        String content;
        String content2;
        String content3;
        File Autogm1ListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/autogm1list.txt");
        ArrayList<String> playerdata = new ArrayList<String>();
        if (Autogm1ListTxt.exists() && (content3 = Utils.FileUtils.readStringFromFile((File)Autogm1ListTxt)) != null && !content3.isEmpty()) {
            String[] playernamesarray = content3.replace("[", "").replace("]", "").split(", ");
            playerdata.addAll(Arrays.asList(playernamesarray));
        }
        ServerToolsDataBank.Autogm1List.setStringAutogm1List(playerdata);
        File RankListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/ranklist.txt");
        ArrayList<ServerToolsObjects.rank> ranks = new ArrayList<ServerToolsObjects.rank>();
        if (RankListTxt.exists() && (content2 = Utils.FileUtils.readStringFromFile((File)RankListTxt)) != null && !content2.isEmpty()) {
            String[] lines;
            for (String line : lines = content2.split("\r\n|\n|\r")) {
                String[] cline = line.split(";", 3);
                if (cline.length < 2 || cline.length > 3) continue;
                ServerToolsObjects.rank r = new ServerToolsObjects.rank(this.STO);
                r.name = cline[0];
                r.reqtime = Integer.parseInt(cline[1]);
                r.message = cline.length == 3 ? cline[2] : "";
                ranks.add(r);
            }
        }
        ServerToolsDataBank.Ranks.setRankList(ranks);
        File BlackListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/blacklist.txt");
        ArrayList<ServerToolsObjects.blacklistplayer> blacklistdata = new ArrayList<ServerToolsObjects.blacklistplayer>();
        if (BlackListTxt.exists() && (content = Utils.FileUtils.readStringFromFile((File)BlackListTxt)) != null && !content.isEmpty()) {
            String[] lines;
            for (String line : lines = content.replace("[", "").replace("]", "").split(", ")) {
                String[] cline = line.split(";", 2);
                if (cline.length != 2) continue;
                ServerToolsObjects.blacklistplayer blp = new ServerToolsObjects.blacklistplayer(this.STO);
                blp.name = cline[0];
                blp.offence = cline[1];
                blacklistdata.add(blp);
            }
        }
        ServerToolsDataBank.BlackList.setBlackList(blacklistdata);
        File settingsTxt = new File(ServerToolsDataBank.pluginPath + "/assets/settings.txt");
        if (settingsTxt.exists()) {
            String content4 = Utils.FileUtils.readStringFromFile((File)settingsTxt);
            if (content4 != null && !content4.isEmpty()) {
                String[] lines = content4.split("\r\n|\n|\r");
                String[][] settings = new String[lines.length][2];
                int linecount = 0;
                for (String line : lines) {
                    String[] cline = line.split("=", 2);
                    if (cline.length != 2) continue;
                    settings[linecount][0] = cline[0];
                    settings[linecount][1] = cline[1];
                    ++linecount;
                }
                ServerToolsDataBank.Settings.setSettings(settings);
            } else {
                String[][] settings = new String[0][0];
                ServerToolsDataBank.Settings.setSettings(settings);
            }
        } else {
            String[][] settings = new String[0][0];
            ServerToolsDataBank.Settings.setSettings(settings);
        }
        File BannedItemsTxt = new File(ServerToolsDataBank.pluginPath + "/assets/banneditems.txt");
        if (BannedItemsTxt.exists()) {
            String content5 = Utils.FileUtils.readStringFromFile((File)BannedItemsTxt);
            if (content5 != null && !content5.isEmpty()) {
                String[] lines = content5.split("\r\n|\n|\r");
                ServerToolsDataBank.BannedLists.setBannedItems(lines);
            } else {
                String[] setdef = new String[]{};
                ServerToolsDataBank.BannedLists.setBannedItems(setdef);
            }
        } else {
            String[] setdef = new String[]{};
            ServerToolsDataBank.BannedLists.setBannedItems(setdef);
        }
        File BannedWordsTxt = new File(ServerToolsDataBank.pluginPath + "/assets/bannedwords.txt");
        if (BannedWordsTxt.exists()) {
            String content6 = Utils.FileUtils.readStringFromFile((File)BannedWordsTxt);
            if (content6 != null && !content6.isEmpty()) {
                String[] lines = content6.split("\r\n|\n|\r");
                ServerToolsDataBank.BannedLists.setBannedWords(lines);
            } else {
                String[] setdef = new String[]{};
                ServerToolsDataBank.BannedLists.setBannedWords(setdef);
            }
        } else {
            String[] setdef = new String[]{};
            ServerToolsDataBank.BannedLists.setBannedWords(setdef);
        }
    }

    public void ReadAMFiles() {
        String content;
        String content2;
        ArrayList<ServerToolsObjects.message> messages = new ArrayList<ServerToolsObjects.message>();
        int count = 1;
        File MessageTxt = new File(ServerToolsDataBank.pluginPath + "/assets/messages.txt");
        if (MessageTxt.exists() && (content2 = Utils.FileUtils.readStringFromFile((File)MessageTxt)) != null && !content2.isEmpty()) {
            String[] lines;
            for (String line : lines = content2.split("\r\n|\n|\r")) {
                String[] cline = line.split(";");
                if (cline.length != 3) continue;
                ServerToolsObjects.message Mes = new ServerToolsObjects.message(this.STO);
                Mes.number = count++;
                Mes.name = cline[0];
                Mes.colourcode = cline[1];
                Mes.text = cline[2];
                messages.add(Mes);
            }
        }
        ServerToolsDataBank.messagelist.setMessages(messages);
        ArrayList<ServerToolsObjects.announcement> announcements = new ArrayList<ServerToolsObjects.announcement>();
        File AnnouncementTxt = new File(ServerToolsDataBank.pluginPath + "/assets/announcements.txt");
        if (AnnouncementTxt.exists() && (content = Utils.FileUtils.readStringFromFile((File)AnnouncementTxt)) != null && !content.isEmpty()) {
            String[] lines;
            for (String line : lines = content.split("\r\n|\n|\r")) {
                String[] cline = line.split(";");
                if (cline.length < 4 || cline.length > 5) continue;
                ServerToolsObjects.announcement Ann = new ServerToolsObjects.announcement(this.STO);
                Ann.action = cline[0];
                Ann.name = cline[1];
                Ann.colourcode = cline[2];
                if (cline[0].equals("recurring")) {
                    Ann.recur = Float.parseFloat(cline[3]);
                    Ann.text = cline[4];
                } else {
                    Ann.text = cline[3];
                }
                announcements.add(Ann);
                ++count;
            }
        }
        ServerToolsDataBank.messagelist.setAnnouncements(announcements);
    }

    public void readRestartWarnings() {
        String content;
        File RestartWarningsTxt = new File(ServerToolsDataBank.pluginPath + "/assets/restartwarnings.txt");
        if (RestartWarningsTxt.exists() && (content = Utils.FileUtils.readStringFromFile((File)RestartWarningsTxt)) != null && !content.isEmpty()) {
            String[] lines = content.split("\r\n|\n|\r");
            ArrayList<LocalDateTime> restartTimes = new ArrayList<LocalDateTime>();
            int[] minuteWarnings = null;
            int[] secondWarnings = null;
            block10: for (String line : lines) {
                String[] cline = line.split("=");
                switch (cline[0]) {
                    case "restartTimes": {
                        String[] times = cline[1].split(";");
                        for (int i = 0; i < times.length; ++i) {
                            LocalDate date;
                            LocalTime ctime;
                            int minute;
                            String[] time = times[i].split(":");
                            if (time.length != 2) continue;
                            int hour = Integer.parseInt(time[0]);
                            LocalTime crestart = LocalTime.of(hour, minute = Integer.parseInt(time[1]));
                            if (crestart.isAfter(ctime = LocalTime.now())) {
                                date = LocalDate.now();
                                restartTimes.add(LocalDateTime.of(date, crestart));
                                continue;
                            }
                            if (crestart.equals(LocalTime.MIDNIGHT)) {
                                date = LocalDate.now();
                                restartTimes.add(LocalDateTime.of(date, crestart));
                                continue;
                            }
                            if (!crestart.isBefore(ctime)) continue;
                            date = LocalDate.now().plusDays(1L);
                            restartTimes.add(LocalDateTime.of(date, crestart));
                        }
                        continue block10;
                    }
                    case "restartWarningsMinutes": {
                        String[] minutes = cline[1].split(";");
                        minuteWarnings = new int[minutes.length];
                        for (int i = 0; i < minutes.length; ++i) {
                            minuteWarnings[i] = Integer.parseInt(minutes[i]);
                        }
                        ServerToolsDataBank.maxMinuteWarning = -1;
                        for (int i : minuteWarnings) {
                            if (ServerToolsDataBank.maxMinuteWarning >= i) continue;
                            ServerToolsDataBank.maxMinuteWarning = i;
                        }
                        continue block10;
                    }
                    case "restartWarningsSeconds": {
                        String[] seconds = cline[1].split(";");
                        secondWarnings = new int[seconds.length];
                        for (int i = 0; i < seconds.length; ++i) {
                            secondWarnings[i] = Integer.parseInt(seconds[i]);
                        }
                        ServerToolsDataBank.minSecondWarning = 61;
                        for (int i : secondWarnings) {
                            if (ServerToolsDataBank.minSecondWarning <= i) continue;
                            ServerToolsDataBank.minSecondWarning = i;
                        }
                        continue block10;
                    }
                }
            }
            if (secondWarnings != null && minuteWarnings != null) {
                for (LocalDateTime cdatetime : restartTimes) {
                    ServerToolsDataBank.restartWarningTimes.add(cdatetime.minusMinutes(ServerToolsDataBank.maxMinuteWarning));
                }
                ServerToolsDataBank.allWarnings = new int[secondWarnings.length + minuteWarnings.length];
                int count = 0;
                for (int minutes : minuteWarnings) {
                    ServerToolsDataBank.allWarnings[count] = minutes * 60;
                    ++count;
                }
                int[] nArray = secondWarnings;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int seconds;
                    ServerToolsDataBank.allWarnings[count] = seconds = nArray[i];
                    ++count;
                }
            } else {
                System.out.println("Error in ServerTools plugin! You have not set the restartWarningsMinutes and restartWarningsSeconds settings!");
            }
        }
    }

    public void WriteAutogm1ListTxt(long playerUID) {
        File Autogm1ListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/autogm1list.txt");
        ArrayList<Long> players = ServerToolsDataBank.Autogm1List.getAutogm1List();
        boolean addcheck = true;
        System.out.println("writeAutogm1List");
        Player player = this.getServer().getPlayer(playerUID);
        for (int i = 0; i < players.size(); ++i) {
            if (players.get(i) != playerUID) continue;
            addcheck = false;
            player.sendTextMessage(ServerToolsUtils.SettingbyName("GeneralPluginTextColour") + "You are already in the autogm1 list!");
        }
        if (addcheck) {
            players.add(playerUID);
            player.sendTextMessage(ServerToolsUtils.SettingbyName("GeneralPluginTextColour") + "You have been succesfully added to the autogm1 list!");
        }
        ServerToolsDataBank.Autogm1List.setLongAutogm1List(players);
        Utils.FileUtils.writeStringToFile((String)players.toString(), (File)Autogm1ListTxt);
    }

    public void DeleteAutogm1ListTxt(long playerUID) {
        File Autogm1ListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/autogm1list.txt");
        ArrayList<Long> players = ServerToolsDataBank.Autogm1List.getAutogm1List();
        boolean delcheck = false;
        Player player = this.getServer().getPlayer(playerUID);
        for (int i = 0; i < players.size(); ++i) {
            if (players.get(i) != playerUID) continue;
            players.remove(i);
            player.sendTextMessage(ServerToolsUtils.SettingbyName("GeneralPluginTextColour") + "You have been succesfully removed from the autogm1 list!");
            delcheck = true;
            break;
        }
        if (!delcheck) {
            player.sendTextMessage(ServerToolsUtils.SettingbyName("GeneralPluginTextColour") + "You are not in the autogm1 list!");
        }
        ServerToolsDataBank.Autogm1List.setLongAutogm1List(players);
        Utils.FileUtils.writeStringToFile((String)players.toString(), (File)Autogm1ListTxt);
    }

    public void WriteBlackListTxt() {
        File BlackListTxt = new File(ServerToolsDataBank.pluginPath + "/assets/blacklist.txt");
        ArrayList<ServerToolsObjects.blacklistplayer> blacklistdata = ServerToolsDataBank.BlackList.getBlackList();
        Object[] outarr = new String[blacklistdata.size()];
        for (int i = 0; i < blacklistdata.size(); ++i) {
            outarr[i] = blacklistdata.get((int)i).name + ";" + blacklistdata.get((int)i).offence;
        }
        String outdata = Arrays.toString(outarr);
        Utils.FileUtils.writeStringToFile((String)outdata, (File)BlackListTxt);
    }

    public void onDisable() {
    }
}

