/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.GetConfigDaten;
import de.chaoswg.ShutdownInfoTimerClassText;
import de.chaoswg.ShutdownInfoTimerErrorSprachAPI;
import de.chaoswg.SprachAPI;
import java.io.FilenameFilter;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.ShutdownEvent;
import net.risingworld.api.events.general.UpdateEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;

public class ShutdownInfoTimer
extends Plugin
implements Listener {
    private ShutdownInfoTimer plugin;
    private Server server;
    private World world;
    private int debug;
    private String conf;
    private SprachAPI sprachApiPlugin;
    String recSprachApiVersion;
    private int restartTime;
    private int[][] iShutdownTime;
    private float lastUpdate;
    private float stepp;
    private DateTimeFormatter dtf;
    private Duration elapsed;
    private LocalTime[] daylyShutdownDate;
    private String[] intList;
    private ArrayList<Integer> intValu;
    private DateTimeFormatter chatDTF;
    private FilenameFilter filter;
    private boolean timeInChat;
    private ShutdownInfoTimerClassText sprachApiDaten;
    private GetConfigDaten sysConfig;

    public int getDebug() {
        return this.debug;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.conf = CRT.getSpec() + "config";
        this.debug = 1;
        this.recSprachApiVersion = "1.1.2";
        String pattern = "yyyy-MM-dd HH:mm:ss";
        this.dtf = DateTimeFormatter.ofPattern(pattern);
        this.stepp = 7.5f;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled ");
        }
        String[] aRecSprachApiVersion = this.recSprachApiVersion.split("\\.", 3);
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled reqVer[" + this.recSprachApiVersion + "]  verLeng[" + aRecSprachApiVersion.length + "] ");
        }
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.sprachApiPlugin = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            String[] spApiVer = this.sprachApiPlugin.getDescription("version").split("\\.", 3);
            if (CRT.isSameVersion((String)this.recSprachApiVersion, (String)this.sprachApiPlugin.getDescription("version"), (CRT.ClassDebug)new CRT.ClassDebug((Plugin)this.plugin, 3))) {
                this.sprachApiDaten = new ShutdownInfoTimerClassText();
                this.sprachApiDaten.setDebug(this.debug);
                this.sprachApiDaten.setDir(this.conf + this.sprachApiDaten.getDir());
                this.sprachApiDaten.INI(this.plugin);
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ") OK");
                }
                String[][] sysConfigArray = new String[][]{{"restartTime", "3"}, {"intervall", "15 10 5 1"}, {"dayly", "1:30"}, {"command", "SIT"}, {"timeInChat", "true"}, {"timekeeping", "7.5"}, {"Debug", String.valueOf(this.debug)}};
                this.sysConfig = new GetConfigDaten("System", sysConfigArray, (Plugin)this, this.debug, this.conf);
                this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
                this.restartTime = Integer.parseInt(this.sysConfig.getValue("restartTime"));
                this.timeInChat = this.sysConfig.getValue("restartTime").toLowerCase().equals("true");
                this.stepp = Float.valueOf(this.sysConfig.getValue("timekeeping")).floatValue();
                this.chatDTF = DateTimeFormatter.ofPattern("HH:mm:ss");
                if (this.sysConfig.getValue("dayly") != null) {
                    String[] sShutdownTimeArray = this.sysConfig.getValue("dayly").split(" ");
                    int sShutdownTimePartMax = 0;
                    for (String sShutdownTimePart : sShutdownTimeArray) {
                        String[] sShutdownTime = sShutdownTimePart.split(":");
                        if (sShutdownTime.length > sShutdownTimePartMax) {
                            sShutdownTimePartMax = sShutdownTime.length;
                        }
                        if (this.debug <= 3) continue;
                        System.out.println("[" + this.plugin.getDescription("name") + "] Enabled dayly " + sShutdownTimePart + " ");
                    }
                    this.iShutdownTime = new int[sShutdownTimeArray.length][sShutdownTimePartMax];
                    this.daylyShutdownDate = new LocalTime[sShutdownTimeArray.length];
                    for (int n = 0; n < this.iShutdownTime.length; ++n) {
                        if (sShutdownTimeArray.length <= 0) continue;
                        String[] sShutdownTime = sShutdownTimeArray[n].split(":");
                        for (int nn = 0; nn < sShutdownTime.length; ++nn) {
                            this.iShutdownTime[n][nn] = !sShutdownTime[nn].equals("") ? Integer.parseInt(sShutdownTime[nn]) : -1;
                        }
                        if (this.iShutdownTime[n][0] < 0 || this.iShutdownTime[n][1] < 0) continue;
                        this.daylyShutdownDate[n] = LocalTime.of(this.iShutdownTime[n][0], this.iShutdownTime[n][1]);
                        if (this.debug <= 3) continue;
                        System.out.println("[" + this.plugin.getDescription("name") + "] Enabled dayly " + sShutdownTimeArray[n] + "|" + this.iShutdownTime[n][0] + "|" + this.iShutdownTime[n][1]);
                    }
                } else {
                    this.daylyShutdownDate = null;
                }
                if (this.sysConfig.getValue("intervall") != null) {
                    this.intList = this.sysConfig.getValue("intervall").split(" ");
                    this.intValu = new ArrayList();
                    for (int n = 0; n < this.intList.length; ++n) {
                        this.intValu.add(Integer.parseInt(this.intList[n]) * 60);
                    }
                }
                if (this.debug > 4) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled currentTimeMillis " + System.currentTimeMillis() + " ");
                }
                this.registerEventListener(this);
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Die Version von Plugin 'SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ")' ist zu klein! Bitte Aktualisieren auf Version(" + this.recSprachApiVersion + ")!");
                this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
            }
        } else if (this.plugin.getPluginByName("SprachAPI") == null) {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
        }
    }

    public void onDisable() {
        System.out.println("[" + this.plugin.getDescription("name") + "] Disabled");
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Shutdown Connect ");
        }
        Player player = event.getPlayer();
    }

    @EventMethod
    public void onShutdown(ShutdownEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Shutdown ausf\u00fchren nach " + this.server.getRunningTime() + " ");
        }
        this.server.getAllPlayers().forEach(player -> {
            if (player != null) {
                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownnow"), this.restartTime);
                player.sendYellMessage(str.replaceAll("\\[#[0-9a-fA-F]{6}\\]", ""));
                player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
            }
        });
    }

    @EventMethod
    public void onUpdate(UpdateEvent event) {
        if (this.lastUpdate + this.stepp <= this.server.getRunningTime()) {
            this.lastUpdate = this.server.getRunningTime();
            String output = this.dtf.format(LocalDateTime.now());
            for (int n = 0; n < this.daylyShutdownDate.length; ++n) {
                if (this.daylyShutdownDate != null && this.daylyShutdownDate[n] != null) {
                    this.elapsed = Duration.between(LocalDateTime.now(), LocalDateTime.of(LocalDate.now(), this.daylyShutdownDate[n]));
                    if ((float)this.elapsed.getSeconds() < this.stepp && !this.elapsed.isNegative()) {
                        if (this.debug > 2 && this.debug != 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + n + "] " + this.chatDTF.format(LocalTime.now()));
                        }
                        if (this.debug == 1) {
                            System.out.println("Erwarteter Neustart[" + n + "] - [" + this.plugin.getDescription("name") + " | Zeitstempel  | " + output + "] ");
                        }
                        this.server.getAllPlayers().forEach(player -> {
                            if (player != null) {
                                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdown"), 0);
                                player.sendYellMessage(str.replaceAll("\\[#[0-9a-fA-F]{6}\\]", ""));
                                player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
                            }
                        });
                    }
                    CRT.ClassLambadHelper l = new CRT.ClassLambadHelper();
                    l.n = n;
                    this.intValu.forEach(counter -> {
                        if ((float)this.elapsed.getSeconds() < (float)counter.intValue() + this.stepp && this.elapsed.getSeconds() >= (long)counter.intValue()) {
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + l.n + "][" + counter + "] " + this.chatDTF.format(LocalTime.now()));
                            }
                            CRT.ClassLambadHelper ll = new CRT.ClassLambadHelper();
                            ll.n = counter / 60;
                            this.server.getAllPlayers().forEach(player -> {
                                if (player != null) {
                                    String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownin"), ll.n);
                                    player.sendYellMessage(str.replaceAll("\\[#[0-9a-fA-F]{6}\\]", ""));
                                    player.sendTextMessage((this.timeInChat ? this.chatDTF.format(LocalTime.now()) + " - " : "") + str);
                                }
                            });
                        }
                    });
                }
                if (this.debug <= 3) continue;
                System.out.println("[" + this.plugin.getDescription("name") + "] Update Time[" + n + "] " + this.server.getRunningTime() + " now[" + output + "]  in[" + (this.elapsed != null ? Long.valueOf(this.elapsed.getSeconds()) : "NULL") + "] ");
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String command = event.getCommand();
        String[] cmd = command.split(" ");
        if (cmd[0].toLowerCase().equals("/" + this.sysConfig.getValue("command")) || cmd[0].toLowerCase().equals("/" + this.sysConfig.getValue("command").toLowerCase())) {
            if (cmd.length > 1) {
                player.sendTextMessage("");
                player.sendTextMessage("#> " + cmd[0].substring(1) + " " + command.substring(1 + cmd[0].length()));
            }
            if (cmd.length > 1) {
                if (cmd[1].toLowerCase().equals("debug")) {
                    int deb = this.debug;
                    try {
                        this.debug = Integer.parseInt(cmd[2]);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("[" + this.plugin.getDescription("name") + "] Fehler " + e.getMessage());
                        this.debug = deb;
                    }
                }
                if (cmd[1].toLowerCase().equals("status")) {
                    String output = this.dtf.format(LocalDateTime.now());
                    for (int n = 0; n < this.daylyShutdownDate.length; ++n) {
                        if (this.daylyShutdownDate != null && this.daylyShutdownDate[n] != null) {
                            this.elapsed = Duration.between(LocalDateTime.now(), LocalDateTime.of(LocalDate.now(), this.daylyShutdownDate[n]));
                            if (this.debug >= 0) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + n + "] " + this.chatDTF.format(this.daylyShutdownDate[n]));
                            }
                            if ((float)this.elapsed.getSeconds() < this.stepp && !this.elapsed.isNegative() && this.debug >= 0) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + n + "] " + this.chatDTF.format(LocalTime.now()));
                            }
                            CRT.ClassLambadHelper l = new CRT.ClassLambadHelper();
                            l.n = n;
                            l.obj = this.daylyShutdownDate[n];
                            this.intValu.forEach(counter -> {
                                if (this.debug >= 0) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + l.n + "][" + counter + "] " + this.chatDTF.format(((LocalDateTime)l.obj).minusSeconds(counter.intValue())));
                                }
                                if ((float)this.elapsed.getSeconds() < (float)counter.intValue() + this.stepp && this.elapsed.getSeconds() >= (long)counter.intValue() && this.debug >= 0) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + l.n + "][" + counter + "] " + this.chatDTF.format(LocalTime.now()));
                                }
                            });
                        }
                        if (this.debug < 0) continue;
                        System.out.println("[" + this.plugin.getDescription("name") + "] Update      Time[" + n + "] " + this.server.getRunningTime() + " now[" + output + "]  in[" + (this.elapsed != null ? Long.valueOf(this.elapsed.getSeconds()) : "NULL") + "] ");
                    }
                }
            }
        }
    }

    class SortedProperties
    extends Properties {
        SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }
}

