#!/bin/bash
SCREEN_NAME=""

txtgrn=$(tput setaf 2) # Green
txtred=$(tput setaf 1) # Red
txtbld=$(tput bold) # Bold
txtreset=$(tput sgr0) # reset colors

if [ ! -x `which screen` ]; then echo "You have to install screen first!"; exit 1; fi
if [ ! -x `which java` ]; then echo "You have to install java first!"; exit 1; fi

cd $(pwd)

function checkTitle(){
	if [ -n "$1" ]; then
		SCREEN_NAME=$1
	else
		SCREEN_NAME=`grep -i 'server_screen_title' server.properties | tr -d '\n\r' | cut -f2 -d'='`
	fi

	if [ -z "$SCREEN_NAME" ]; then
		echo "${txtred}No server_title set. Set title to 'Rising World Server'${txtreset}"
		SCREEN_NAME="Rising World Server"
	fi

	if ! [[ $SCREEN_NAME =~ ^[a-zA-Z0-9_.-]+$ ]]; then
		echo "${txtred}The Server title contains invalid symbol. Only a-z A-Z 0-9 - _ . are allowed${txtreset}"
		exit 1;
	fi

}



case "$1" in
	start)
		checkTitle $2
		MEMORY=$(grep -i 'server_memory' server.properties | tr -d '\n\r' | cut -f2 -d'=')
		if [ -z "$MEMORY" ]; then
			echo "${txtred}No server_memory set. Server starts with 1024mb memory${txtreset}"
			MEMORY=1024
		fi
		if ! [[ $MEMORY =~ ^[0-9]+$ ]]; then
			echo "${txtred}The property 'server_memory' is not numeric${txtreset}"
			exit 1;
		fi

		if screen -ls | grep [.]${SCREEN_NAME}[[:space:]] > /dev/null
		then
			echo "${SCREEN_NAME} is already running";
		else
			screen -dmSL ${SCREEN_NAME} java -Xmx${MEMORY}m -Xms$(($MEMORY/2))m -jar server.jar

			if screen -ls | grep [.]${SCREEN_NAME}[[:space:]] > /dev/null
			then
				echo "${txtgrn}${SCREEN_NAME} is successfully started${txtreset}"
			else
				echo "${SCREEN_NAME} an error has orcuded${txtreset}"
			fi
		fi
	;;
	stop)
		checkTitle $2
		if screen -ls | grep [.]${SCREEN_NAME}[[:space:]] > /dev/null
		then
			screen -S ${SCREEN_NAME} -p 0 -X quit
			echo "${txtgrn}${SCREEN_NAME} is successfully stopped${txtreset}"
		else
			echo "${txtred}No screen with name '${SCREEN_NAME}' found${txtreset}"
		fi

	;;
	restart)
		$0 stop && $0 start || exit 1
	;;
	status)
		checkTitle $2
		if screen -ls | grep [.]${SCREEN_NAME}[[:space:]] > /dev/null
		then
			echo "${SCREEN_NAME} is ${txtgrn}${txtbld}running${txtreset}"
		else
			echo "${SCREEN_NAME} is ${txtred}${txtbld}not running${txtreset}"
		fi
	;;
	attach)
		checkTitle $2
		if screen -ls | grep [.]${SCREEN_NAME}[[:space:]] > /dev/null
		then
			screen -r ${SCREEN_NAME}
		else
			echo "${txtred}No screen with name '${SCREEN_NAME}' found${txtreset}"
		fi
	;;
	*)
		echo "Usage: linux_startscript.sh {start|stop|restart|status|attach} [title]"
		exit 2
esac
exit 0