/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.GetConfigDaten;
import de.chaoswg.ShutdownInfoTimerClassText;
import de.chaoswg.ShutdownInfoTimerErrorSprachAPI;
import de.chaoswg.SprachAPI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.ShutdownEvent;
import net.risingworld.api.events.general.UpdateEvent;
import net.risingworld.api.objects.Player;

public class ShutdownInfoTimer
extends Plugin
implements Listener {
    private ShutdownInfoTimer plugin;
    private Server server;
    private World world;
    private int debug;
    private String conf;
    private SprachAPI sprachApiPlugin;
    String recSprachApiVersion;
    private int restartTime;
    private int[] iShutdownTime;
    private float lastUpdate;
    private float stepp;
    private DateTimeFormatter dtf;
    private Duration elapsed;
    private LocalDateTime daylyShutdownDate;
    private String[] intList;
    private ArrayList<Integer> intValu;
    private DateTimeFormatter chatDTF;
    private ShutdownInfoTimerClassText sprachApiDaten;
    private GetConfigDaten sysConfig;

    public int getDebug() {
        return this.debug;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.conf = "/config";
        this.debug = 1;
        this.recSprachApiVersion = "1.1.0";
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled ");
        }
        String[] aRecSprachApiVersion = this.recSprachApiVersion.split("\\.", 3);
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled reqVer[" + this.recSprachApiVersion + "]  verLeng[" + aRecSprachApiVersion.length + "] ");
        }
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            this.sprachApiDaten = new ShutdownInfoTimerClassText();
            this.sprachApiDaten.setDebug(this.debug);
            this.sprachApiDaten.sDir = this.conf + "/locale";
            this.sprachApiDaten.INI(this);
            this.sprachApiPlugin = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            String[] spApiVer = this.sprachApiPlugin.getDescription("version").split("\\.", 3);
            if (Integer.valueOf(spApiVer[0]) >= Integer.valueOf(aRecSprachApiVersion[0]) && Integer.valueOf(spApiVer[1]) >= Integer.valueOf(aRecSprachApiVersion[1])) {
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled SprachAPI Daten " + this.sprachApiPlugin.getDescription("version") + " ");
                }
                String[][] sysConfigArray = new String[][]{{"restartTime", "3"}, {"intervall", "15 10 5 1"}, {"dayly", "1:30"}, {"Debug", String.valueOf(this.debug)}};
                this.sysConfig = new GetConfigDaten("System", sysConfigArray, (Plugin)this, this.debug, this.conf);
                this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
                this.restartTime = Integer.parseInt(this.sysConfig.getValue("restartTime"));
                this.chatDTF = DateTimeFormatter.ofPattern("HH:mm:ss");
                if (this.sysConfig.getValue("dayly") != null) {
                    String[] sShutdownTime = this.sysConfig.getValue("dayly").split(":");
                    this.iShutdownTime = new int[sShutdownTime.length];
                    if (sShutdownTime.length > 0) {
                        for (int n = 0; n < sShutdownTime.length; ++n) {
                            this.iShutdownTime[n] = Integer.parseInt(sShutdownTime[n]);
                        }
                    }
                    this.stepp = 7.5f;
                    String pattern = "yyyy-MM-dd HH:mm:ss";
                    this.dtf = DateTimeFormatter.ofPattern(pattern);
                    LocalDate loacDate = LocalDate.now();
                    LocalTime localTime = LocalTime.of(this.iShutdownTime[0], this.iShutdownTime[1]);
                    this.daylyShutdownDate = LocalDateTime.of(loacDate, localTime);
                } else {
                    this.daylyShutdownDate = null;
                }
                if (this.sysConfig.getValue("intervall") != null) {
                    this.intList = this.sysConfig.getValue("intervall").split(" ");
                    this.intValu = new ArrayList();
                    for (int n = 0; n < this.intList.length; ++n) {
                        this.intValu.add(Integer.parseInt(this.intList[n]) * 60);
                    }
                }
                if (this.debug > 4) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] Enabled currentTimeMillis " + System.currentTimeMillis() + " ");
                }
                this.registerEventListener(this);
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Die Version von Plugin 'SprachAPI(" + this.sprachApiPlugin.getDescription("version") + ")' ist zu klein! Bitte Aktualisieren auf Version(" + this.recSprachApiVersion + ")!");
                this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
            }
        } else if (this.plugin.getPluginByName("SprachAPI") == null) {
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR] Das Plugin 'SprachAPI' ist nicht installiert! Bitte installieren!");
            this.registerEventListener(new ShutdownInfoTimerErrorSprachAPI(this));
        }
    }

    public void onDisable() {
        System.out.println("[" + this.plugin.getDescription("name") + "] Disabled");
    }

    @EventMethod
    public void onShutdown(ShutdownEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Shutdown ausf\u00fchren nach " + this.server.getRunningTime() + " ");
        }
        this.server.getAllPlayers().forEach(player -> {
            if (player != null) {
                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownnow"), this.restartTime);
                player.sendYellMessage(str);
                player.sendTextMessage(this.chatDTF.format(LocalTime.now()) + " - " + str);
            }
        });
    }

    @EventMethod
    public void onUpdate(UpdateEvent event) {
        if (this.lastUpdate + this.stepp <= this.server.getRunningTime()) {
            this.lastUpdate = this.server.getRunningTime();
            String output = this.dtf.format(LocalDateTime.now());
            if (this.daylyShutdownDate != null) {
                this.elapsed = Duration.between(LocalDateTime.now(), this.daylyShutdownDate);
                if ((float)this.elapsed.getSeconds() < this.stepp && !this.elapsed.isNegative()) {
                    if (this.debug > 2) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren " + this.chatDTF.format(LocalTime.now()));
                    }
                    this.server.getAllPlayers().forEach(player -> {
                        if (player != null) {
                            String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdown"), 0);
                            player.sendYellMessage(str);
                            player.sendTextMessage(this.chatDTF.format(LocalTime.now()) + " - " + str);
                        }
                    });
                }
                this.intValu.forEach(counter -> {
                    if ((float)this.elapsed.getSeconds() < (float)counter.intValue() + this.stepp && this.elapsed.getSeconds() >= (long)counter.intValue()) {
                        if (this.debug > 2) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Update Ausf\u00fchren[" + counter + "] " + this.chatDTF.format(LocalTime.now()));
                        }
                        CRT.classLambadHelper l = new CRT.classLambadHelper();
                        l.n = counter / 60;
                        this.server.getAllPlayers().forEach(player -> {
                            if (player != null) {
                                String str = String.format(this.sprachApiDaten.getText((Player)player, "shutdownin"), l.n);
                                player.sendYellMessage(str);
                                player.sendTextMessage(this.chatDTF.format(LocalTime.now()) + " - " + str);
                            }
                        });
                    }
                });
            }
            if (this.debug > 3) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Update " + this.server.getRunningTime() + " now[" + output + "]  in[" + (this.elapsed != null ? Long.valueOf(this.elapsed.getSeconds()) : "NULL") + "] ");
            }
        }
    }
}

