/*
 * Main.java
 *
 * User: Carsten
 * Date: 20.04.2018
 *
 *
 *
 */

package carsten.risingworld.playernpcinteractiontest;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.objects.Player;

public class Main extends Plugin implements Listener
{

  @Override
  public void onEnable()
  {
    registerEventListener(this);
  }

  @Override
  public void onDisable()
  {
    // no-op
  }

  @EventMethod(Threading.Async)
  public void onPlayerNpcInteractionEvent(final PlayerNpcInteractionEvent evt)
  {
    Player player = evt.getPlayer();

    player.sendTextMessage("PlayerNpcInteractionEvent - NPC: " + evt.getNpc().toString());

    evt.setCancelled(true);

    player.sendTextMessage("evt " + evt.toString() + " cancelled: " + evt.isCancelled());
  }
}
