/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.data;

import carsten.risingworld.abm.data.Animal;
import carsten.risingworld.abm.data.AnimalDataBase;
import carsten.risingworld.abm.data.AnimalMap;
import carsten.risingworld.abm.data.AnimalType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;

public class Rancher {
    private static int OBJID = 0;
    static final Rancher NULL = new Rancher(-1);
    private final int id = OBJID++;
    private int playerId;
    private String playerName;
    private int offspringCounter;
    private int rewardCounter;
    private List<Animal> animalList;
    private Map<Integer, List<Animal>> prolificList;
    private Animal followingTaggedAnimal;
    private Animal renameTaggedAnimal;

    Rancher(int playerId) {
        this(playerId, "", 0, 0);
    }

    Rancher(int p_playerId, String p_playerName, int p_offspringCounter, int p_rewardCounter) {
        this.playerId = p_playerId;
        this.playerName = p_playerName;
        this.offspringCounter = p_offspringCounter;
        this.rewardCounter = p_rewardCounter;
        this.animalList = new ArrayList<Animal>();
        this.prolificList = new HashMap<Integer, List<Animal>>();
        this.resetFollowingTaggedAnimal();
        this.resetRenameTaggedAnimal();
        this.followingTaggedAnimal = Animal.NULL;
        this.renameTaggedAnimal = Animal.NULL;
        this.loadAnimals();
    }

    int getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String p_playerName) {
        this.playerName = p_playerName;
    }

    int getOffspringCounter() {
        return this.offspringCounter;
    }

    public void setOffspringCounter(int p_offspringCounter) {
        this.offspringCounter = p_offspringCounter;
    }

    public void incOffspringCounter() {
        ++this.offspringCounter;
    }

    public int getRewardCounter() {
        return this.rewardCounter;
    }

    public void setRewardCounter(int p_rewardCounter) {
        this.rewardCounter = p_rewardCounter;
    }

    public void incRewardCounter() {
        ++this.rewardCounter;
    }

    public void resetRewardCounter() {
        this.rewardCounter = 0;
    }

    private void loadAnimals() {
        List<Animal> selection = AnimalDataBase.INSTANCE.selectAnimalByPlayer(this.playerId);
        for (Animal animal : selection) {
            AnimalMap.add(animal);
            this.addAnimal(AnimalMap.get(animal.getNpcId()));
        }
    }

    public void addAnimal(Animal animal) {
        if (!this.animalList.contains(animal)) {
            this.animalList.add(animal);
            this.addProlificAnimal(animal);
        }
    }

    public void removeAnimal(Animal animal) {
        if (animal == this.followingTaggedAnimal) {
            this.resetFollowingTaggedAnimal();
        }
        if (animal == this.renameTaggedAnimal) {
            this.resetRenameTaggedAnimal();
        }
        this.removeProlificAnimal(animal);
        this.animalList.remove(animal);
    }

    public List<Animal> getAnimals() {
        return new ArrayList<Animal>(this.animalList);
    }

    public Map<Integer, List<Animal>> getProlificAnimals() {
        return this.prolificList;
    }

    private List<Animal> getProlificAnimalsForType(int npcType) {
        return this.prolificList.computeIfAbsent(AnimalType.filterNpcType(npcType), p_integer -> new ArrayList());
    }

    public void addProlificAnimal(Animal animal) {
        List<Animal> list;
        if (animal.getNpc() == null) {
            return;
        }
        if (animal.isProlific() && !(list = this.getProlificAnimalsForType(animal.getNpc().getTypeID())).contains(animal)) {
            list.add(animal);
        }
    }

    public void removeProlificAnimal(Animal animal) {
        if (animal.getNpc() == null) {
            return;
        }
        this.getProlificAnimalsForType(animal.getNpc().getTypeID()).remove(animal);
    }

    public Animal getFollowingTaggedAnimal() {
        return this.followingTaggedAnimal;
    }

    public void setFollowingTaggedAnimal(Animal animal) {
        this.followingTaggedAnimal = animal;
    }

    public void resetFollowingTaggedAnimal() {
        this.followingTaggedAnimal = Animal.NULL;
    }

    public Animal getRenameTaggedAnimal() {
        return this.renameTaggedAnimal;
    }

    public void setRenameTaggedAnimal(Animal animal) {
        this.renameTaggedAnimal = animal;
    }

    public void resetRenameTaggedAnimal() {
        this.renameTaggedAnimal = Animal.NULL;
    }

    public String toString() {
        return "Rancher[id=" + this.id + ", playerId=" + this.getPlayerId() + ", name=" + this.getPlayerName() + ", offspring=" + this.getOffspringCounter() + ", reward=" + this.getRewardCounter() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rancher) {
            Rancher anotherAnimal = (Rancher)obj;
            return this.getPlayerId() == anotherAnimal.getPlayerId();
        }
        return false;
    }

    @PreDestroy
    void clear() {
        this.animalList.clear();
    }
}

