/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.Action;
import carsten.risingworld.abm.action.AnimalInteraction;
import carsten.risingworld.abm.action.FeedAction;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class InteractionItem {
    private static final String APPLE = "apple";
    private static final String BACONCOOKED = "baconcooked";
    private static final String BACONRAW = "baconraw";
    private static final String BEEFSTEAKRAW = "beefsteakraw";
    private static final String CARROT = "carrot";
    private static final String CHERRY = "cherry";
    private static final String CHILIPEPPER = "chilipepper";
    private static final String CORNCOB = "corncob";
    private static final String FLOWER1 = "flower1";
    private static final String FLOWER2 = "flower2";
    private static final String FLOWER3 = "flower3";
    private static final String FLOWER4 = "flower4";
    private static final String FLOWER5 = "flower5";
    private static final String FLOWER6 = "flower6";
    private static final String LEMON = "lemon";
    private static final String LUMBER = "lumber";
    private static final String PAPER = "paper";
    private static final String POTATO = "potato";
    private static final String PUMPKINSEED = "pumpkinseed";
    private static final String RIBSRAW = "ribsraw";
    private static final String ROLLINGPIN = "rollingpin";
    private static final String SAPLINGSPRUCE = "saplingspruce";
    private static final String STRAWBERRY = "strawberry";
    private static final String SUGARBEET = "sugarbeet";
    private static final String WATERMELON = "watermelon";
    private static final String WATERMELONSLICE = "watermelonslice";
    private static final String WATERMELONSEED = "watermelonseed";
    private static final Map<String, AnimalInteraction> itemToActionMapping = new LinkedHashMap<String, AnimalInteraction>();

    public static void activateRenameAction() {
        InteractionItem.registerItemAction(PAPER, Action.RENAME);
    }

    public static void deactivateRenameAction() {
        InteractionItem.unregisterItemAction(PAPER);
    }

    public static void activateRewardActions() {
        InteractionItem.registerItemAction("aluminiumingot", Action.REWARDPOINTS);
        InteractionItem.registerItemAction("goldingot", Action.REWARDPOINTS);
        InteractionItem.registerItemAction("mithrilingot", Action.REWARDPOINTS);
        InteractionItem.registerItemAction("silveringot", Action.REWARDPOINTS);
        InteractionItem.registerItemAction("lightbulb", Action.REWARDPOINTS);
    }

    public static void deactivateRewardActions() {
        InteractionItem.unregisterItemAction("aluminiumingot");
        InteractionItem.unregisterItemAction("goldingot");
        InteractionItem.unregisterItemAction("mithrilingot");
        InteractionItem.unregisterItemAction("silveringot");
        InteractionItem.unregisterItemAction("lightbulb");
    }

    private static void registerItemAction(String itemName, AnimalInteraction action) {
        itemToActionMapping.put(itemName, action);
    }

    private static void unregisterItemAction(String itemName) {
        itemToActionMapping.remove(itemName);
    }

    public static AnimalInteraction getAction(String itemName) {
        return itemToActionMapping.getOrDefault(itemName, Action.NOOP);
    }

    public static Set<String> getItems() {
        return itemToActionMapping.keySet();
    }

    static {
        InteractionItem.registerItemAction(CORNCOB, FeedAction.PIG);
        InteractionItem.registerItemAction(CARROT, FeedAction.COW);
        InteractionItem.registerItemAction(SAPLINGSPRUCE, FeedAction.GOAT);
        InteractionItem.registerItemAction(SUGARBEET, FeedAction.SHEEP);
        InteractionItem.registerItemAction(BACONRAW, FeedAction.FOX);
        InteractionItem.registerItemAction(CHERRY, FeedAction.BEAR);
        InteractionItem.registerItemAction(STRAWBERRY, FeedAction.RABBIT);
        InteractionItem.registerItemAction(WATERMELONSEED, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(PUMPKINSEED, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(CHILIPEPPER, FeedAction.CHICKEN);
        InteractionItem.registerItemAction(APPLE, FeedAction.ELEPHANT);
        InteractionItem.registerItemAction(BEEFSTEAKRAW, FeedAction.JAGUAR);
        InteractionItem.registerItemAction(RIBSRAW, FeedAction.TIGER);
        InteractionItem.registerItemAction(WATERMELONSLICE, FeedAction.MINIPIG);
        InteractionItem.registerItemAction(BACONCOOKED, FeedAction.RAT);
        InteractionItem.registerItemAction(POTATO, FeedAction.OTHER);
        InteractionItem.registerItemAction(LEMON, FeedAction.OTHER);
        InteractionItem.registerItemAction(ROLLINGPIN, Action.FOLLOW);
    }
}

