/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.abm.action;

import carsten.risingworld.abm.action.ActionDelegate;
import carsten.risingworld.abm.action.SimpleAnimalInteraction;
import carsten.risingworld.abm.data.Animal;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public enum Action implements SimpleAnimalInteraction
{
    FOLLOW(50.0f),
    RENAME(8.0f),
    REWARDPOINTS(50.0f),
    NOOP(0.0f);

    private final float maxDistance;
    private ActionDelegate delegate;

    private Action(float p_maxDistance) {
        this.maxDistance = p_maxDistance;
        this.delegate = (player, animal) -> {};
    }

    @Override
    public void setDelegate(ActionDelegate p_delegate) {
        this.delegate = p_delegate;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public void execute(Player player, Animal animal) {
        Npc npc = animal.getNpc();
        if (npc == null) {
            return;
        }
        if (!this.isInRange(player, npc)) {
            return;
        }
        this.delegate.action(player, animal);
    }

    @Override
    public String actionName() {
        return "action." + this.name();
    }
}

