/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.tape.measure;

import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldElement;

public class TapeMeasure
extends Plugin
implements Listener {
    public ArrayList<World3DText> texts;

    public void onEnable() {
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerComand(PlayerCommandEvent evt) {
        String command = evt.getCommand();
        String[] cmd = command.split(" ");
        if (cmd[0].equals("/measure")) {
            if (cmd.length == 2) {
                if (command.equals("/measure help")) {
                    evt.getPlayer().sendTextMessage("[#ff0000]HELP");
                    evt.getPlayer().sendTextMessage("/measure help");
                    evt.getPlayer().sendTextMessage("/measure setmark");
                    evt.getPlayer().sendTextMessage("/measure setmark [#0000ff](point)");
                    evt.getPlayer().sendTextMessage("/measure rmmark");
                    evt.getPlayer().sendTextMessage("/measure [#0000ff](point1)[#ffffff]:[#0000ff](point2)");
                    evt.getPlayer().sendTextMessage("a point can be: me/spawn/spawnprimary/spawnsecondary/origin/mark/#player/(x;y;z)");
                } else if (command.equals("/measure setmark")) {
                    World3DText txt2;
                    Vector3f np = new Vector3f(evt.getPlayer().getPosition());
                    try {
                        txt2 = (World3DText)evt.getPlayer().getAttribute("de.galveston01.tape.measure marktext");
                        evt.getPlayer().removeWorldElement((WorldElement)txt2);
                    }
                    catch (Exception txt2) {
                        // empty catch block
                    }
                    evt.getPlayer().setAttribute("de.galveston01.tape.measure mark", (Object)np);
                    txt2 = new World3DText("<- mark ->");
                    txt2.setPosition(np);
                    txt2.setAlwaysVisible(true);
                    evt.getPlayer().addWorldElement((WorldElement)txt2);
                    evt.getPlayer().setAttribute("de.galveston01.tape.measure marktext", (Object)txt2);
                    evt.getPlayer().sendTextMessage("[#00ff00]MARK SET!");
                } else if (command.equals("/measure rmmark")) {
                    try {
                        World3DText txt = (World3DText)evt.getPlayer().getAttribute("de.galveston01.tape.measure marktext");
                        evt.getPlayer().deleteAttribute("de.galveston01.tape.measure mark");
                        evt.getPlayer().removeWorldElement((WorldElement)txt);
                    }
                    catch (Exception txt) {
                        // empty catch block
                    }
                    evt.getPlayer().sendTextMessage("[#00ff00]MARK REMOVED!");
                } else {
                    String[] pos = cmd[1].split(":");
                    if (pos.length == 2) {
                        Vector3f p1 = this.decodePosition(pos[0], evt.getPlayer());
                        Vector3f p2 = this.decodePosition(pos[1], evt.getPlayer());
                        if (p1 != null && p2 != null) {
                            evt.getPlayer().sendTextMessage("[#00ff00]DISTANCE: " + Double.toString(Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0) + Math.pow(p1.z - p2.z, 2.0))));
                        } else {
                            evt.getPlayer().sendTextMessage("[#ff0000]FAILED TO DECODE START/END!");
                        }
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]WRONG POINT1:POINT2 SYNTAX!");
                    }
                }
            } else if (cmd.length == 3) {
                if (cmd[1].equals("setmark")) {
                    Vector3f np = this.decodePosition(cmd[2], evt.getPlayer());
                    if (np != null) {
                        World3DText txt3;
                        try {
                            txt3 = (World3DText)evt.getPlayer().getAttribute("de.galveston01.tape.measure marktext");
                            evt.getPlayer().removeWorldElement((WorldElement)txt3);
                        }
                        catch (Exception txt3) {
                            // empty catch block
                        }
                        evt.getPlayer().setAttribute("de.galveston01.tape.measure mark", (Object)np);
                        txt3 = new World3DText("<- mark ->");
                        txt3.setPosition(np);
                        txt3.setAlwaysVisible(true);
                        evt.getPlayer().addWorldElement((WorldElement)txt3);
                        evt.getPlayer().setAttribute("de.galveston01.tape.measure marktext", (Object)txt3);
                        evt.getPlayer().sendTextMessage("[#00ff00]MARK SET!");
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]WRONG POINT SYNTAX!");
                    }
                } else {
                    evt.getPlayer().sendTextMessage("[#ff0000]UNKNOWN /MEASURE COMMAND!");
                }
            } else {
                evt.getPlayer().sendTextMessage("[#ff0000]WRONG PARAMETER COUNT FOR /MEASURE COMMAND!");
            }
        }
    }

    public Vector3f decodePosition(String s, Player player) {
        if (s.equals("origin")) {
            return Vector3f.ZERO;
        }
        if (s.equals("me")) {
            return new Vector3f(player.getPosition());
        }
        if (s.equals("spawn")) {
            return this.getServer().getDefaultSpawnPosition();
        }
        if (s.equals("spawnprimary")) {
            Vector3f v = (Vector3f)player.getAttribute("SpawnPointPrimary");
            if (v == null) {
                player.sendTextMessage("[#ff0000]No primary spawn point set!");
            }
            return v;
        }
        if (s.equals("spawnsecondary")) {
            Vector3f v = (Vector3f)player.getAttribute("SpawnPointSecondary");
            if (v == null) {
                player.sendTextMessage("[#ff0000]No secondary spawn point set!");
            }
            return v;
        }
        if (s.equals("spawn")) {
            return this.getServer().getDefaultSpawnPosition();
        }
        if (s.equals("mark")) {
            if (player.getAttribute("de.galveston01.tape.measure mark") != null) {
                try {
                    return (Vector3f)player.getAttribute("de.galveston01.tape.measure mark");
                }
                catch (Exception e) {
                    player.sendTextMessage("[#ff0000]NO MARK SET!");
                    return null;
                }
            }
            player.sendTextMessage("[#ff0000]NO MARK SET!");
            return null;
        }
        if (s.startsWith("#")) {
            String sp = s.substring(1);
            Player p = this.getServer().getPlayer(sp);
            if (p == null) {
                player.sendTextMessage("[#ff0000]UNKNOWN PLAYER!");
                return null;
            }
            return new Vector3f(p.getPosition());
        }
        if (s.startsWith("(") && s.endsWith(")")) {
            String sp = s.substring(1, s.length() - 1);
            String[] ss = sp.split(";");
            if (ss.length == 3) {
                if (Utils.StringUtils.isNumeric((String)ss[0]) && Utils.StringUtils.isNumeric((String)ss[1]) && Utils.StringUtils.isNumeric((String)ss[2])) {
                    return new Vector3f(Float.parseFloat(ss[0]), Float.parseFloat(ss[1]), Float.parseFloat(ss[2]));
                }
                player.sendTextMessage("[#ff0000]X, Y AND Z HAVE TO BE NUMERIC!");
                return null;
            }
            player.sendTextMessage("[#ff0000]WRONG POINT SYNTAX!");
            return null;
        }
        return null;
    }
}

