/*
 * Decompiled with CFR 0.152.
 */
package de.galveston01.home.point;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class HomePoint
extends Plugin
implements Listener {
    public Map<Player, Vector3f> homePoints;

    public void onEnable() {
        this.homePoints = new HashMap<Player, Vector3f>();
        this.registerEventListener(this);
        try {
            this.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent evt) {
        if (!this.homePoints.containsKey(evt.getPlayer())) {
            this.homePoints.put(evt.getPlayer(), this.getServer().getDefaultSpawnPosition());
        }
    }

    @EventMethod
    public void onPlayerComand(PlayerCommandEvent evt) {
        String command = evt.getCommand();
        String[] cmd = command.split(" ");
        if (command.equals("/home")) {
            evt.getPlayer().setPosition(this.homePoints.get(evt.getPlayer()));
            evt.getPlayer().sendTextMessage("[#00ff00]WENT HOME!");
        } else if (cmd[0].equals("/home")) {
            if (cmd.length == 2) {
                if (command.equals("/home help")) {
                    evt.getPlayer().sendTextMessage("[#ff0000]HELP");
                    evt.getPlayer().sendTextMessage("/home help");
                    evt.getPlayer().sendTextMessage("/home");
                    evt.getPlayer().sendTextMessage("/home set");
                    evt.getPlayer().sendTextMessage("/home set [#0000ff]x y z");
                    evt.getPlayer().sendTextMessage("[#ff0000]ADMIN ONLY   [#ffffff]/home [#0000ff]player");
                    evt.getPlayer().sendTextMessage("[#ff0000]ADMIN ONLY   [#ffffff]/home set [#0000ff]player");
                    evt.getPlayer().sendTextMessage("[#ff0000]ADMIN ONLY   [#ffffff]/home set [#0000ff]player x y z");
                } else if (command.equals("/home set")) {
                    Vector3f v = new Vector3f(evt.getPlayer().getPosition());
                    this.homePoints.put(evt.getPlayer(), v);
                    evt.getPlayer().sendTextMessage("[#00ff00]UPDATED HOME TO (" + v.x + ";" + v.y + ";" + v.z + ")");
                    try {
                        this.write();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    if (!evt.getPlayer().isAdmin()) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! ONLY ADMINS ARE ALLOWED TO DO THIS!");
                        return;
                    }
                    Player p = this.getServer().getPlayer(cmd[1]);
                    if (p == null) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! UNKNOWN PLAYER '" + cmd[1] + "'!");
                        return;
                    }
                    evt.getPlayer().setPosition(this.homePoints.get(p));
                    evt.getPlayer().sendTextMessage("[#00ff00]WENT TO HOME OF PLAYER '" + cmd[1] + "'!");
                }
            } else if (cmd.length == 3) {
                if (cmd[1].equals("set")) {
                    if (!evt.getPlayer().isAdmin()) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! ONLY ADMINS ARE ALLOWED TO DO THIS!");
                        return;
                    }
                    Player p = this.getServer().getPlayer(cmd[2]);
                    if (p == null) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! UNKNOWN PLAYER '" + cmd[1] + "'!");
                        return;
                    }
                    Vector3f v = new Vector3f(p.getPosition());
                    this.homePoints.put(p, v);
                    evt.getPlayer().sendTextMessage("[#00ff00]UPDATED HOME OF PLAYER '" + cmd[2] + "' TO (" + v.x + ";" + v.y + ";" + v.z + ")");
                    if (this.getServer().isPlayerConnected(p.getName())) {
                        p.sendTextMessage("[#00ff00]UPDATED HOME TO (" + v.x + ";" + v.y + ";" + v.z + ") BY ADMIN '" + evt.getPlayer().getName() + "'");
                    }
                    try {
                        this.write();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    evt.getPlayer().sendTextMessage("[#ff0000]UNKNOWN HOME COMMAND!");
                }
            } else if (cmd.length == 5) {
                if (cmd[1].equals("set")) {
                    if (Utils.StringUtils.isNumeric((String)cmd[2]) && Utils.StringUtils.isNumeric((String)cmd[3]) && Utils.StringUtils.isNumeric((String)cmd[4])) {
                        Vector3f v = new Vector3f(Float.parseFloat(cmd[2]), Float.parseFloat(cmd[3]), Float.parseFloat(cmd[4]));
                        this.homePoints.put(evt.getPlayer(), v);
                        evt.getPlayer().sendTextMessage("[#00ff00]UPDATED HOME TO (" + v.x + ";" + v.y + ";" + v.z + ")");
                        try {
                            this.write();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]X; Y AND Z HAVE TO BE NUMERIC!");
                    }
                } else {
                    evt.getPlayer().sendTextMessage("[#ff0000]UNKNOWN HOME COMMAND!");
                }
            } else if (cmd.length == 6) {
                if (cmd[1].equals("set")) {
                    if (!evt.getPlayer().isAdmin()) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! ONLY ADMINS ARE ALLOWED TO DO THIS!");
                        return;
                    }
                    Player p = this.getServer().getPlayer(cmd[2]);
                    if (p == null) {
                        evt.getPlayer().sendTextMessage("[#ff0000]ERROR! UNKNOWN PLAYER '" + cmd[1] + "'!");
                        return;
                    }
                    if (Utils.StringUtils.isNumeric((String)cmd[3]) && Utils.StringUtils.isNumeric((String)cmd[4]) && Utils.StringUtils.isNumeric((String)cmd[5])) {
                        Vector3f v = new Vector3f(Float.parseFloat(cmd[3]), Float.parseFloat(cmd[4]), Float.parseFloat(cmd[5]));
                        this.homePoints.put(p, v);
                        evt.getPlayer().sendTextMessage("[#00ff00]UPDATED HOME OF PLAYER '" + cmd[2] + "' TO (" + v.x + ";" + v.y + ";" + v.z + ")");
                        if (this.getServer().isPlayerConnected(p.getName())) {
                            p.sendTextMessage("[#00ff00]UPDATED HOME TO (" + v.x + ";" + v.y + ";" + v.z + ") BY ADMIN '" + evt.getPlayer().getName() + "'");
                        }
                        try {
                            this.write();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        evt.getPlayer().sendTextMessage("[#ff0000]X; Y AND Z HAVE TO BE NUMERIC!");
                    }
                } else {
                    evt.getPlayer().sendTextMessage("[#ff0000]UNKNOWN HOME COMMAND!");
                }
            } else {
                evt.getPlayer().sendTextMessage("[#ff0000]WRONG PARAMETERS COUNT FOR TEXT3D COMMAND!");
            }
        }
    }

    public void write() throws IOException {
        File f = new File(this.getPath() + "/" + this.getWorld().getName() + ".list");
        if (!f.exists()) {
            f.createNewFile();
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        for (Player p : this.homePoints.keySet()) {
            bw.write(p.getUID() + "\n");
            bw.write(this.homePoints.get((Object)p).x + ";" + this.homePoints.get((Object)p).y + ";" + this.homePoints.get((Object)p).z + "\n");
        }
        bw.close();
    }

    public void read() throws IOException {
        File f = new File(this.getPath() + "/" + this.getWorld().getName() + ".list");
        if (f.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String uid = "";
            while ((uid = br.readLine()) != null) {
                Player p;
                String vec = br.readLine();
                String[] vs = vec.split(";");
                if (vs.length != 3 || !Utils.StringUtils.isNumeric((String)vs[0]) || !Utils.StringUtils.isNumeric((String)vs[1]) || !Utils.StringUtils.isNumeric((String)vs[2]) || (p = this.getServer().getPlayer(Long.parseLong(uid))) == null) continue;
                this.homePoints.put(p, new Vector3f(new Vector3f(Float.parseFloat(vs[0]), Float.parseFloat(vs[1]), Float.parseFloat(vs[2]))));
            }
            br.close();
        }
    }
}

