/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGard;
import de.pbplugins.tools.classDimension;
import de.pbplugins.tools.classIDs;
import de.pbplugins.tools.classWorldArea;
import de.pbplugins.tools.wgCRT;
import de.pbplugins.tools.wgConfig;
import de.pbplugins.wgClassText;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import net.risingworld.api.Server;
import net.risingworld.api.database.Database;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.World3DText;
import net.risingworld.api.worldelements.WorldArea;
import net.risingworld.api.worldelements.WorldElement;

public class wgArea {
    private final WorldGard plugin;
    private Database sqlite;
    private wgClassText textDaten;
    private wgConfig sysConfig;
    private int debug = 1;
    private Server server;
    ArrayList<classIDs> IDs = null;
    String playerIsAreaCreate;
    String playerIsAreaName;
    String playerIsAreaEigenschaft;
    String playerGuiLabelAreaCreateEnter;
    String playerGuiAreaDaten;
    String playerCreateAreaDaten;

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    ArrayList<classIDs> getIDs() {
        return this.IDs;
    }

    public wgArea(WorldGard plugin) {
        this.plugin = plugin;
        this.server = plugin.getServer();
        this.playerIsAreaCreate = plugin.getDescription("name") + "_isAreaCreate";
        this.playerIsAreaName = plugin.getDescription("name") + "_isAreaName";
        this.playerIsAreaEigenschaft = plugin.getDescription("name") + "_isAreaEigenschaft";
        this.playerGuiLabelAreaCreateEnter = plugin.getDescription("name") + "_guiAreaCreateEnter";
        this.playerGuiAreaDaten = plugin.getDescription("name") + "_guiAreaDaten";
        this.playerCreateAreaDaten = plugin.getDescription("name") + "_playerCreateAreaDaten";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEnable() {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Lade Area");
        }
        this.sqlite = this.plugin.getSqlite();
        this.textDaten = this.plugin.getTextDaten();
        this.sysConfig = this.plugin.getSysConfig();
        this.server = this.plugin.getServer();
        this.IDs = new ArrayList();
        try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas'");){
            if (result != null) {
                while (result.next()) {
                    int id = result.getInt("AreaID");
                    int srvID = result.getInt("srvID");
                    String name = result.getString("AreaName");
                    String owner = result.getString("Eigent\u00fcmer");
                    long ownerID = result.getLong("Eigent\u00fcmerID");
                    float GlobalStartposX = result.getFloat("GlobalStartposX");
                    float GlobalStartposY = result.getFloat("GlobalStartposY");
                    float GlobalStartposZ = result.getFloat("GlobalStartposZ");
                    float GlobalEndposX = result.getFloat("GlobalEndposX");
                    float GlobalEndposY = result.getFloat("GlobalEndposY");
                    float GlobalEndposZ = result.getFloat("GlobalEndposZ");
                    Vector3f Start = new Vector3f(GlobalStartposX, GlobalStartposY, GlobalStartposZ);
                    Vector3f End = new Vector3f(GlobalEndposX, GlobalEndposY, GlobalEndposZ);
                    Area area = new Area(Start, End);
                    this.server.addArea(area);
                    classIDs inp = new classIDs();
                    inp.srvID = area.getID();
                    inp.dbID = id;
                    inp.Name = name;
                    inp.Owner = owner;
                    inp.OwnerID = ownerID;
                    if (srvID != 0) {
                        this.IDs.add(inp);
                    }
                    if (this.debug <= 2) continue;
                    System.out.println("[" + this.plugin.getDescription("name") + "] Finde AreaID[" + id + "] SET srvID[" + area.getID() + "] ID.size[" + this.IDs.size() + "]");
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
        }
        finally {
            Connection con = this.sqlite.getConnection();
            this.IDs.forEach(vID -> {
                try {
                    PreparedStatement prep = con.prepareStatement("UPDATE 'Areas' SET srvID = " + vID.srvID + " WHERE AreaID = " + vID.dbID);
                    prep.executeUpdate();
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
            });
        }
    }

    public void onPlayerConnect(Player player) {
        ArrayList worldArea = new ArrayList();
        player.setAttribute(this.playerGuiAreaDaten, worldArea);
        this.server.getAllAreas().stream().map(area -> {
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerConnect srvAreaID[" + area.getID() + "]");
            }
            return area;
        }).forEachOrdered(area -> this.IDs.stream().filter(iArea -> area.getID() == iArea.srvID).map(iArea -> {
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerConnect     srvID[" + iArea.srvID + "] dbID[" + iArea.dbID + "] Name[" + iArea.Name + "]");
            }
            return iArea;
        }).forEachOrdered(iArea -> this.createWorldArea(player, (Area)area, (classIDs)iArea)));
        this.showAllAreas(player, (ArrayList)player.getAttribute(this.playerGuiAreaDaten));
    }

    private void createWorldArea(Player player, Area area, classIDs iArea) {
        WorldArea wArea = new WorldArea(area);
        wArea.setAlwaysVisible(false);
        wArea.setFrameVisible(true);
        wArea.setVisibleRange(3.0f);
        wArea.setColor(0xFF0022);
        World3DText wText = new World3DText(iArea.Name + "\nID[" + iArea.srvID + "]");
        wText.setAlwaysVisible(true);
        wText.setFontsize(20);
        wText.setFont(Font.Default);
        wText.setFontColor(0xFF55FF);
        wText.setBackgroundColor(0);
        Vector3f posStart = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getStartChunkPosition(), (Vector3i)area.getStartBlockPosition());
        Vector3f posEnd = Utils.ChunkUtils.getGlobalPosition((Vector3i)area.getEndChunkPosition(), (Vector3i)area.getEndBlockPosition());
        Vector3f tPos = wArea.getPosition();
        tPos.set(tPos.x + (posEnd.x - posStart.x) / 2.0f, tPos.y + (posEnd.y - posStart.y) / 2.0f, tPos.z + (posEnd.z - posStart.z) / 2.0f);
        wText.setPosition(tPos);
        wText.setBillboard(true);
        wText.setVisibleRange(3.0f);
        classWorldArea inp = new classWorldArea();
        inp.srvID = iArea.srvID;
        inp.Name = iArea.Name;
        inp.Area = wArea;
        inp.Text3D = wText;
        inp.Owner = iArea.Owner;
        inp.OwnerID = (int)player.getUID();
        this.server.getAllPlayers().forEach(allPlayer -> ((ArrayList)allPlayer.getAttribute(this.playerGuiAreaDaten)).add(inp));
        ((ArrayList)player.getAttribute(this.playerGuiAreaDaten)).forEach(worldArea -> {
            if (worldArea.srvID == iArea.srvID) {
                worldArea.Text3D.setText(iArea.Name + "\nID[" + iArea.srvID + "];");
            }
        });
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] createWorldArea srvID[" + iArea.srvID + "] dbID[" + iArea.dbID + "] Name[" + iArea.Name + "] TextID[" + wText.getID() + "] ");
        }
    }

    classWorldArea getAreaBy(Player player, int srvID) {
        for (classWorldArea worldArea : (ArrayList)player.getAttribute(this.playerGuiAreaDaten)) {
            if (worldArea.srvID != srvID) continue;
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaByID   srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "] wArea[" + worldArea.Area.toString() + "] wText[" + worldArea.Text3D.getID() + "]");
            }
            return worldArea;
        }
        return null;
    }

    classWorldArea getAreaBy(Player player, String Name) {
        return this.getAreaBy(player, Name, false);
    }

    classWorldArea getAreaBy(Player player, String Name, boolean LowerCaseTest) {
        for (classWorldArea worldArea : (ArrayList)player.getAttribute(this.playerGuiAreaDaten)) {
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaByName srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "]");
            }
            if ((!worldArea.Name.equals(Name) || LowerCaseTest) && (!worldArea.Name.toLowerCase().equals(Name.toLowerCase()) || !LowerCaseTest)) continue;
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaByName srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "] wArea[" + worldArea.Area.toString() + "] wText[" + worldArea.Text3D.getID() + "]");
            }
            return worldArea;
        }
        return null;
    }

    classWorldArea getAreaBy(Player player, classDimension area) {
        for (classWorldArea worldArea : (ArrayList)player.getAttribute(this.playerGuiAreaDaten)) {
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaByDIM  srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "]");
            }
            if (worldArea.srvID != area.srvID) continue;
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getAreaByDIM  srvID[" + worldArea.srvID + "] Name[" + worldArea.Name + "] wArea[" + worldArea.Area.toString() + "] wText[" + worldArea.Text3D.getID() + "]");
            }
            return worldArea;
        }
        return null;
    }

    void areaReview(Player player) {
    }

    public void showAllAreas(Player player, ArrayList<classWorldArea> worldArea) {
        this.showAllAreas(player, worldArea, true);
    }

    public void showAllAreas(Player player, ArrayList<classWorldArea> worldArea, boolean pr\u00fcfen) {
        worldArea.forEach(area -> this.showArea(player, (classWorldArea)area, pr\u00fcfen));
    }

    public void showArea(Player player, classWorldArea area) {
        this.showArea(player, area, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void showArea(Player player, classWorldArea area, boolean pr\u00fcfen) {
        if (area != null) {
            if (pr\u00fcfen) {
                try (ResultSet result2 = this.sqlite.executeQuery("SELECT * FROM 'VisibleArea' WHERE vAreaID = " + area.srvID + " and PlayerID = " + player.getUID() + " ");){
                    if (result2 == null) return;
                    int ID = result2.getInt("VisibleID");
                    player.addWorldElement((WorldElement)area.Area);
                    player.sendTextMessage(String.format(this.textDaten.getText(player, "areaShowMsg"), area.Name, area.srvID));
                    return;
                }
                catch (SQLException result2) {}
                return;
            } else {
                player.addWorldElement((WorldElement)area.Area);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaShowMsg")), area.Name, area.srvID));
                Connection connection = this.sqlite.getConnection();
                try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'VisibleArea' ('vAreaID', 'Player', 'PlayerID') VALUES (?, ?, ?)");){
                    prep.setInt(1, area.srvID);
                    prep.setString(2, player.getName());
                    prep.setLong(3, player.getUID());
                    prep.executeUpdate();
                    return;
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
                return;
            }
        } else {
            player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "command_show_world")), ""));
        }
    }

    public void hideAllAreas(Player player, ArrayList<classWorldArea> worldArea) {
        worldArea.forEach(area -> this.hideArea(player, (classWorldArea)area));
    }

    public void hideArea(Player player, classWorldArea area) {
        this.hideArea(player, area, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideArea(Player player, classWorldArea area, boolean l\u00f6schen) {
        if (area != null) {
            if (l\u00f6schen) {
                Connection connection = this.sqlite.getConnection();
                try {
                    PreparedStatement prep = connection.prepareStatement("DELETE FROM 'VisibleArea' WHERE vAreaID = " + area.srvID + " and PlayerID = '" + player.getUID() + "' ");
                    prep.executeUpdate();
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
            }
            player.removeWorldElement((WorldElement)area.Area);
            player.sendTextMessage(String.format(this.textDaten.getText(player, "areaHideMsg"), area.Name, area.srvID));
        } else {
            player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "command_hide_world")), ""));
        }
    }

    public void removeAllAreas(Player player, ArrayList<classWorldArea> worldArea) {
        worldArea.forEach(area -> this.removeArea(player, (classWorldArea)area));
    }

    public void removeArea(Player player, classWorldArea area) {
        Connection connection = this.sqlite.getConnection();
        int aID = -1;
        int rID = -1;
        int mID = -1;
        int rIDs = 0;
        for (classIDs id : this.IDs) {
            if (id.srvID == area.srvID) {
                aID = id.dbID;
                break;
            }
            ++rIDs;
        }
        if (aID > 0) {
            PreparedStatement prep;
            try {
                prep = connection.prepareStatement("DELETE FROM 'Areas' WHERE srvID = " + area.srvID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Areas" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'VisibleArea' WHERE vAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del VisibleAreas" + e.getMessage());
            }
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Rechte' WHERE rAreaID = " + aID + " ");){
                if (result != null) {
                    rID = result.getInt("RechteID");
                    mID = result.getInt("rMsgID");
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Get Rechte Info" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'Rechte' WHERE rAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del Rechte" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MSG' WHERE msgID = " + mID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MSG" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'GroupList' WHERE gRechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del GroupList" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'MitgliedList' WHERE mAreaID = " + aID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del MitgliedListe" + e.getMessage());
            }
            try {
                prep = connection.prepareStatement("DELETE FROM 'PlayerList' WHERE pRechteID = " + rID + " ");
                prep.executeUpdate();
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] Del PlayerListe" + e.getMessage());
            }
            if (area.srvID > 0) {
                this.server.getAllPlayers().forEach(sPlayer -> this.hideArea((Player)sPlayer, area, true));
                this.IDs.remove(rIDs);
            }
        } else {
            player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "command_remove_world")), ""));
        }
    }

    public void getArea(Player player, String areaName, String Eigenschaft, Boolean DefineOwner) {
        player.setAttribute(this.playerIsAreaCreate, (Object)true);
        player.setAttribute(this.playerCreateAreaDaten, this.getAreasFromPos(player.getPosition()));
        player.setAttribute(this.playerIsAreaName, (Object)areaName);
        player.setAttribute(this.playerIsAreaEigenschaft, (Object)Eigenschaft);
        player.registerKeys(new int[]{wgCRT.getKeyInputValue(this.sysConfig.getValue("KEY_AreaSelect")), wgCRT.getKeyInputValue(this.sysConfig.getValue("KEY_AreaCancle"))});
        player.enableAreaSelectionTool();
        ((GuiElement)player.getAttribute(this.playerGuiLabelAreaCreateEnter)).setVisible(true);
    }

    public void getAreaSelect(Player player) {
        this.getAreaSelect(player, true);
    }

    public void getAreaSelect(Player player, boolean show) {
        player.getAreaSelectionData(NFA -> {
            if (NFA == null) {
                player.sendTextMessage(this.textDaten.getText(player, "GuiLabelAreaCreateEnter"));
                this.getAreaSelectCancle(player);
            } else {
                NFA.rearrange();
                Vector3f GlobalStartPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)NFA.getStartChunkPosition(), (Vector3i)NFA.getStartBlockPosition());
                Vector3f GlobalEndPos = Utils.ChunkUtils.getGlobalPosition((Vector3i)NFA.getEndChunkPosition(), (Vector3i)NFA.getEndBlockPosition());
                float GlobalStartPosX = GlobalStartPos.x;
                float GlobalStartPosY = GlobalStartPos.y;
                float GlobalStartPosZ = GlobalStartPos.z;
                float GlobalEndPosX = GlobalEndPos.x;
                float GlobalEndPosY = GlobalEndPos.y;
                float GlobalEndPosZ = GlobalEndPos.z;
                int areaID = 0;
                Connection connection = this.sqlite.getConnection();
                try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'Areas' ('AreaName', 'Eigent\u00fcmer', 'srvID', 'Prio', 'GlobalStartposX', 'GlobalStartposY', 'GlobalStartposZ', 'GlobalEndposX', 'GlobalEndposY', 'GlobalEndposZ', 'Eigenschaft', 'Mitglieder', 'Eigent\u00fcmerID', 'Buyable', 'Price') VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                    prep.setString(1, (String)player.getAttribute(this.playerIsAreaName));
                    prep.setString(2, player.getName());
                    prep.setInt(3, NFA.getID());
                    prep.setInt(4, 10);
                    prep.setFloat(5, GlobalStartPosX);
                    prep.setFloat(6, GlobalStartPosY);
                    prep.setFloat(7, GlobalStartPosZ);
                    prep.setFloat(8, GlobalEndPosX);
                    prep.setFloat(9, GlobalEndPosY);
                    prep.setFloat(10, GlobalEndPosZ);
                    prep.setString(11, (String)player.getAttribute(this.playerIsAreaEigenschaft));
                    prep.setString(12, "Mitglieder");
                    prep.setLong(13, player.getUID());
                    prep.setInt(14, 0);
                    prep.setInt(15, 0);
                    prep.executeUpdate();
                    ResultSet result = prep.getGeneratedKeys();
                    if (result != null) {
                        areaID = result.getInt(1);
                    }
                    this.server.addArea(NFA);
                    player.sendTextMessage(String.format(this.textDaten.getText(player, "GuiLabelAreaCreate"), (String)player.getAttribute(this.playerIsAreaName), areaID));
                    classIDs inp = new classIDs();
                    inp.srvID = NFA.getID();
                    inp.dbID = areaID;
                    inp.Name = (String)player.getAttribute(this.playerIsAreaName);
                    inp.Owner = player.getName();
                    inp.OwnerID = (int)player.getUID();
                    inp.OwnerID = 0L;
                    this.IDs.add(inp);
                    this.server.getAllPlayers().forEach(sPlayer -> this.createWorldArea((Player)sPlayer, (Area)NFA, this.IDs.get(this.IDs.size() - 1)));
                    if (this.debug > 0) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] Test IDs " + areaID + " " + NFA.getID() + " " + (String)player.getAttribute(this.playerIsAreaName) + "\n\t" + this.IDs.toString());
                    }
                    if (show) {
                        this.showArea(player, this.getAreaBy(player, NFA.getID()));
                    }
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
                finally {
                    this.getAreaSelectCancle(player);
                    if (this.makeDB(player, areaID)) {
                        this.showArea(player, this.getAreaBy(player, areaID), false);
                    }
                }
            }
        });
    }

    public void getAreaSelectCancle(Player player) {
        player.setAttribute(this.playerIsAreaCreate, (Object)false);
        player.setAttribute(this.playerCreateAreaDaten, null);
        player.setAttribute(this.playerIsAreaName, (Object)"");
        player.setAttribute(this.playerIsAreaEigenschaft, (Object)"");
        player.disableAreaSelectionTool();
        player.unregisterKeys(new int[]{28});
        ((GuiElement)player.getAttribute(this.playerGuiLabelAreaCreateEnter)).setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDBWert(int srvID, String sqlQueryTabelle) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] getDBWert SELECT " + sqlQueryTabelle + " FROM Areas, Rechte, MSG WHERE srvID = " + srvID + " and Rechte.rAreaID=Areas.AreaID and Rechte.rMsgID=MSG.msgID");
        }
        try {
            try (ResultSet result = this.sqlite.executeQuery("SELECT " + sqlQueryTabelle + " FROM Areas, Rechte, MSG WHERE srvID = " + srvID + " and Rechte.rAreaID=Areas.AreaID and Rechte.rMsgID=MSG.msgID");){
                if (result == null) return res;
                ResultSetMetaData rsmd = result.getMetaData();
                int columnCount = rsmd.getColumnCount();
                int i = 1;
                while (i <= columnCount) {
                    String s = rsmd.getColumnTypeName(i);
                    if (s.equals("VARCHAR")) {
                        res.add(result.getString(i));
                    } else if (s.equals("INTEGER")) {
                        res.add(result.getInt(i));
                    } else if (s.equals("BIGINT")) {
                        res.add(result.getLong(i));
                    }
                    ++i;
                }
                return res;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] getDBWert[srClose]: " + e.getMessage());
                if (!e.getMessage().equals("ResultSet closed")) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] getDBWert: " + e.getMessage());
                }
                res = null;
                return res;
            }
        }
        finally {
            return res;
        }
    }

    public Boolean setDBWert(int srvID, Object[][] sqlQueryTabelle) {
        Boolean[] bol = this.setDBWertArray(srvID, sqlQueryTabelle);
        return bol[0] != false && bol[1] != false && bol[2] != false;
    }

    public Boolean[] setDBWertArray(int srvID, Object[][] sqlQueryTabelle) {
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Liste " + sqlQueryTabelle.length);
        }
        String sqlQuery = "";
        String sqlMsgQuery = "";
        String sqlAreaQuery = "";
        int n = 0;
        int m = 0;
        int a = 0;
        boolean returnValue = false;
        boolean returnArea = false;
        boolean returnMsg = false;
        for (Object[] value : sqlQueryTabelle) {
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Value " + value.length + " " + n);
            }
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Name[" + value[0] + "] Value[" + value[1] + "]");
            }
            if (value[0].equals("AreaWelcomMsg") || value[0].equals("AreaFarewellMsg") || value[0].equals("NoEnterAreaMsg") || value[0].equals("NoLeaveAreaMsg")) {
                if (m > 0) {
                    sqlMsgQuery = sqlMsgQuery + ",";
                }
                sqlMsgQuery = value[1].getClass().equals(String.class) ? sqlMsgQuery + value[0] + "='" + value[1] + "'" : sqlMsgQuery + value[0] + "=" + value[1];
                ++m;
                continue;
            }
            if (value[0].equals("AreaName") || value[0].equals("Eigent\u00fcmer") || value[0].equals("Eigent\u00fcmerID") || value[0].equals("Eigenschaft") || value[0].equals("Mitglieder") || value[0].equals("previousID") || value[0].equals("Prio") || value[0].equals("Buyable") || value[0].equals("Price") || value[0].equals("StartBlockposX") || value[0].equals("StartBlockposY") || value[0].equals("StartBlockposZ") || value[0].equals("EndBlockposX") || value[0].equals("EndBlockposY") || value[0].equals("EndBlockposZ") || value[0].equals("StartChunkposX") || value[0].equals("StartChunkposY") || value[0].equals("StartChunkposZ") || value[0].equals("EndChunkposX") || value[0].equals("EndChunkposY") || value[0].equals("EndChunkposZ")) {
                if (a > 0) {
                    sqlAreaQuery = sqlAreaQuery + ",";
                }
                sqlAreaQuery = value[1].getClass().equals(String.class) ? sqlAreaQuery + value[0] + "='" + value[1] + "'" : sqlAreaQuery + value[0] + "=" + value[1];
                ++a;
                continue;
            }
            if (n > 0) {
                sqlQuery = sqlQuery + ",";
            }
            sqlQuery = value[1].getClass().equals(String.class) ? sqlQuery + value[0] + "='" + value[1] + "'" : sqlQuery + value[0] + "=" + value[1];
            ++n;
        }
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert sqlQuery:" + sqlQuery);
        }
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert sqlAreaQuery:" + sqlAreaQuery);
        }
        if (this.debug > 2) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert sqlMsgQuery:" + sqlMsgQuery);
        }
        Connection connection = this.sqlite.getConnection();
        if (!sqlAreaQuery.equals("") && srvID > 0) {
            try (PreparedStatement prep = connection.prepareStatement("UPDATE Areas SET " + sqlAreaQuery + " WHERE srvID = " + srvID + " ");){
                prep.executeUpdate();
                returnArea = true;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] setDBWert: " + e.getMessage());
            }
        } else {
            returnArea = true;
        }
        if (!sqlMsgQuery.equals("")) {
            try (PreparedStatement prep = connection.prepareStatement("UPDATE MSG SET " + sqlMsgQuery + " WHERE exists ( select * FROM Rechte,Areas where Areas.srvID = " + srvID + " and Areas.AreaID = Rechte.rAreaID and Rechte.rMsgID = MSG.msgID ) ");){
                prep.executeUpdate();
                returnMsg = true;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] setDBWert: " + e.getMessage());
            }
        } else {
            returnMsg = true;
        }
        if (!sqlQuery.equals("")) {
            try (PreparedStatement prep = connection.prepareStatement("UPDATE Rechte SET " + sqlQuery + " WHERE exists ( select * FROM Areas where Areas.srvID = " + srvID + " and Areas.AreaID = Rechte.rAreaID ) ");){
                prep.executeUpdate();
                returnValue = true;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] setDBWert: " + e.getMessage());
            }
        }
        returnValue = true;
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] setDBWert Rechte[" + returnValue + "] Area[" + returnArea + "] Msg[" + returnMsg + "] ");
        }
        return new Boolean[]{returnValue, returnArea, returnMsg};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<classDimension> getAreasFromPos(Vector3f pos) {
        ArrayList<classDimension> dimList = new ArrayList<classDimension>();
        try {
            try (ResultSet result = this.sqlite.executeQuery("SELECT * FROM 'Areas' WHERE (GlobalStartposX <= " + (pos.getX() + 1.0f) + " and GlobalEndposX >= " + (pos.getX() + 0.0f) + ") and (GlobalStartposY <= " + (pos.getY() + 0.0f) + " and GlobalEndposY >= " + (pos.getY() + 0.0f) + ") and (GlobalStartposZ <= " + (pos.getZ() + 0.0f) + " and GlobalEndposZ >= " + (pos.getZ() - 1.0f) + ") ");){
                if (result == null) return dimList;
                float pX = pos.getX();
                float pY = pos.getY();
                float pZ = pos.getZ();
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos Finde Area @[" + pX + "-" + pY + "-" + pZ + "] ");
                }
                while (true) {
                    Iterator<classDimension> iterator;
                    int nPos;
                    int n;
                    classDimension dim;
                    block33: {
                        if (result.next()) {
                            if (result == null) continue;
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    " + result.getString("AreaName") + " " + result.getInt("srvID"));
                            }
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    Start    @[" + result.getFloat("GlobalStartposX") + "|" + result.getFloat("GlobalStartposY") + "|" + result.getFloat("GlobalStartposZ") + "] ");
                            }
                            if (this.debug > 2) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    End      @[" + result.getFloat("GlobalEndposX") + "|" + result.getFloat("GlobalEndposY") + "|" + result.getFloat("GlobalEndposZ") + "] ");
                            }
                            double dX = result.getFloat("GlobalEndposX") - result.getFloat("GlobalStartposX");
                            double dY = result.getFloat("GlobalEndposY") - result.getFloat("GlobalStartposY");
                            double dZ = result.getFloat("GlobalEndposZ") - result.getFloat("GlobalStartposZ");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos    Dimension [" + dX + "|" + dY + "|" + dZ + "] ");
                            }
                            dim = new classDimension();
                            dim.Name = result.getString("AreaName");
                            dim.srvID = result.getInt("srvID");
                            dim.dbID = result.getInt("AreaID");
                            dim.x = dX;
                            dim.y = dY;
                            dim.z = dZ;
                            if (dimList.size() > 0) {
                                n = 0;
                                nPos = -1;
                                iterator = dimList.iterator();
                                break block33;
                            } else {
                                dimList.add(dim);
                                continue;
                            }
                        }
                        if (this.debug > 1) {
                            for (classDimension dimm : dimList) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos Liste[" + dimm.Name + "|" + dimm.srvID + "] ");
                            }
                        }
                        if (this.debug <= 3) return dimList;
                        System.out.println("[" + this.plugin.getDescription("name") + "] <NL>");
                        return dimList;
                    }
                    while (iterator.hasNext()) {
                        classDimension dimm = iterator.next();
                        if (dim.x < dimm.x || dim.y < dimm.y || dim.z < dimm.z) {
                            if (this.debug > 3) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos       Dimension[" + dimm.Name + "|" + dimm.srvID + "] kleiner " + n);
                            }
                            nPos = n;
                            continue;
                        }
                        if (this.debug > 3) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos       Dimension[" + dimm.Name + "|" + dimm.srvID + "] gr\u00f6\u00dfer " + n);
                        }
                        ++n;
                    }
                    if (nPos >= 0) {
                        dimList.add(nPos, dim);
                        continue;
                    }
                    dimList.add(dim);
                }
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] getAreasFromPos: " + e.getMessage());
            }
        }
        finally {
            return dimList;
        }
    }

    boolean getBerechtigt(Player player, classWorldArea res) {
        if (res != null) {
            boolean admin;
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt res " + res.srvID);
            }
            float aPosX = res.Area.getArea().getStartBlockPosition().x + (res.Area.getArea().getEndBlockPosition().x - res.Area.getArea().getStartBlockPosition().x) / 2;
            float aPosY = res.Area.getArea().getStartBlockPosition().y + (res.Area.getArea().getEndBlockPosition().y - res.Area.getArea().getStartBlockPosition().y) / 2;
            float aPosZ = res.Area.getArea().getStartBlockPosition().z + (res.Area.getArea().getEndBlockPosition().z - res.Area.getArea().getStartBlockPosition().z) / 2;
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt resAreaPos[" + aPosX + "|" + aPosY + "|" + aPosZ + "]");
            }
            ArrayList<classDimension> liste = this.getAreasFromPos(res.Area.getPosition());
            boolean owner = false;
            boolean gruppe = false;
            for (classDimension are : liste) {
                Throwable throwable;
                ResultSet result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt are " + are.srvID);
                }
                boolean noGroup = false;
                int areaID = 0;
                int rechteID = 0;
                try {
                    result = this.sqlite.executeQuery("SELECT * FROM 'Areas', 'Rechte', 'GroupList' WHERE Areas.srvID = " + are.srvID + " and Areas.AreaID = Rechte.rAreaID ");
                    throwable = null;
                    try {
                        if (result != null) {
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden");
                            }
                            areaID = 0;
                            rechteID = 0;
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden II");
                            }
                            areaID = result.getInt("AreaID");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden " + areaID);
                            }
                            rechteID = result.getInt("RechteID");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden " + rechteID);
                            }
                            long ownerID = result.getLong("Eigent\u00fcmerID");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden " + ownerID);
                            }
                            String ownerName = result.getString("Eigent\u00fcmer");
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt mit Gruppe Vorhanden aID[" + areaID + "] rID[" + rechteID + "]  result[" + result + "]");
                            }
                            if (areaID != 0 && rechteID != 0) {
                                if (ownerID == player.getUID()) {
                                    owner = true;
                                }
                                gruppe = true;
                            } else {
                                noGroup = true;
                            }
                        }
                    }
                    catch (Throwable ownerID) {
                        throwable = ownerID;
                        throw ownerID;
                    }
                    finally {
                        if (result != null) {
                            if (throwable != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable ownerID) {
                                    throwable.addSuppressed(ownerID);
                                }
                            } else {
                                result.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                    noGroup = true;
                }
                if (!noGroup) continue;
                try {
                    result = this.sqlite.executeQuery("SELECT * FROM 'Areas', 'Rechte' WHERE Areas.srvID = " + are.srvID + " and Areas.AreaID = Rechte.rAreaID ");
                    throwable = null;
                    try {
                        if (result == null) continue;
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt ohne Gruppe Vorhanden");
                        }
                        areaID = 0;
                        rechteID = 0;
                        areaID = result.getInt("AreaID");
                        rechteID = result.getInt("RechteID");
                        String ownerName = result.getString("Eigent\u00fcmer");
                        long ownerID = result.getLong("Eigent\u00fcmerID");
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt ohne Gruppe Vorhanden aID[" + areaID + "] rID[" + rechteID + "]  result[" + result + "]");
                        }
                        if (areaID == 0 || rechteID == 0 || ownerID != player.getUID()) continue;
                        owner = true;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (result == null) continue;
                        if (throwable != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        result.close();
                    }
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
                }
            }
            boolean bl = admin = player.isAdmin() && this.sysConfig.getValue("AccesAllAdmin").toLowerCase().equals("true");
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] getBerechtigt Rechte Admin[" + admin + "] Owner[" + owner + "] Gruppe[" + gruppe + "] ");
            }
            return admin || owner || gruppe;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makeDB(Player player, int areaID) {
        PreparedStatement prep2;
        Throwable throwable2;
        int rechteID = 0;
        int msgID = 0;
        Connection connection = this.sqlite.getConnection();
        try {
            throwable2 = null;
            try (PreparedStatement prep22 = connection.prepareStatement("INSERT INTO 'MSG' ('AreaWelcomMsg', 'AreaFarewellMsg', 'NoEnterAreaMsg', 'NoLeaveAreaMsg') VALUES (?, ?, ?, ?)");){
                prep22.setString(1, "");
                prep22.setString(2, "");
                prep22.setString(3, "");
                prep22.setString(4, "");
                prep22.executeUpdate();
                ResultSet result2 = prep22.getGeneratedKeys();
                if (result2 != null) {
                    msgID = result2.getInt(1);
                }
            }
            catch (Throwable result2) {
                throwable2 = result2;
                throw result2;
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] MSG I " + e.getMessage());
        }
        try {
            prep2 = connection.prepareStatement("INSERT INTO 'Rechte' ('rAreaID', 'rMsgID', 'HealingPoint', 'BrokenBonesPoint', 'BleedingPoint', 'DefineOwner', 'Music') VALUES (?, ?, ?, ?, ?, ?, ?)");
            throwable2 = null;
            try {
                prep2.setInt(1, areaID);
                prep2.setInt(2, msgID);
                prep2.setInt(3, 0);
                prep2.setInt(4, 0);
                prep2.setInt(5, 0);
                prep2.setInt(6, 0);
                prep2.setString(7, "");
                prep2.executeUpdate();
                ResultSet result = prep2.getGeneratedKeys();
                if (result != null) {
                    rechteID = result.getInt(1);
                }
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] SQL Rechte I erstellt");
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (prep2 != null) {
                    if (throwable2 != null) {
                        try {
                            prep2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        prep2.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] Rechte I " + e.getMessage());
        }
        try {
            prep2 = connection.prepareStatement("UPDATE MSG SET mRechteID = ?WHERE msgID = " + msgID + " ");
            throwable2 = null;
            try {
                prep2.setInt(1, rechteID);
                prep2.executeUpdate();
                if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] SQL MSG erstellt");
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (prep2 != null) {
                    if (throwable2 != null) {
                        try {
                            prep2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        prep2.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] MSG II " + e.getMessage());
        }
        int defValue = 0;
        try (PreparedStatement prep = connection.prepareStatement("UPDATE Rechte SET Enter = ?, EnterGroup = ?, EnterPlayer = ?, Leave = ?, LeaveGroup = ?, LeavePlayer = ?, ChestAccess = ?, ChestAccessGroup = ?, ChestAccessPlayer = ?, ChestToInv = ?, ChestToInvGroup = ?, ChestToInvPlayer = ?, InvToChest = ?, InvToChestGroup = ?, InvToChestPlayer = ?, ChestDrop = ?, ChestDropGroup = ?, ChestDropPlayer = ?, Chat = ?, ChatGroup = ?, ChatPlayer = ?, Command = ?, CommandGroup = ?, CommandPlayer = ?, Craft = ?, CraftGroup = ?, CraftPlayer = ?, PVP = ?, PVPGroup = ?, PVPPlayer = ?, InteractElement = ?, InteractElementGroup = ?, InteractElementPlayer = ?, InteractObject = ?, InteractObjectGroup = ?, InteractObjectPlayer = ?, Damage = ?, DamageGroup = ?, DamagePlayer = ?, PickupItem = ?, PickupItemGroup = ?, PickupItemPlayer = ?, Sleep = ?, SleepGroup = ?, SleepPlayer = ?, Fly = ?, FlyGroup = ?, FlyPlayer = ?, DoorOpen = ?, DoorOpenGroup = ?, DoorOpenPlayer = ?, BlueprintCreate = ?, BlueprintCreateGroup = ?, BlueprintCreatePlayer = ?, CreativModus = ?, CreativModusGroup = ?, CreativModusPlayer = ?, CreativePlaceBlock = ?, CreativePlaceBlockGroup = ?, CreativePlaceBlockPlayer = ?, CreativePlaceVegetation = ?, CreativePlaceVegetationGroup = ?, CreativePlaceVegetationPlayer = ?, CreativeTerrainEdit = ?, CreativeTerrainEditGroup = ?, CreativeTerrainEditPlayer = ?, DestroyBlock = ?, DestroyBlockGroup = ?, DestroyBlockPlayer = ?, DestroyConstruction = ?, DestroyConstructionGroup = ?, DestroyConstructionPlayer = ?, DestroyObject = ?, DestroyObjectGroup = ?, DestroyObjectPlayer = ?, DestroyTerrain = ?, DestroyTerrainGroup = ?, DestroyTerrainPlayer = ?, DestroyVegetation = ?, DestroyVegetationGroup = ?, DestroyVegetationPlayer = ?, PlaceBlock = ?, PlaceBlockGroup = ?, PlaceBlockPlayer = ?, PlaceBlueprint = ?, PlaceBlueprintGroup = ?, PlaceBlueprintPlayer = ?, PlaceConstruction = ?, PlaceConstructionGroup = ?, PlaceConstructionPlayer = ?, PlaceGrass = ?, PlaceGrassGroup = ?, PlaceGrassPlayer = ?, PlaceObject = ?, PlaceObjectGroup = ?, PlaceObjectPlayer = ?, PlaceTerrain = ?, PlaceTerrainGroup = ?, PlaceTerrainPlayer = ?, PlaceVegetation = ?, PlaceVegetationGroup = ?, PlaceVegetationPlayer = ?, PlaceWater = ?, PlaceWaterGroup = ?, PlaceWaterPlayer = ?, RemoveConstruction = ?, RemoveConstructionGroup = ?, RemoveConstructionPlayer = ?, RemoveGrass = ?, RemoveGrassGroup = ?, RemoveGrassPlayer = ?, RemoveObject = ?, RemoveObjectGroup = ?, RemoveObjectPlayer = ?, RemoveVegetation = ?, RemoveVegetationGroup = ?, RemoveVegetationPlayer = ?, RemoveWater = ?, RemoveWaterGroup = ?, RemoveWaterPlayer = ?, Healing = ?, HealingGroup = ?, HealingPlayer = ?, BrokenBones = ?, BrokenBonesGroup = ?, BrokenBonesPlayer = ?, Bleeding = ?, BleedingGroup = ?, BleedingPlayer = ?, Explosion = ?, ExplosionGroup = ?, ExplosionPlayer = ? WHERE RechteID = " + rechteID + " AND rAreaID = " + areaID + " ");){
            prep.setInt(1, defValue);
            prep.setInt(2, defValue);
            prep.setInt(3, defValue);
            prep.setInt(4, defValue);
            prep.setInt(5, defValue);
            prep.setInt(6, defValue);
            prep.setInt(7, defValue);
            prep.setInt(8, defValue);
            prep.setInt(9, defValue);
            prep.setInt(10, defValue);
            prep.setInt(11, defValue);
            prep.setInt(12, defValue);
            prep.setInt(13, defValue);
            prep.setInt(14, defValue);
            prep.setInt(15, defValue);
            prep.setInt(16, defValue);
            prep.setInt(17, defValue);
            prep.setInt(18, defValue);
            prep.setInt(19, defValue);
            prep.setInt(20, defValue);
            prep.setInt(21, defValue);
            prep.setInt(22, defValue);
            prep.setInt(23, defValue);
            prep.setInt(24, defValue);
            prep.setInt(25, defValue);
            prep.setInt(26, defValue);
            prep.setInt(27, defValue);
            prep.setInt(28, defValue);
            prep.setInt(29, defValue);
            prep.setInt(30, defValue);
            prep.setInt(31, defValue);
            prep.setInt(32, defValue);
            prep.setInt(33, defValue);
            prep.setInt(34, defValue);
            prep.setInt(35, defValue);
            prep.setInt(36, defValue);
            prep.setInt(37, defValue);
            prep.setInt(38, defValue);
            prep.setInt(39, defValue);
            prep.setInt(40, defValue);
            prep.setInt(41, defValue);
            prep.setInt(42, defValue);
            prep.setInt(43, defValue);
            prep.setInt(44, defValue);
            prep.setInt(45, defValue);
            prep.setInt(46, defValue);
            prep.setInt(47, defValue);
            prep.setInt(48, defValue);
            prep.setInt(49, defValue);
            prep.setInt(50, defValue);
            prep.setInt(51, defValue);
            prep.setInt(52, defValue);
            prep.setInt(53, defValue);
            prep.setInt(54, defValue);
            prep.setInt(55, defValue);
            prep.setInt(56, defValue);
            prep.setInt(57, defValue);
            prep.setInt(58, defValue);
            prep.setInt(59, defValue);
            prep.setInt(60, defValue);
            prep.setInt(61, defValue);
            prep.setInt(62, defValue);
            prep.setInt(63, defValue);
            prep.setInt(64, defValue);
            prep.setInt(65, defValue);
            prep.setInt(66, defValue);
            prep.setInt(67, defValue);
            prep.setInt(68, defValue);
            prep.setInt(69, defValue);
            prep.setInt(70, defValue);
            prep.setInt(71, defValue);
            prep.setInt(72, defValue);
            prep.setInt(73, defValue);
            prep.setInt(74, defValue);
            prep.setInt(75, defValue);
            prep.setInt(76, defValue);
            prep.setInt(77, defValue);
            prep.setInt(78, defValue);
            prep.setInt(79, defValue);
            prep.setInt(80, defValue);
            prep.setInt(81, defValue);
            prep.setInt(82, defValue);
            prep.setInt(83, defValue);
            prep.setInt(84, defValue);
            prep.setInt(85, defValue);
            prep.setInt(86, defValue);
            prep.setInt(87, defValue);
            prep.setInt(88, defValue);
            prep.setInt(89, defValue);
            prep.setInt(90, defValue);
            prep.setInt(91, defValue);
            prep.setInt(92, defValue);
            prep.setInt(93, defValue);
            prep.setInt(94, defValue);
            prep.setInt(95, defValue);
            prep.setInt(96, defValue);
            prep.setInt(97, defValue);
            prep.setInt(98, defValue);
            prep.setInt(99, defValue);
            prep.setInt(100, defValue);
            prep.setInt(101, defValue);
            prep.setInt(102, defValue);
            prep.setInt(103, defValue);
            prep.setInt(104, defValue);
            prep.setInt(105, defValue);
            prep.setInt(106, defValue);
            prep.setInt(107, defValue);
            prep.setInt(108, defValue);
            prep.setInt(109, defValue);
            prep.setInt(110, defValue);
            prep.setInt(111, defValue);
            prep.setInt(112, defValue);
            prep.setInt(113, defValue);
            prep.setInt(114, defValue);
            prep.setInt(115, defValue);
            prep.setInt(116, defValue);
            prep.setInt(117, defValue);
            prep.setInt(118, defValue);
            prep.setInt(119, defValue);
            prep.setInt(120, defValue);
            prep.setInt(121, defValue);
            prep.setInt(122, defValue);
            prep.setInt(123, defValue);
            prep.setInt(124, defValue);
            prep.setInt(125, defValue);
            prep.setInt(126, defValue);
            prep.setInt(127, defValue);
            prep.setInt(128, defValue);
            prep.setInt(129, defValue);
            prep.setInt(130, defValue);
            prep.setInt(131, defValue);
            prep.setInt(132, defValue);
            prep.executeUpdate();
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] SQL Rechte II erstellt");
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] Rechte II " + e.getMessage());
            return false;
        }
    }

    public boolean groupAdd(Player player, int areaID, String gruppeName, int rechteID) {
        boolean result = false;
        int groupID = 0;
        Connection connection = this.sqlite.getConnection();
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] groupAdd  AllPermissionGroups: " + this.server.getAllPermissionGroups() + " ");
        }
        if (this.server.getAllPermissionGroups().toString().toLowerCase().contains(gruppeName.toLowerCase())) {
            try (PreparedStatement prep = connection.prepareStatement("INSERT INTO 'GroupList' ('GroupListName', 'gRechteID', 'gAreaID', 'GroupName', 'GroupID') VALUES (?, ?, ?, ?, ?)");){
                prep.setString(1, "");
                prep.setInt(2, rechteID);
                prep.setInt(3, areaID);
                prep.setString(4, gruppeName.toLowerCase());
                prep.setInt(5, 0);
                prep.executeUpdate();
                ResultSet resultKey = prep.getGeneratedKeys();
                if (resultKey != null) {
                    groupID = resultKey.getInt(1);
                }
                result = true;
            }
            catch (SQLException e) {
                System.err.println("[" + this.plugin.getDescription("name") + "] MSG I " + e.getMessage());
            }
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] groupAdd ");
            }
        } else {
            player.sendTextMessage(String.format(this.plugin.parseColor("[E]//ToDo: MSG(-_-) add Gruppe nicht gefunden, m\u00f6gliche Gruppen: %s"), this.server.getAllPermissionGroups()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean groupRemove(int areaID, String gruppeName) {
        Connection connection = this.sqlite.getConnection();
        boolean result = false;
        try {
            PreparedStatement prep = connection.prepareStatement("DELETE FROM 'GroupList' WHERE gAreaID = " + areaID + " and GroupName = '" + gruppeName + "' ");
            prep.executeUpdate();
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] groupRemove ");
            }
            result = true;
        }
        catch (SQLException e) {
            System.err.println("[" + this.plugin.getDescription("name") + "] " + e.getMessage());
        }
        return result;
    }
}

