/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.WorldGard;
import de.pbplugins.tools.classDimension;
import de.pbplugins.tools.classWorldArea;
import de.pbplugins.tools.wgConfig;
import de.pbplugins.wgArea;
import de.pbplugins.wgClassText;
import java.util.ArrayList;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeGamemodeEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerChestAccessEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerDamageEvent;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerElementInteractionEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerHitEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.PlayerSleepEvent;
import net.risingworld.api.events.player.PlayerStartFlyingEvent;
import net.risingworld.api.events.player.PlayerStopFlyingEvent;
import net.risingworld.api.events.player.inventory.PlayerChestDropEvent;
import net.risingworld.api.events.player.inventory.PlayerChestToInventoryEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryAddEvent;
import net.risingworld.api.events.player.inventory.PlayerInventoryToChestEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionType;

public class WorldGardListenerPlayer
implements Listener {
    private final WorldGard plugin;
    private final wgArea area;
    private final Database sqlite;
    private int debug = 1;
    private wgClassText textDaten;
    private final wgConfig sysConfig;

    public WorldGardListenerPlayer(WorldGard plugin) {
        this.plugin = plugin;
        this.area = plugin.getAreaDaten();
        this.sqlite = plugin.getSqlite();
        this.textDaten = plugin.getTextDaten();
        this.sysConfig = plugin.getSysConfig();
        this.debug = plugin.getDebug();
    }

    @EventMethod
    public void onPlayerChatEvent(PlayerChatEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Chat Spieler[" + event.getPlayer().getName() + "]\t" + event.getChatMessage());
        }
    }

    @EventMethod
    public void onPlayerChestAccessEvent(PlayerChestAccessEvent event) {
        ArrayList res;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestAccess ");
        }
        Player player = event.getPlayer();
        ArrayList<classDimension> findArea = this.area.getAreasFromPos(event.getObjectPosition());
        if (findArea.size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "ChestAccess")) != null) {
            if (this.plugin.getRight(player, res, findArea, "ChestAccess")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_ChestAccess")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerChestDropEvent(PlayerChestDropEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestDrop ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "ChestDrop")) != null) {
            if (this.plugin.getRight(player, res, findArea, "ChestDrop")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_ChestDrop")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerChestToInventoryEvent(PlayerChestToInventoryEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChestToInv (entory)");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "ChestToInv")) != null) {
            if (this.plugin.getRight(player, res, findArea, "ChestToInv")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_ChestToInv")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerInventoryToChestEvent(PlayerInventoryToChestEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] InventoryToChest AKA: InvToChest");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "InvToChest")) != null) {
            if (this.plugin.getRight(player, res, findArea, "InvToChest")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_InvToChest")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerChangeGamemodeEvent(PlayerChangeGamemodeEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ChangeGamemode ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "CreativModus")) != null) {
            if (this.plugin.getRight(player, res, findArea, "CreativModus")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_CreativModus")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerCraftItemEvent(PlayerCraftItemEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] CraftItem ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Craft")) != null) {
            if (this.plugin.getRight(player, res, findArea, "Craft")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_Craft")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerDamageEvent(PlayerDamageEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Damage ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Damage")) != null) {
            if (this.plugin.getRight(player, res, findArea, "Damage")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_Damage")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerEnterAreaEvent(PlayerEnterAreaEvent event) {
        ArrayList thisArea;
        Player player = event.getPlayer();
        boolean dbINT = false;
        Object dbSTRING = null;
        int srvID = event.getArea().getID();
        if (this.debug > 1) {
            System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea ID[" + srvID + "]");
        }
        if ((thisArea = (ArrayList)this.area.getDBWert(srvID, "Enter, AreaName, AreaWelcomMsg, NoEnterAreaMsg")) != null) {
            classWorldArea are = this.area.getAreaBy(player, srvID);
            ArrayList<classDimension> areaList = this.area.getAreasFromPos(are.Area.getPosition());
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea | " + thisArea.get(1).getClass() + " " + thisArea.get(0).getClass() + " " + thisArea.get(2).getClass());
            }
            boolean flyOK = true;
            if (player.isFlying()) {
                flyOK = this.plugin.getRight(player, thisArea, areaList, "Fly");
            }
            if (this.plugin.getRight(player, thisArea, areaList, "Enter") && flyOK) {
                if (!"".equals((String)thisArea.get(2))) {
                    player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)thisArea.get(2)), (String)thisArea.get(1), srvID));
                } else {
                    player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultWelcomMsg")), (String)thisArea.get(1), srvID));
                }
            } else {
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea CANCEL Value[" + (Integer)thisArea.get(0) + "] noFlyCound[" + (Integer)player.getAttribute(this.plugin.playerNoFlyCound) + "] ");
                }
                event.setCancelled(true);
                if (flyOK) {
                    if (!"".equals((String)thisArea.get(3))) {
                        player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)thisArea.get(3)), (String)thisArea.get(1), srvID));
                    } else {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultNoEnterMsg")), (String)thisArea.get(1), srvID));
                    }
                } else {
                    player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultNoFlyMsg")), (String)thisArea.get(1), srvID));
                    this.plugin.getPlayerToGround(player, CollisionType.getBitmask((int[])new int[]{1, 8, 16}));
                    player.setFlying(false);
                }
            }
        }
    }

    @EventMethod
    public void onPlayerLeaveAreaEvent(PlayerLeaveAreaEvent event) {
        ArrayList thisArea;
        Player player = event.getPlayer();
        int srvID = event.getArea().getID();
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea ID[" + srvID + "]");
        }
        if ((thisArea = (ArrayList)this.area.getDBWert(event.getArea().getID(), "Leave, AreaName, AreaFarewellMsg, NoLeaveAreaMsg")) != null) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea | " + thisArea.get(1).toString() + " " + thisArea.get(0).toString());
            }
            ArrayList<classDimension> areaList = this.area.getAreasFromPos(player.getPosition());
            ArrayList prevArea = null;
            boolean flyOK = true;
            if (player.isFlying()) {
                if (areaList.size() > 0) {
                    prevArea = (ArrayList)this.area.getDBWert(areaList.get((int)0).srvID, "Fly, AreaName, srvID");
                    flyOK = this.plugin.getRight(player, prevArea, areaList, "Fly");
                } else if (this.debug > 0) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea isFly noSubArea");
                }
            }
            if (areaList.size() > 0) {
                if (this.plugin.getRight(player, thisArea, areaList, "Leave") && flyOK) {
                    if (!"".equals((String)thisArea.get(2))) {
                        player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)thisArea.get(2)), (String)thisArea.get(1), srvID));
                    } else {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultFarewellMsg")), (String)thisArea.get(1), srvID));
                    }
                } else {
                    if (this.debug > 1) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] EnterArea CANCEL " + (Integer)thisArea.get(0));
                    }
                    event.setCancelled(true);
                    if (flyOK) {
                        if (!"".equals((String)thisArea.get(3))) {
                            player.sendTextMessage(String.format(this.plugin.parseColor("[I]" + (String)thisArea.get(3)), (String)thisArea.get(1), srvID));
                        } else {
                            player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultNoLeaveMsg")), (String)thisArea.get(1), srvID));
                        }
                    } else {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultNoFlyMsg")), (String)prevArea.get(1), (int)((Integer)prevArea.get(2))));
                        this.plugin.getPlayerToGround(player, CollisionType.getBitmask((int[])new int[]{1, 8, 16}));
                        player.setFlying(false);
                    }
                }
            } else if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] LeaveArea noSubArea");
            }
        }
    }

    @EventMethod
    public void onPlayerSleepEvent(PlayerSleepEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Sleep ");
        }
    }

    @EventMethod
    public void onPlayerStartFlyingEvent(PlayerStartFlyingEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] StartFlying ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "Fly, AreaName, srvID")) != null) {
            if (this.plugin.getRight(player, res, findArea, "Fly")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "areaDafaultNoFlyMsg")), (String)res.get(1), (int)((Integer)res.get(2))));
            }
        }
    }

    @EventMethod
    public void onPlayerStopFlyingEvent(PlayerStopFlyingEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] StopFlying ");
        }
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PickupItem ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "PickupItem")) != null) {
            if (this.plugin.getRight(player, res, findArea, "PickupItem")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_PickupItem")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) {
        ArrayList res;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ObjectInteraction Wehlbar[" + event.isObjectSelectable() + "]\tType[" + event.getObjectTypeID() + "]\tVariante[" + event.getObjectVariation() + "]\tStatus[" + event.getObjectStatus() + "]\tInfoID[" + event.getObjectInfoID() + "] isDoor[" + event.getObjectDefinition().isDoor() + "] ");
        }
        Player player = event.getPlayer();
        ArrayList<classDimension> findArea = this.area.getAreasFromPos(event.getObjectPosition());
        if (findArea.size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "InteractObject, Sleep, DoorOpen")) != null) {
            if (this.plugin.getRight(player, res, findArea, "InteractObject")) {
                res.set(0, 0);
                if (this.plugin.getRight(player, res, findArea, "DoorOpen") && event.getObjectDefinition().isDoor()) {
                    event.setCancelled(false);
                } else if (this.plugin.getRight(player, res, findArea, "ChestAccess") && event.getObjectDefinition().isChest()) {
                    event.setCancelled(false);
                } else if (this.plugin.getRight(player, res, findArea, "") && event.getObjectDefinition().isFurnace()) {
                    event.setCancelled(false);
                } else if (this.plugin.getRight(player, res, findArea, "PickupItem") && event.getObjectDefinition().isPickupable()) {
                    event.setCancelled(false);
                } else if (this.plugin.getRight(player, res, findArea, null) && event.getObjectDefinition().isSign()) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                    if (event.getObjectDefinition().isDoor()) {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_DoorOpen")), ""));
                    } else if (event.getObjectDefinition().isChest()) {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_ChestAccess")), ""));
                    } else if (event.getObjectDefinition().isFurnace()) {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_InteractObject")), ""));
                    } else if (event.getObjectDefinition().isPickupable()) {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_PickupItem")), ""));
                    } else if (event.getObjectDefinition().isSign()) {
                        player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_InteractObject")), ""));
                    }
                }
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_InteractObject")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerElementInteractionEvent(PlayerElementInteractionEvent event) {
        ArrayList res;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ElementInteraction ID[" + event.getWorldElement().getID() + "] class[" + event.getWorldElement().getClass() + "] ");
        }
        Player player = event.getPlayer();
        ArrayList<classDimension> findArea = this.area.getAreasFromPos(event.getWorldElement().getPosition());
        if (findArea.size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "InteractObject, Sleep, DoorOpen")) != null) {
            if (this.plugin.getRight(player, res, findArea, "InteractObject")) {
                res.set(0, 0);
                if (this.plugin.getRight(player, res, findArea, "DoorOpen")) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                    player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_DoorOpen")), ""));
                }
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_InteractObject")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerElementHitEvent(PlayerElementHitEvent event) {
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PlayerElementHit ");
        }
    }

    @EventMethod
    public void onPlayerInventoryAddEvent(PlayerInventoryAddEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] InventoryAdd AKA:PickupItem ItemType[" + event.getItem().getTypeID() + "]  ItemVariation[" + event.getItem().getVariation() + "]  ItemStatus[" + event.getItem().getStatus() + "]  ItemOrigin[" + event.getOrigin().ordinal() + "]  Origin[" + event.getOrigin().name() + "] ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "PickupItem")) != null) {
            if (this.plugin.getRight(player, res, findArea, "PickupItem")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_PickupItem")), ""));
            }
        }
    }

    @EventMethod
    public void onPlayerHitEvent(PlayerHitEvent event) {
        ArrayList res;
        Player player;
        ArrayList<classDimension> findArea;
        if (this.debug > 0) {
            System.out.println("[" + this.plugin.getDescription("name") + "] PVP ");
        }
        if ((findArea = this.area.getAreasFromPos((player = event.getPlayer()).getPosition())).size() > 0 && (res = (ArrayList)this.area.getDBWert(findArea.get((int)0).srvID, "PVP")) != null) {
            if (this.plugin.getRight(player, res, findArea, "PVP")) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
                player.sendTextMessage(String.format(this.plugin.parseColor(this.textDaten.getText(player, "event_PVP")), ""));
            }
        }
    }
}

