/*
 * Main.java
 *
 * User: Carsten
 * Date: 17.02.2018
 *
 * Copyright (C) 2018 Carsten
 * Alle Rechte vorbehalten.
 */

package carsten.risingworld.attrtest;

import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;

import java.util.StringTokenizer;

public class Main extends Plugin implements Listener
{
  private static final String ATTR_NAME = "level";

  @Override
  public void onEnable()
  {
    System.out.println("ATTRTEST onEnable");

    registerEventListener(this);
  }

  @Override
  public void onDisable()
  {
    System.out.println("ATTRTEST onDisable");
  }

  @EventMethod(Threading.Async)
  public void onPlayerConnectEvent(PlayerConnectEvent evt)
  {
    System.out.println("ATTRTEST onPlayerConnectEvent");
    Player player = evt.getPlayer();

    player.setAttribute(ATTR_NAME, 1337);
  }

  @EventMethod(Threading.Async)
  public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt)
  {
    Player player = evt.getPlayer();
    System.out.println("ATTRTEST onPlayerDisconnectEvent" + player.getAttribute(ATTR_NAME));

    player.deleteAttribute(ATTR_NAME);
  }

  @EventMethod(Threading.Async)
  public void onPlayerSpawnEvent(PlayerSpawnEvent evt)
  {
    System.out.println("ATTRTEST onPlayerSpawnEvent");
    Player player = evt.getPlayer();

    //player.setAttribute(ATTR_NAME, 1337);
  }

  @EventMethod(Threading.Async)
  public void onPlayerCommand(PlayerCommandEvent evt)
  {
    Player player = evt.getPlayer();

    StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
    if(st.countTokens() < 2)
    {
      return;
    }

    String cmd = st.nextToken();
    if(!"attr".equals(cmd))
    {
      return;
    }

    cmd = st.nextToken();
    switch(cmd)
    {
      case "get":
        player.sendTextMessage("ATTRTEST get " + ATTR_NAME + "=" + player.getAttribute(ATTR_NAME));

        break;

      case "set":
        player.setAttribute(ATTR_NAME, 1337);
        player.sendTextMessage("ATTRTEST set " + ATTR_NAME + "=" + player.getAttribute(ATTR_NAME));

        break;

      case "exception":
        System.out.println("EXCEPTION TEST");
        if((int) player.getAttribute(ATTR_NAME) == 1337)
        {
          System.out.println("no exception");
        }
        break;

      case "print":
        printAllPlayers();
        break;

      default:
        break;
    }
  }

  private void printAllPlayers()
  {
    System.out.println("ATTRTEST printAllPlayers");
    for(Player player : getServer().getAllPlayers())
    {
      player.sendTextMessage(player.getName() + " " + ATTR_NAME + "=" + player.getAttribute(ATTR_NAME));
    }
  }
}
