/*
 * Decompiled with CFR 0.152.
 */
package carsten.risingworld.attrtest;

import java.util.StringTokenizer;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.Threading;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;

public class Main
extends Plugin
implements Listener {
    private static final String ATTR_NAME = "level";

    public void onEnable() {
        System.out.println("ATTRTEST onEnable");
        this.registerEventListener(this);
    }

    public void onDisable() {
        System.out.println("ATTRTEST onDisable");
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerConnectEvent(PlayerConnectEvent evt) {
        System.out.println("ATTRTEST onPlayerConnectEvent");
        Player player = evt.getPlayer();
        player.setAttribute(ATTR_NAME, (Object)1337);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent evt) {
        Player player = evt.getPlayer();
        System.out.println("ATTRTEST onPlayerDisconnectEvent" + player.getAttribute(ATTR_NAME));
        player.deleteAttribute(ATTR_NAME);
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerSpawnEvent(PlayerSpawnEvent evt) {
        System.out.println("ATTRTEST onPlayerSpawnEvent");
        Player player = evt.getPlayer();
    }

    @EventMethod(value=Threading.Async)
    public void onPlayerCommand(PlayerCommandEvent evt) {
        Player player = evt.getPlayer();
        StringTokenizer st = new StringTokenizer(evt.getCommand(), " /");
        if (st.countTokens() < 2) {
            return;
        }
        String cmd = st.nextToken();
        if (!"attr".equals(cmd)) {
            return;
        }
        switch (cmd = st.nextToken()) {
            case "get": {
                player.sendTextMessage("ATTRTEST get level=" + player.getAttribute(ATTR_NAME));
                break;
            }
            case "set": {
                player.setAttribute(ATTR_NAME, (Object)1337);
                player.sendTextMessage("ATTRTEST set level=" + player.getAttribute(ATTR_NAME));
                break;
            }
            case "exception": {
                System.out.println("EXCEPTION TEST");
                if ((Integer)player.getAttribute(ATTR_NAME) != 1337) break;
                System.out.println("no exception");
                break;
            }
            case "print": {
                this.printAllPlayers();
                break;
            }
        }
    }

    private void printAllPlayers() {
        System.out.println("ATTRTEST printAllPlayers");
        for (Player player : this.getServer().getAllPlayers()) {
            player.sendTextMessage(player.getName() + " " + ATTR_NAME + "=" + player.getAttribute(ATTR_NAME));
        }
    }
}

