/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.util.HashMap;

public enum Animation {
    TPose(Type.Misc, true, "t-pose"),
    WalkForward(Type.Movement, true, "walk"),
    WalkForward2(Type.Movement, true, "walk", 1.25f),
    WalkBackward(Type.Movement, true, "walk-back", 1.5f),
    WalkRight(Type.Movement, true, "walk-right-45"),
    WalkLeft(Type.Movement, true, "walk-left-45"),
    StrafeRight(Type.Movement, true, "strafe-right", 1.5f),
    StrafeLeft(Type.Movement, true, "strafe-left", 1.5f),
    RunForward(Type.Movement, true, "run", 1.175f),
    RunForward2(Type.Movement, true, "run2", 0.85f),
    RunRight(Type.Movement, true, "run-right-45"),
    RunLeft(Type.Movement, true, "run-left-45"),
    RunJump(Type.Movement, false, "run-jump"),
    Jump(Type.Movement, false, "jump", 1.5f),
    CrouchIdle1(Type.Idle, true, "crouch-idle1"),
    CrouchIdle2(Type.Idle, true, "crouch-idle2"),
    CrouchWalkForward(Type.Movement, true, "crouch-walk"),
    CrouchWalkForward2(Type.Movement, true, "crouch-walk2", 1.5f),
    CrouchWalkBackward(Type.Movement, true, "crouch-walk2"),
    CrouchWalkRight(Type.Movement, true, "crouch-walk-right-45", 1.5f),
    CrouchWalkLeft(Type.Movement, true, "crouch-walk-left-45", 1.5f),
    Idle1(Type.Idle, true, "idle1"),
    Idle2(Type.Idle, true, "idle2"),
    Idle3(Type.Interaction, true, "idle3"),
    Idle4(Type.Movement, true, "idle4"),
    SitChair(Type.Misc, true, "sit-chair"),
    SleepIdle(Type.Misc, true, "sleep"),
    Eat(Type.InteractionPartly, false, "eat"),
    EatIdle(Type.InteractionPartly, true, "eat-idle"),
    Interaction1(Type.InteractionPartly, false, "interaction1"),
    Swim(Type.InteractionPartly, true, "swim"),
    GetHit1(Type.Movement, false, "gethit1"),
    GetHit2(Type.Movement, false, "gethit2"),
    Death(Type.Misc, false, "death1"),
    DeathIdle(Type.Misc, true, "death-idle"),
    Punch1(Type.Interaction, true, "punch1"),
    Punch2(Type.Interaction, true, "punch2"),
    Weapon1HandHit1(Type.Interaction, true, "weapon-1hand-hit1", 0.7f),
    Weapon1HandHit2(Type.Interaction, true, "weapon-1hand-hit2"),
    Weapon1HandHit3(Type.Interaction, true, "weapon-1hand-hit3"),
    Weapon1HandHit1S(Type.Interaction, true, "weapon-1hand-s-hit1"),
    Weapon1HandHit2S(Type.Interaction, true, "weapon-1hand-s-hit2"),
    Weapon1HandHit3S(Type.Interaction, true, "weapon-1hand-s-hit3"),
    Weapon1HandIdle(Type.Interaction, true, "weapon-1hand-idle"),
    Weapon2HandHit1(Type.Interaction, true, "weapon-2hand-hit1"),
    Weapon2HandHit2(Type.Interaction, true, "weapon-2hand-hit2"),
    Weapon2HandHit3(Type.Interaction, true, "weapon-2hand-hit3"),
    Weapon2HandIdle(Type.Interaction, true, "weapon-2hand-idle"),
    Sickle(Type.Interaction, true, "sickle"),
    Shovel(Type.Interaction, true, "shovel"),
    ShovelIdle(Type.InteractionPartly, true, "shovel-idle"),
    Rake(Type.Interaction, true, "rake", 2.0f),
    RakeIdle(Type.InteractionPartly, true, "rake-idle"),
    Scythe(Type.Interaction, true, "scythe"),
    ScytheIdle(Type.InteractionPartly, true, "scythe-idle"),
    Scythe2(Type.Interaction, true, "scythe2"),
    Scythe2Idle(Type.InteractionPartly, true, "scythe2-idle"),
    Pickaxe1(Type.Interaction, true, "pickaxe1", 2.5f),
    Pickaxe1Idle(Type.InteractionPartly, true, "pickaxe1-idle"),
    Pickaxe2(Type.Interaction, true, "pickaxe2", 1.75f),
    Pickaxe2Idle(Type.InteractionPartly, true, "pickaxe2-idle"),
    Axe(Type.Interaction, true, "axe", 1.6f),
    AxeIdle(Type.InteractionPartly, true, "axe-idle"),
    AxePrimitive(Type.Interaction, true, "axe-primitive", 2.0f),
    AxePrimitiveIdle(Type.InteractionPartly, true, "axe-primitive-idle"),
    BowTakeArrow(Type.Interaction, false, "bow-takearrow"),
    BowLoad(Type.Interaction, false, "bow-load"),
    BowIdle(Type.Interaction, true, "bow-idle"),
    BowIdle2(Type.Interaction, true, "bow-idle2"),
    BowFire(Type.Interaction, false, "bow-fire"),
    Bow2TakeArrow(Type.Interaction, false, "bow2-takearrow"),
    Bow2Load(Type.Interaction, false, "bow2-load"),
    Bow2Idle(Type.Interaction, true, "bow2-idle"),
    Bow2Idle2(Type.Interaction, true, "bow2-idle2"),
    Bow2Fire(Type.Interaction, false, "bow2-fire"),
    CrossbowReload(Type.Interaction, false, "crossbow-reload"),
    CrossbowIdle(Type.Interaction, true, "crossbow-idle"),
    CrossbowAim(Type.Interaction, false, "crossbow-aim"),
    CrossbowFire(Type.Interaction, false, "crossbow-fire"),
    SpearIdle(Type.Interaction, true, "spear-idle"),
    SpearThrow(Type.Interaction, false, "spear-throw"),
    RevolverIdle(Type.Interaction, true, "revolver-idle"),
    RevolverIdle2(Type.Interaction, true, "revolver-idle2"),
    RevolverAim(Type.Interaction, true, "revolver-aim"),
    RevolverFire(Type.Interaction, false, "revolver-fire"),
    RevolverReload(Type.Interaction, false, "revolver-reload"),
    MusketIdle(Type.Interaction, true, "musket-idle"),
    MusketIdle2(Type.Interaction, true, "musket-idle2"),
    MusketLoad(Type.Interaction, false, "musket-load"),
    MusketAim(Type.Interaction, true, "musket-aim"),
    MusketFire(Type.Interaction, false, "musket-fire"),
    MusketReload(Type.Interaction, false, "musket-reload"),
    HarpoonIdle(Type.Interaction, true, "harpoon-idle"),
    HarpoonAim(Type.Interaction, true, "harpoon-aim"),
    HarpoonFire(Type.Interaction, false, "harpoon-fire"),
    HarpoonReload(Type.Interaction, false, "harpoon-reload"),
    M14Aim(Type.Interaction, true, "m14-aim"),
    M14Idle(Type.Interaction, true, "m14-idle"),
    M14Fire(Type.Interaction, false, "m14-fire"),
    M14Reload(Type.Interaction, false, "m14-reload"),
    RepeaterAim(Type.Interaction, true, "repeater-aim"),
    RepeaterIdle(Type.Interaction, true, "repeater-idle"),
    RepeaterFire(Type.Interaction, false, "repeater-fire"),
    RepeaterFire2(Type.Interaction, false, "repeater-fire2"),
    RepeaterLoad(Type.Interaction, false, "repeater-load"),
    RepeaterReload(Type.Interaction, false, "repeater-reload"),
    CannonIdle1(Type.Misc, true, "cannon-idle1"),
    CannonIdle2(Type.Misc, true, "cannon-idle2"),
    CannonFire1(Type.Misc, false, "cannon-fire1"),
    CannonFire2(Type.Misc, false, "cannon-fire2"),
    ChainsawIdle(Type.Interaction, true, "chainsaw-idle"),
    ChainsawStart(Type.Interaction, false, "chainsaw-start"),
    ChainsawTakeup(Type.Interaction, false, "chainsaw-takeup"),
    ChainsawSawStart(Type.Interaction, false, "chainsaw-saw-start"),
    ChainsawSaw(Type.Interaction, true, "chainsaw-saw"),
    ChainsawTurnoff(Type.Interaction, false, "chainsaw-turnoff"),
    MiningdrillIdle(Type.Interaction, true, "miningdrill-idle"),
    MiningdrillStart(Type.Interaction, false, "miningdrill-start"),
    MiningdrillDrill(Type.Interaction, true, "miningdrill-drill"),
    MiningdrillTurnoff(Type.Interaction, false, "miningdrill-turnoff"),
    TrimmerIdle(Type.Interaction, true, "trimmer-idle"),
    TrimmerStart(Type.Interaction, false, "trimmer-start"),
    TrimmerCut(Type.Interaction, true, "trimmer-cut"),
    TrimmerTurnoff(Type.Interaction, false, "trimmer-turnoff"),
    MowerIdle(Type.Misc, true, "mower-idle"),
    WateringcanIdle(Type.Interaction, true, "wateringcan-idle"),
    WateringcanFill(Type.Interaction, false, "wateringcan-fill"),
    WateringcanSpill(Type.Interaction, false, "wateringcan-spill"),
    WateringcanSpillIdle(Type.Interaction, true, "wateringcan-spill-idle"),
    HoldTorch(Type.Interaction, true, "hold-torch"),
    HoldLantern(Type.Interaction, true, "hold-lantern"),
    HoldFlashlight(Type.Interaction, true, "hold-flashlight"),
    HoldMiscL(Type.Interaction, true, "hold-misc-l"),
    CrowbarIdle1(Type.Interaction, true, "crowbar-idle1"),
    CrowbarIdle2(Type.Interaction, true, "crowbar-idle2"),
    CrowbarUse(Type.Interaction, true, "crowbar-use", 0.65f),
    CrowbarUse2(Type.Interaction, false, "crowbar-use2", 0.65f),
    CrowbarHit(Type.Interaction, true, "crowbar-hit", 0.9f),
    BucketIdle(Type.Interaction, true, "bucket-idle"),
    BucketFill(Type.Interaction, false, "bucket-fill"),
    BucketEmpty(Type.Interaction, false, "bucket-empty"),
    JerrycanIdle(Type.Interaction, true, "jerrycan-idle"),
    JerrycanEmpty(Type.Interaction, false, "jerrycan-empty"),
    CanteenIdle1(Type.Interaction, true, "canteen-idle1"),
    CanteenIdle2(Type.Interaction, true, "canteen-idle2"),
    CanteenOpen(Type.Interaction, false, "canteen-open"),
    CanteenDrink(Type.Interaction, false, "canteen-drink"),
    CanteenDrink2(Type.Interaction, false, "canteen-drink2"),
    CanteenClose(Type.Interaction, false, "canteen-close"),
    CanteenFill(Type.Interaction, false, "canteen-fill"),
    WaterskinIdle1(Type.Interaction, true, "waterskin-idle1"),
    WaterskinIdle2(Type.Interaction, true, "waterskin-idle2"),
    WaterskinOpen(Type.Interaction, false, "waterskin-open"),
    WaterskinDrink(Type.Interaction, false, "waterskin-drink"),
    WaterskinDrink2(Type.Interaction, false, "waterskin-drink2"),
    WaterskinClose(Type.Interaction, false, "waterskin-close"),
    WaterskinFill(Type.Interaction, false, "waterskin-fill"),
    WrenchIdle(Type.Interaction, true, "wrench-idle"),
    WrenchTakeup(Type.Interaction, false, "wrench-takeup"),
    WrenchUse(Type.Interaction, true, "wrench-use"),
    WrenchTakedown(Type.Interaction, false, "wrench-takedown"),
    RatchetIdle(Type.Interaction, true, "ratchet-idle"),
    RatchetTakeup(Type.Interaction, false, "ratchet-takeup"),
    RatchetUse(Type.Interaction, true, "ratchet-use"),
    RatchetTakedown(Type.Interaction, false, "ratchet-takedown"),
    ShearsIdle(Type.Interaction, true, "shears-idle"),
    ShearsUse(Type.Interaction, true, "shears-use"),
    TelescopeIdle(Type.Interaction, true, "telescope-idle"),
    TelescopeOpen(Type.Interaction, false, "telescope-open"),
    TelescopeLook(Type.Interaction, true, "telescope-look"),
    TelescopeClose(Type.Interaction, false, "telescope-close"),
    BinocularIdle(Type.Interaction, true, "binocular-idle"),
    BinocularTakeup(Type.Interaction, false, "binocular-takeup"),
    BinocularLook(Type.Interaction, true, "binocular-look"),
    BinocularTakedown(Type.Interaction, false, "binocular-takedown"),
    CompassIdle(Type.Interaction, true, "compass-idle"),
    CompassTakeup(Type.Interaction, false, "compass-takeup"),
    CompassTakedown(Type.Interaction, false, "compass-takedown"),
    MapIdle(Type.Interaction, true, "map-idle"),
    MapTakeup(Type.Interaction, false, "map-takeup"),
    MapTakedown(Type.Interaction, false, "map-takedown"),
    FiresteelTakeup(Type.Interaction, false, "firesteel-takeup"),
    FiresteelUse(Type.Interaction, true, "firesteel-use"),
    FiresteelTakedown(Type.Interaction, false, "firesteel-takedown"),
    DynamiteIdle1(Type.Interaction, true, "dynamite-idle1"),
    DynamiteIdle2(Type.Interaction, true, "dynamite-idle2"),
    DynamiteFuse1(Type.Interaction, false, "dynamite-fuse1", 0.5f),
    DynamiteFuse2(Type.Interaction, false, "dynamite-fuse2", 0.5f),
    DynamiteThrow(Type.Interaction, false, "dynamite-throw"),
    MultimeterIdle(Type.Interaction, true, "multimeter-idle"),
    FishingIdle(Type.Interaction, true, "fishing-idle"),
    FishingStart(Type.Interaction, false, "fishing-start"),
    FishingIdle2(Type.Interaction, true, "fishing-idle2"),
    FishingPullback(Type.Interaction, false, "fishing-pullback"),
    FishingIdle3(Type.Interaction, true, "fishing-idle3"),
    BoatIdle1(Type.Misc, true, "boat-idle1"),
    BoatIdle2(Type.Misc, true, "boat-idle2"),
    BoatStartPaddling(Type.Misc, false, "boat-start-paddling"),
    BoatPaddle(Type.Misc, true, "boat-paddle"),
    HorseTPose(Type.Misc, true, "horse-t-pose"),
    HoldPelt1(Type.Interaction, true, "hold-pelt1"),
    HoldPelt2(Type.Interaction, true, "hold-pelt2"),
    HoldPelt3(Type.Interaction, true, "hold-pelt3"),
    HoldOreDetector(Type.Interaction, true, "hold-oredetector"),
    TanningIdle(Type.Interaction, true, "tanning-idle"),
    Tanning(Type.Interaction, true, "tanning"),
    KnifeIdle(Type.Interaction, true, "knife-idle"),
    KnifeHit1(Type.Interaction, true, "knife-hit1"),
    Gesture1(Type.Interaction, true, "gesture1"),
    Gesture2(Type.Interaction, true, "gesture2"),
    Gesture3(Type.Interaction, true, "gesture3"),
    Gesture4(Type.Interaction, true, "gesture4"),
    Gesture5(Type.Interaction, true, "gesture5"),
    Gesture6(Type.Interaction, true, "gesture6"),
    Gesture7(Type.Interaction, true, "gesture7");

    private Type type;
    private String rawname;
    private float speed;
    private boolean loop;
    private int[] data = null;
    private Animation replacement = null;
    private static final HashMap<String, Animation> rawNamesMapping;
    private static final Animation[] values;

    private Animation(Type type, boolean loop, String rawname, float speed) {
        this.type = type;
        this.rawname = rawname;
        this.speed = speed;
        this.loop = loop;
    }

    private Animation(Type type, boolean loop, String rawname) {
        this(type, loop, rawname, 1.0f);
    }

    public Type getType() {
        return this.type;
    }

    public String getRawName() {
        return this.rawname;
    }

    public void setData(int[] data) {
        this.data = data;
    }

    public int[] getData() {
        return this.data;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean isLoop() {
        return this.loop;
    }

    private void setReplacement(Animation animation) {
        this.replacement = animation;
    }

    public Animation getReplacement() {
        return this.replacement;
    }

    public static Animation getDefaultAnimation() {
        return Idle1;
    }

    public static Animation getAnimation(int id) {
        if (id < 0 || id >= values.length) {
            return null;
        }
        return values[id];
    }

    public static Animation getAnimationByRawName(String rawName) {
        return rawNamesMapping.get(rawName);
    }

    static {
        rawNamesMapping = new HashMap();
        values = Animation.values();
        BowFire.setData(new int[]{0, 75, 0});
        BowIdle.setData(new int[]{0, 75, 0});
        BowLoad.setData(new int[]{0, 75, 0});
        BowTakeArrow.setData(new int[]{0, 75, 0});
        CrossbowAim.setData(new int[]{0, -50, 0});
        CrossbowFire.setData(new int[]{0, -50, 0});
        CrossbowIdle.setData(new int[]{0, -50, 0});
        CrossbowReload.setData(new int[]{0, -50, 0});
        RevolverAim.setData(new int[]{0, 25, 0});
        RevolverFire.setData(new int[]{0, 25, 0});
        RevolverIdle.setData(new int[]{0, 25, 0});
        RevolverIdle2.setData(new int[]{0, 25, 0});
        RevolverReload.setData(new int[]{0, 25, 0});
        MusketAim.setData(new int[]{0, -45, 0});
        MusketFire.setData(new int[]{0, -45, 0});
        MusketIdle.setData(new int[]{0, -45, 0});
        MusketIdle2.setData(new int[]{0, -45, 0});
        MusketLoad.setData(new int[]{0, -45, 0});
        MusketReload.setData(new int[]{0, -45, 0});
        HarpoonAim.setData(new int[]{0, -45, 0});
        HarpoonFire.setData(new int[]{0, -45, 0});
        HarpoonIdle.setData(new int[]{0, -45, 0});
        HarpoonReload.setData(new int[]{0, -45, 0});
        M14Aim.setData(new int[]{0, -45, 0});
        M14Fire.setData(new int[]{0, -45, 0});
        M14Idle.setData(new int[]{0, -45, 0});
        M14Reload.setData(new int[]{0, -45, 0});
        RepeaterAim.setData(new int[]{0, -45, 0});
        RepeaterFire.setData(new int[]{0, -45, 0});
        RepeaterFire2.setData(new int[]{0, -45, 0});
        RepeaterIdle.setData(new int[]{0, -45, 0});
        RepeaterLoad.setData(new int[]{0, -45, 0});
        RepeaterReload.setData(new int[]{0, -45, 0});
        ChainsawIdle.setData(new int[]{0, -45, 0});
        ChainsawSaw.setData(new int[]{0, -45, 0});
        ChainsawSawStart.setData(new int[]{0, -45, 0});
        ChainsawStart.setData(new int[]{0, -45, 0});
        ChainsawTakeup.setData(new int[]{0, -45, 0});
        ChainsawTurnoff.setData(new int[]{0, -45, 0});
        MiningdrillDrill.setData(new int[]{0, -45, 0});
        MiningdrillIdle.setData(new int[]{0, -45, 0});
        MiningdrillStart.setData(new int[]{0, -45, 0});
        MiningdrillTurnoff.setData(new int[]{0, -45, 0});
        TrimmerCut.setData(new int[]{0, -45, 0});
        TrimmerIdle.setData(new int[]{0, -45, 0});
        TrimmerStart.setData(new int[]{0, -45, 0});
        TrimmerTurnoff.setData(new int[]{0, -45, 0});
        Idle3.setReplacement(Idle1);
        Idle4.setReplacement(Idle1);
        for (Animation anim : Animation.values()) {
            rawNamesMapping.put(anim.getRawName(), anim);
        }
    }

    public static enum Type {
        Idle,
        Movement,
        Interaction,
        InteractionPartly,
        Misc;

    }
}

