/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Gamemode;

public class PlayerChangeGamemodeEvent
extends PlayerEvent
implements Cancellable {
    private Gamemode newGameMode;
    private boolean cancelled = false;
    private String cancelReason = null;

    public PlayerChangeGamemodeEvent(Player player, Gamemode gamemode) {
        super(player);
        this.newGameMode = gamemode;
    }

    public Gamemode getNewGamemode() {
        return this.newGameMode;
    }

    public void setNewGamemode(Gamemode mode) {
        if (mode == null || mode == Gamemode.Adventure || mode == Gamemode.Stranded) {
            System.err.println("Gamemode '" + (Object)((Object)mode) + "' not supported");
        } else {
            this.newGameMode = mode;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public void setCancelled(boolean cancel, String reason) {
        this.cancelled = cancel;
        this.cancelReason = reason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }
}

