/*
 * Decompiled with CFR 0.152.
 */
package SyBozz.RisingWorld.Notify;

import SyBozz.RisingWorld.Notify.Notify;
import SyBozz.RisingWorld.Notify.NotifyAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risingworld.api.Timer;
import net.risingworld.api.objects.Player;

public final class Notification {
    private static Map<Player, List<NotifyAction>> _notifyMap = new HashMap<Player, List<NotifyAction>>();
    private static Map<Player, Timer> _updateTimer = new HashMap<Player, Timer>();

    private Notification() {
    }

    public static void sendToPlayer(Player player, String message) {
        new Notify(message).sendToPlayer(player);
    }

    public static void sendToPlayer(Player player, String message, int duration) {
        new Notify(message, duration).sendToPlayer(player);
    }

    public static void sendToAll(Collection<Player> playerList, String message) {
        if (playerList.size() < 1) {
            return;
        }
        for (Player player : playerList) {
            Notification.sendToPlayer(player, message);
        }
    }

    public static void sendToAll(Collection<Player> playerList, String message, int duration) {
        if (playerList.size() < 1) {
            return;
        }
        for (Player player : playerList) {
            Notification.sendToPlayer(player, message, duration);
        }
    }

    static void addPlayer(Player player) {
        if (_notifyMap == null) {
            _notifyMap = new HashMap<Player, List<NotifyAction>>();
        }
        if (_notifyMap.containsKey(player)) {
            _notifyMap.remove(player);
        }
        if (_updateTimer.containsKey(player)) {
            if (_updateTimer.get(player).isActive()) {
                _updateTimer.get(player).kill();
            }
            _updateTimer.remove(player);
        }
        _notifyMap.put(player, new ArrayList());
        _updateTimer.put(player, new Timer(1.0f, 0.0f, -1, () -> Notification.checkNotifications(player)));
    }

    static void removeNotify(Player player, NotifyAction notifyAction) {
        if (!_notifyMap.containsKey(player)) {
            return;
        }
        _notifyMap.get(player).remove(notifyAction);
    }

    static void sendToPlayer(Player player, NotifyAction newNotify) {
        if (!_notifyMap.containsKey(player)) {
            Notification.addPlayer(player);
        }
        _notifyMap.get(player).add(newNotify);
        if (_updateTimer.containsKey(player) && !_updateTimer.get(player).isActive()) {
            _updateTimer.remove(player);
            _updateTimer.put(player, new Timer(1.0f, 0.0f, -1, () -> Notification.checkNotifications(player)));
            _updateTimer.get(player).start();
        }
    }

    private static void checkNotifications(Player player) {
        int size = _notifyMap.get(player).size();
        if (size == 0) {
            _updateTimer.get(player).kill();
        } else if (size == 1) {
            if (!_notifyMap.get(player).get(0).isActive()) {
                _notifyMap.get(player).get(0).start(0);
            }
        } else if (size == 2) {
            if (_notifyMap.get(player).get(0).isActive()) {
                _notifyMap.get(player).get(0).startMoveUp(1);
            }
            if (!_notifyMap.get(player).get(1).isActive()) {
                _notifyMap.get(player).get(1).start(0);
            }
        } else if (size >= 3) {
            if (_notifyMap.get(player).get(0).isActive() && _notifyMap.get(player).get(0).getPosition() != 2) {
                _notifyMap.get(player).get(0).startMoveUp(2);
            }
            if (_notifyMap.get(player).get(1).isActive() && _notifyMap.get(player).get(1).getPosition() != 1) {
                _notifyMap.get(player).get(1).startMoveUp(1);
            }
            if (!_notifyMap.get(player).get(2).isActive()) {
                _notifyMap.get(player).get(2).start(0);
            }
        }
    }
}

