/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.gui;

import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.utils.Utils;
import pluginapi.manager.PluginGuiManager;

public class GuiLabel
extends GuiElement {
    private String text = "";
    private Font font = Font.Default;
    private int fontsize = 24;
    private int fontcolor = -1;
    private boolean colorcodesenabled = true;

    public GuiLabel(float x, float y, boolean relativeposition) {
        this("", x, y, relativeposition);
    }

    public GuiLabel(String text, float x, float y, boolean relativeposition) {
        super(x, y, relativeposition, 0.0f, 0.0f, false);
        this.color = 0;
        this.text = text;
    }

    public void setText(String text) {
        this.text = text;
        this.updateLabel();
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            this.updateLabel();
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFontSize(int size) {
        if (this.fontsize != size) {
            this.fontsize = size;
            this.updateLabel();
        }
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setFontColor(int color) {
        if (this.fontcolor != color) {
            this.fontcolor = color;
            this.updateLabel();
        }
    }

    public void setFontColor(float r, float g, float b, float a) {
        this.setFontColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public int getFontColor() {
        return this.fontcolor;
    }

    public void setColorCodesEnabled(boolean set) {
        this.colorcodesenabled = set;
        this.updateLabel();
    }

    public boolean isColorCodesEnabled() {
        return this.colorcodesenabled;
    }

    @Override
    public void setClickable(boolean set) {
        super.setClickable(set);
    }

    @Override
    public boolean isClickable() {
        return super.isClickable();
    }

    @Override
    public void setSize(float width, float height, boolean relative) {
        this.sizex = width;
        this.sizey = height;
        this.relativesize = relative;
    }

    @Override
    public float getWidth() {
        return 0.0f;
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    public boolean isRelativeSize() {
        return false;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateLabel();
    }

    private void updateLabel() {
        PluginGuiManager.updateGuiLabel((GuiLabel)this);
    }
}

