/*
 * Decompiled with CFR 0.152.
 */
package SyBozz.RisingWorld.Notify;

import SyBozz.RisingWorld.Notify.Color;
import SyBozz.RisingWorld.Notify.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

class Config {
    private String _path = Main._path + File.separator + "config.ini";
    private Properties _configFile;
    private Color _bgColor;
    private Color _tbColor;
    private Color _sbColor;
    private boolean _enableSB;

    public Color get_bgColor() {
        return this._bgColor;
    }

    public Color get_tbColor() {
        return this._tbColor;
    }

    public Color get_sbColor() {
        return this._sbColor;
    }

    public boolean is_enableSB() {
        return this._enableSB;
    }

    Config() {
        this.load();
    }

    void load() {
        Main.cOutput("Loading config.");
        File f = new File(this._path);
        if (!f.exists()) {
            Main.cOutput("Config file doesn't exist.");
            this.create();
            return;
        }
        this._configFile = new Properties();
        try {
            FileInputStream file = new FileInputStream(this._path);
            this._configFile.load(file);
            this._bgColor = this._configFile.getProperty("Background") == null ? null : this.stringToColor(this._configFile.getProperty("Background"));
            this._tbColor = this._configFile.getProperty("TimeBar") == null ? null : this.stringToColor(this._configFile.getProperty("TimeBar"));
            this._sbColor = this._configFile.getProperty("SideBar") == null ? null : this.stringToColor(this._configFile.getProperty("SideBar"));
            this._enableSB = this._configFile.getProperty("EnableSideBar") == null || Boolean.parseBoolean(this._configFile.getProperty("EnableSideBar"));
            this.checkValues();
        }
        catch (Exception e) {
            Main.cOutput(e.getMessage());
        }
    }

    private void checkValues() {
        boolean update = false;
        if (this._bgColor == null) {
            this._bgColor = Color.black;
            Main.cOutput("Wrong values by background color.");
            update = true;
        }
        if (this._tbColor == null) {
            this._tbColor = Color.red;
            Main.cOutput("Wrong values by timebar color.");
            update = true;
        }
        if (this._sbColor == null) {
            this._sbColor = Color.yellow;
            Main.cOutput("Wrong values by sidebar color.");
            update = true;
        }
        if (this._configFile.getProperty("EnableSideBar") == null) {
            this._sbColor = Color.yellow;
            Main.cOutput("Enable sidebar key not found.");
            update = true;
        }
        if (update) {
            Main.cOutput("Updating config file");
            this._configFile = new Properties();
            this._configFile.setProperty("Background", this.colorToString(this._bgColor));
            this._configFile.setProperty("TimeBar", this.colorToString(this._tbColor));
            this._configFile.setProperty("SideBar", this.colorToString(this._sbColor));
            this._configFile.setProperty("EnableSideBar", String.valueOf(this._enableSB));
            try {
                FileOutputStream file = new FileOutputStream(this._path);
                this._configFile.store(file, null);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void create() {
        Main.cOutput("Creating a new config file.");
        this._configFile = new Properties();
        this._configFile.setProperty("Background", this.colorToString(Color.black));
        this._configFile.setProperty("TimeBar", this.colorToString(Color.red));
        this._configFile.setProperty("SideBar", this.colorToString(Color.yellow));
        this._configFile.setProperty("EnableSideBar", String.valueOf(true));
        try {
            FileOutputStream file = new FileOutputStream(this._path);
            this._configFile.store(file, null);
        }
        catch (Exception e) {
            Main.cOutput(e.getMessage());
        }
    }

    private String colorToString(Color target) {
        return target.r + "/" + target.g + "/" + target.b + "/" + target.a;
    }

    private Color stringToColor(String input) {
        String[] values = input.split("/");
        if (values.length == 4) {
            return new Color(Float.parseFloat(values[0]), Float.parseFloat(values[1]), Float.parseFloat(values[2]), Float.parseFloat(values[3]));
        }
        return null;
    }
}

