/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Vector3f;

public class Quaternion {
    public static final Quaternion IDENTITY = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Quaternion ZERO = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    public float w;

    public Quaternion() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(Quaternion copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
        this.w = copy.w;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion setX(float x) {
        this.x = x;
        return this;
    }

    public Quaternion setY(float y) {
        this.y = y;
        return this;
    }

    public Quaternion setZ(float z) {
        this.z = z;
        return this;
    }

    public Quaternion setW(float w) {
        this.w = w;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public Quaternion loadIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public Quaternion fromAngles(float[] angles) {
        return this.fromAngles(angles[0], angles[1], angles[2]);
    }

    public Quaternion fromAngles(float pitch, float yaw, float roll) {
        float c1 = (float)Math.cos((double)yaw * 0.5);
        float c2 = (float)Math.cos((double)roll * 0.5);
        float c3 = (float)Math.cos((double)pitch * 0.5);
        float s1 = (float)Math.sin((double)yaw * 0.5);
        float s2 = (float)Math.sin((double)roll * 0.5);
        float s3 = (float)Math.sin((double)pitch * 0.5);
        this.w = c1 * c2 * c3 - s1 * s2 * s3;
        this.x = s1 * s2 * c3 + c1 * c2 * s3;
        this.y = s1 * c2 * c3 + c1 * s2 * s3;
        this.z = c1 * s2 * c3 - s1 * c2 * s3;
        return this;
    }

    public float[] toAngles() {
        return this.toAngles(null);
    }

    public float[] toAngles(float[] storeTo) {
        float sqw;
        float sqz;
        float sqy;
        float sqx;
        float unit;
        float test;
        if (storeTo == null) {
            storeTo = new float[3];
        }
        if ((double)(test = this.x * this.y + this.z * this.w) > 0.499 * (double)(unit = (sqx = this.x * this.x) + (sqy = this.y * this.y) + (sqz = this.z * this.z) + (sqw = this.w * this.w))) {
            storeTo[1] = 2.0f * (float)Math.atan2(this.x, this.w);
            storeTo[2] = 1.5707964f;
            storeTo[0] = 0.0f;
        } else if ((double)test < -0.499 * (double)unit) {
            storeTo[1] = -2.0f * (float)Math.atan2(this.x, this.w);
            storeTo[2] = -1.5707964f;
            storeTo[0] = 0.0f;
        } else {
            storeTo[1] = (float)Math.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, sqx - sqy - sqz + sqw);
            storeTo[2] = (float)Math.asin(2.0f * test / unit);
            storeTo[0] = (float)Math.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, -sqx + sqy - sqz + sqw);
        }
        return storeTo;
    }

    public Quaternion multLocal(Quaternion quaternion) {
        return this.multLocal(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion multLocal(float qx, float qy, float qz, float qw) {
        float nx = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        float ny = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        float nz = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        float nw = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        this.w = nw;
        return this;
    }

    public Vector3f multLocal(Vector3f vector) {
        float vx = vector.x;
        float vy = vector.y;
        float vz = vector.z;
        float tmp1 = 2.0f * (vx * this.x + vy * this.y + vz * this.z);
        float tmp2 = this.w * this.w - (this.x * this.x + this.y * this.y + this.z * this.z);
        vector.set(this.x, this.y, this.z).crossLocal(vx, vy, vz).multLocal(2.0f * this.w);
        vector.addLocal(vx * tmp2, vy * tmp2, vz * tmp2);
        vector.addLocal(this.x * tmp1, this.y * tmp1, this.z * tmp1);
        return vector;
    }

    public Quaternion multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Quaternion negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Quaternion normalizeLocal() {
        float n = (float)(1.0 / Math.sqrt(this.norm()));
        this.x *= n;
        this.y *= n;
        this.z *= n;
        this.w *= n;
        return this;
    }

    public float dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public float norm() {
        return this.dot(this);
    }

    public Quaternion lookAt(Vector3f direction) {
        return this.lookAt(direction, Vector3f.UNIT_Y);
    }

    public Quaternion lookAt(float directionx, float directiony, float directionz) {
        return this.lookAt(directionx, directiony, directionz, Vector3f.UNIT_Y);
    }

    public Quaternion lookAt(Vector3f direction, Vector3f up) {
        return this.lookAt(direction.x, direction.y, direction.z, up);
    }

    private Quaternion lookAt(float dirx, float diry, float dirz, Vector3f up) {
        float l = (float)Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        float m02 = dirx /= l;
        float m12 = diry /= l;
        float m22 = dirz /= l;
        float m00 = up.y * dirz - up.z * diry;
        float m10 = up.z * dirx - up.x * dirz;
        float m20 = up.x * diry - up.y * dirx;
        l = (float)Math.sqrt(m00 * m00 + m10 * m10 + m20 * m20);
        float m01 = diry * (m20 /= l) - dirz * (m10 /= l);
        float m11 = dirz * (m00 /= l) - dirx * m20;
        float m21 = dirx * m10 - diry * m00;
        l = (float)Math.sqrt(m01 * m01 + m11 * m11 + m21 * m21);
        return this.fromRotationMatrix(m00, m01 /= l, m02, m10, m11 /= l, m12, m20, m21 /= l, m22);
    }

    public Quaternion fromRotationMatrix(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float tr = m00 + m11 + m22;
        if (tr > 0.0f) {
            float s = (float)(Math.sqrt(tr + 1.0f) * 2.0);
            this.w = 0.25f * s;
            this.x = (m21 - m12) / s;
            this.y = (m02 - m20) / s;
            this.z = (m10 - m01) / s;
        } else if (m00 > m11 & m00 > m22) {
            float s = (float)(Math.sqrt(1.0f + m00 - m11 - m22) * 2.0);
            this.w = (m21 - m12) / s;
            this.x = 0.25f * s;
            this.y = (m01 + m10) / s;
            this.z = (m02 + m20) / s;
        } else if (m11 > m22) {
            float s = (float)(Math.sqrt(1.0f + m11 - m00 - m22) * 2.0);
            this.w = (m02 - m20) / s;
            this.x = (m01 + m10) / s;
            this.y = 0.25f * s;
            this.z = (m12 + m21) / s;
        } else {
            float s = (float)(Math.sqrt(1.0f + m22 - m00 - m11) * 2.0);
            this.w = (m10 - m01) / s;
            this.x = (m02 + m20) / s;
            this.y = (m12 + m21) / s;
            this.z = 0.25f * s;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o.getClass() != Quaternion.class) {
            return false;
        }
        Quaternion compare = (Quaternion)o;
        return this.x == compare.x && this.y == compare.y && this.z == compare.z && this.w == compare.w;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Float.floatToIntBits(this.x);
        hash = 89 * hash + Float.floatToIntBits(this.y);
        hash = 89 * hash + Float.floatToIntBits(this.z);
        hash = 89 * hash + Float.floatToIntBits(this.w);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

